"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DependenciesInventoryTable = DependenciesInventoryTable;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _analytics = require("@kbn/analytics");
var _ebtTools = require("@kbn/ebt-tools");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _lodash = require("lodash");
var _react2 = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _connections = require("../../../../../common/connections");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_time_range = require("../../../../hooks/use_time_range");
var _dependencies_table = require("../../../shared/dependencies_table");
var _dependency_link = require("../../../shared/links/dependency_link");
var _get_comparison_options = require("../../../shared/time_comparison/get_comparison_options");
var _random_sampler_badge = require("../random_sampler_badge");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/dependencies_inventory/dependencies_inventory_table/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const INITIAL_PAGE_SIZE = 25;
function DependenciesInventoryTable() {
  const {
    query: {
      rangeFrom,
      rangeTo,
      environment,
      kuery,
      comparisonEnabled,
      offset,
      page = 0,
      pageSize = INITIAL_PAGE_SIZE,
      sortDirection = _dependencies_table.INITIAL_SORTING_DIRECTION,
      sortField = _dependencies_table.INITIAL_SORTING_FIELD
    }
  } = (0, _use_apm_params.useApmParams)('/dependencies/inventory');
  const {
    onPageReady
  } = (0, _ebtTools.usePerformanceContext)();
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const trackEvent = (0, _public.useUiTracker)();
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (!start || !end) {
      return;
    }
    return callApmApi('GET /internal/apm/dependencies/top_dependencies', {
      params: {
        query: {
          start,
          end,
          environment,
          numBuckets: 8,
          kuery
        }
      }
    }).then(response => {
      return {
        ...response,
        requestId: (0, _uuid.v4)()
      };
    });
  }, [start, end, environment, kuery]);
  const visibleDependenciesNames = (0, _react2.useMemo)(() => data !== null && data !== void 0 && data.dependencies ? (0, _lodash.orderBy)(data.dependencies.map(item => ({
    name: (0, _connections.getNodeName)(item.location),
    impact: item.currentStats.impact,
    latency: item.currentStats.latency.value,
    throughput: item.currentStats.throughput.value,
    failureRate: item.currentStats.errorRate.value
  })), sortField, sortDirection).slice(page * pageSize, (page + 1) * pageSize).map(({
    name
  }) => name).sort() : undefined, [data === null || data === void 0 ? void 0 : data.dependencies, page, pageSize, sortDirection, sortField]);
  const {
    data: timeseriesData,
    status: timeseriesStatus
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (data !== null && data !== void 0 && data.requestId && visibleDependenciesNames !== null && visibleDependenciesNames !== void 0 && visibleDependenciesNames.length) {
      return callApmApi('POST /internal/apm/dependencies/top_dependencies/statistics', {
        params: {
          query: {
            start,
            end,
            environment,
            numBuckets: 8,
            offset: comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? offset : undefined,
            kuery
          },
          body: {
            dependencyNames: JSON.stringify(visibleDependenciesNames)
          }
        }
      });
    }
    return Promise.resolve();
  },
  // Disables exhaustive deps because the statistics api must only be called when the rendered items changed or when comparison is toggled or changed.
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [data === null || data === void 0 ? void 0 : data.requestId, visibleDependenciesNames, comparisonEnabled, offset],
  // Do not invalidate this API call when the refresh button is clicked
  {
    skipTimeRangeRefreshUpdate: true
  });
  (0, _react2.useEffect)(() => {
    if (status === _use_fetcher.FETCH_STATUS.SUCCESS) {
      onPageReady({
        meta: {
          rangeFrom,
          rangeTo,
          description: '[ttfmp_dependencies] Dependencies table is ready after fetching top_dependencies.'
        }
      });
    }
  }, [status, onPageReady, rangeFrom, rangeTo]);
  const dependencies = (0, _react2.useMemo)(() => {
    var _data$dependencies$ma;
    return (_data$dependencies$ma = data === null || data === void 0 ? void 0 : data.dependencies.map(dependency => {
      var _timeseriesData$curre, _timeseriesData$curre2, _timeseriesData$curre3, _dependency$previousS, _dependency$previousS2, _dependency$previousS3, _dependency$previousS4, _dependency$previousS5, _dependency$previousS6, _timeseriesData$compa, _timeseriesData$compa2, _dependency$previousS7, _dependency$previousS8, _timeseriesData$compa3, _timeseriesData$compa4, _dependency$previousS9, _dependency$previousS10, _timeseriesData$compa5, _timeseriesData$compa6;
      const {
        location
      } = dependency;
      const name = (0, _connections.getNodeName)(location);
      if (location.type !== _connections.NodeType.dependency) {
        throw new Error('Expected a dependency node');
      }
      const link = /*#__PURE__*/_react2.default.createElement(_dependency_link.DependencyLink, {
        type: location.spanType,
        subtype: location.spanSubtype,
        query: {
          dependencyName: location.dependencyName,
          comparisonEnabled,
          offset,
          environment,
          kuery,
          rangeFrom,
          rangeTo
        },
        onClick: () => {
          trackEvent({
            app: 'apm',
            metricType: _analytics.METRIC_TYPE.CLICK,
            metric: 'dependencies_inventory_to_dependency_detail'
          });
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 144,
          columnNumber: 11
        }
      });
      return {
        name,
        currentStats: {
          impact: dependency.currentStats.impact,
          totalTime: {
            value: dependency.currentStats.totalTime.value
          },
          latency: {
            value: dependency.currentStats.latency.value,
            timeseries: timeseriesData === null || timeseriesData === void 0 ? void 0 : (_timeseriesData$curre = timeseriesData.currentTimeseries[name]) === null || _timeseriesData$curre === void 0 ? void 0 : _timeseriesData$curre.latency
          },
          throughput: {
            value: dependency.currentStats.throughput.value,
            timeseries: timeseriesData === null || timeseriesData === void 0 ? void 0 : (_timeseriesData$curre2 = timeseriesData.currentTimeseries[name]) === null || _timeseriesData$curre2 === void 0 ? void 0 : _timeseriesData$curre2.throughput
          },
          errorRate: {
            value: dependency.currentStats.errorRate.value,
            timeseries: timeseriesData === null || timeseriesData === void 0 ? void 0 : (_timeseriesData$curre3 = timeseriesData.currentTimeseries[name]) === null || _timeseriesData$curre3 === void 0 ? void 0 : _timeseriesData$curre3.errorRate
          }
        },
        previousStats: {
          impact: (_dependency$previousS = (_dependency$previousS2 = dependency.previousStats) === null || _dependency$previousS2 === void 0 ? void 0 : _dependency$previousS2.impact) !== null && _dependency$previousS !== void 0 ? _dependency$previousS : 0,
          totalTime: {
            value: (_dependency$previousS3 = (_dependency$previousS4 = dependency.previousStats) === null || _dependency$previousS4 === void 0 ? void 0 : _dependency$previousS4.totalTime.value) !== null && _dependency$previousS3 !== void 0 ? _dependency$previousS3 : null
          },
          latency: {
            value: (_dependency$previousS5 = (_dependency$previousS6 = dependency.previousStats) === null || _dependency$previousS6 === void 0 ? void 0 : _dependency$previousS6.latency.value) !== null && _dependency$previousS5 !== void 0 ? _dependency$previousS5 : null,
            timeseries: timeseriesData === null || timeseriesData === void 0 ? void 0 : (_timeseriesData$compa = timeseriesData.comparisonTimeseries) === null || _timeseriesData$compa === void 0 ? void 0 : (_timeseriesData$compa2 = _timeseriesData$compa[name]) === null || _timeseriesData$compa2 === void 0 ? void 0 : _timeseriesData$compa2.latency
          },
          throughput: {
            value: (_dependency$previousS7 = (_dependency$previousS8 = dependency.previousStats) === null || _dependency$previousS8 === void 0 ? void 0 : _dependency$previousS8.throughput.value) !== null && _dependency$previousS7 !== void 0 ? _dependency$previousS7 : null,
            timeseries: timeseriesData === null || timeseriesData === void 0 ? void 0 : (_timeseriesData$compa3 = timeseriesData.comparisonTimeseries) === null || _timeseriesData$compa3 === void 0 ? void 0 : (_timeseriesData$compa4 = _timeseriesData$compa3[name]) === null || _timeseriesData$compa4 === void 0 ? void 0 : _timeseriesData$compa4.throughput
          },
          errorRate: {
            value: (_dependency$previousS9 = (_dependency$previousS10 = dependency.previousStats) === null || _dependency$previousS10 === void 0 ? void 0 : _dependency$previousS10.errorRate.value) !== null && _dependency$previousS9 !== void 0 ? _dependency$previousS9 : null,
            timeseries: timeseriesData === null || timeseriesData === void 0 ? void 0 : (_timeseriesData$compa5 = timeseriesData.comparisonTimeseries) === null || _timeseriesData$compa5 === void 0 ? void 0 : (_timeseriesData$compa6 = _timeseriesData$compa5[name]) === null || _timeseriesData$compa6 === void 0 ? void 0 : _timeseriesData$compa6.errorRate
          }
        },
        link
      };
    })) !== null && _data$dependencies$ma !== void 0 ? _data$dependencies$ma : [];
  }, [comparisonEnabled, data === null || data === void 0 ? void 0 : data.dependencies, environment, kuery, offset, rangeFrom, rangeTo, timeseriesData === null || timeseriesData === void 0 ? void 0 : timeseriesData.comparisonTimeseries, timeseriesData === null || timeseriesData === void 0 ? void 0 : timeseriesData.currentTimeseries, trackEvent]);
  const showRandomSamplerBadge = (data === null || data === void 0 ? void 0 : data.sampled) && status === _use_fetcher.FETCH_STATUS.SUCCESS;
  const fetchingStatus = (0, _use_fetcher.isPending)(status) || (0, _use_fetcher.isPending)(timeseriesStatus) ? _use_fetcher.FETCH_STATUS.LOADING : _use_fetcher.FETCH_STATUS.SUCCESS;
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
          min-height: ${euiTheme.size.l};
        `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 7
    }
  }, showRandomSamplerBadge && /*#__PURE__*/_react2.default.createElement(_random_sampler_badge.RandomSamplerBadge, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 36
    }
  })), /*#__PURE__*/_react2.default.createElement(_dependencies_table.DependenciesTable, {
    dependencies: dependencies,
    title: null,
    nameColumnTitle: _i18n.i18n.translate('xpack.apm.dependenciesInventory.dependencyTableColumn', {
      defaultMessage: 'Dependency'
    }),
    status: fetchingStatus,
    compact: false,
    initialPageSize: INITIAL_PAGE_SIZE,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 7
    }
  }));
}