"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartPreview = ChartPreview;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/data-plugin/public");
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
var _chartsTheme = require("@kbn/charts-theme");
var _timezone = require("../../../shared/charts/helper/timezone");
var _chart_preview_helper = require("./chart_preview_helper");
var _helper = require("../../utils/helper");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/alerting/ui_components/chart_preview/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ChartPreview({
  yTickFormat,
  threshold,
  uiSettings,
  series,
  timeSize = 5,
  timeUnit = 'm',
  totalGroups
}) {
  const theme = (0, _eui.useEuiTheme)();
  const baseTheme = (0, _chartsTheme.useElasticChartsTheme)();
  const thresholdOpacity = 0.3;
  const DEFAULT_DATE_FORMAT = 'Y-MM-DD HH:mm:ss';
  const style = {
    fill: theme.euiTheme.colors.vis.euiColorVis2,
    line: {
      strokeWidth: 2,
      stroke: theme.euiTheme.colors.vis.euiColorVis2,
      opacity: 1
    },
    opacity: thresholdOpacity
  };
  const barSeries = (0, _react.useMemo)(() => {
    return series.flatMap(serie => serie.data.map(point => ({
      ...point,
      groupBy: serie.name
    })));
  }, [series]);
  const timeZone = (0, _timezone.getTimeZone)(uiSettings);
  const legendSize = series.length > 1 ? Math.ceil(series.length / 2) * 30 : series.length * 35;
  const chartSize = 150;
  const {
    yMin,
    yMax,
    xMin,
    xMax
  } = (0, _chart_preview_helper.getDomain)(series);
  const chartDomain = {
    max: Math.max(yMax === 0 ? 1 : yMax, threshold) * 1.1,
    // Add 10% headroom.
    min: Math.min(yMin, threshold) * 0.9 // Add 10% headroom.
  };
  const dateFormatter = (0, _react.useMemo)(() => (0, _charts.niceTimeFormatter)([xMin, xMax]), [xMin, xMax]);
  const lookback = timeSize * _helper.ALERT_PREVIEW_BUCKET_SIZE;
  const timeLabel = _chart_preview_helper.TIME_LABELS[timeUnit];
  const rectDataValues = [{
    coordinates: {
      x0: xMin,
      x1: xMax,
      y0: threshold,
      y1: chartDomain.max
    }
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: chartSize + legendSize
    },
    "data-test-subj": "ChartPreview",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    headerFormatter: ({
      value
    }) => {
      const dateFormat = uiSettings && uiSettings.get(_public.UI_SETTINGS.DATE_FORMAT) || DEFAULT_DATE_FORMAT;
      return (0, _moment.default)(value).format(dateFormat);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    showLegend: true,
    legendPosition: 'bottom',
    legendSize: legendSize,
    locale: _i18n.i18n.getLocale(),
    baseTheme: baseTheme,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
    dataValues: [{
      dataValue: threshold
    }],
    domainType: _charts.AnnotationDomainType.YDomain,
    id: "chart_preview_line_annotation",
    markerPosition: "left",
    style: style,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.RectAnnotation, {
    dataValues: rectDataValues,
    hideTooltips: true,
    id: "chart_preview_rect_annotation",
    style: style,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "chart_preview_x_axis",
    position: _charts.Position.Bottom,
    showOverlappingTicks: true,
    tickFormat: dateFormatter,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "chart_preview_y_axis",
    position: _charts.Position.Left,
    tickFormat: yTickFormat,
    ticks: 5,
    domain: chartDomain,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: "apm-chart-preview",
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "x",
    yAccessors: ['y'],
    splitSeriesAccessors: ['groupBy'],
    data: barSeries,
    barSeriesStyle: {
      rectBorder: {
        strokeWidth: 1,
        visible: true
      },
      rect: {
        opacity: 1
      }
    },
    timeZone: timeZone,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 9
    }
  })), series.length > 0 && /*#__PURE__*/_react.default.createElement(_chart_preview_helper.TimeLabelForData, {
    lookback: lookback,
    timeLabel: timeLabel,
    displayedGroups: series.length,
    totalGroups: totalGroups,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 9
    }
  }));
}