"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fieldValuePairToKql = fieldValuePairToKql;
var _esQuery = require("@kbn/es-query");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function fieldValuePairToKql(field, value) {
  if ((0, _lodash.isNil)(value) || (0, _lodash.isEmpty)(value)) {
    return [];
  }
  const escapedValue = (0, _esQuery.escapeKuery)(value.toString());
  return [`${[field]}: ${escapedValue}`];
}