"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TaskRunnerFactory = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _task_runner = require("./task_runner");
var _saved_objects = require("../saved_objects");
var _ad_hoc_task_runner = require("./ad_hoc_task_runner");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class TaskRunnerFactory {
  constructor() {
    (0, _defineProperty2.default)(this, "isInitialized", false);
    (0, _defineProperty2.default)(this, "taskRunnerContext", void 0);
  }
  initialize(taskRunnerContext) {
    if (this.isInitialized) {
      throw new Error('TaskRunnerFactory already initialized');
    }
    this.isInitialized = true;
    this.taskRunnerContext = taskRunnerContext;
  }
  create(ruleType, {
    taskInstance
  }, inMemoryMetrics) {
    if (!this.isInitialized) {
      throw new Error('TaskRunnerFactory not initialized');
    }
    return new _task_runner.TaskRunner({
      context: this.taskRunnerContext,
      inMemoryMetrics,
      internalSavedObjectsRepository: this.taskRunnerContext.savedObjects.createInternalRepository([_saved_objects.RULE_SAVED_OBJECT_TYPE]),
      ruleType,
      taskInstance
    });
  }
  createAdHoc({
    taskInstance
  }) {
    if (!this.isInitialized) {
      throw new Error('TaskRunnerFactory not initialized');
    }
    return new _ad_hoc_task_runner.AdHocTaskRunner({
      taskInstance,
      context: this.taskRunnerContext,
      internalSavedObjectsRepository: this.taskRunnerContext.savedObjects.createInternalRepository([_saved_objects.RULE_SAVED_OBJECT_TYPE, _saved_objects.AD_HOC_RUN_SAVED_OBJECT_TYPE])
    });
  }
}
exports.TaskRunnerFactory = TaskRunnerFactory;