"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createOrUpdateIlmPolicy = void 0;
var _retry_transient_es_errors = require("./retry_transient_es_errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Creates ILM policy if it doesn't already exist, updates it if it does
 */
const createOrUpdateIlmPolicy = async ({
  logger,
  esClient,
  name,
  policy,
  dataStreamAdapter
}) => {
  if (dataStreamAdapter.isUsingDataStreams()) return;
  logger.debug(`Installing ILM policy ${name}`);
  try {
    await (0, _retry_transient_es_errors.retryTransientEsErrors)(() => esClient.ilm.putLifecycle({
      name,
      policy
    }), {
      logger
    });
  } catch (err) {
    logger.error(`Error installing ILM policy ${name} - ${err.message}`);
    throw err;
  }
};
exports.createOrUpdateIlmPolicy = createOrUpdateIlmPolicy;