"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findMaintenanceWindowsResponseSchema = exports.findMaintenanceWindowsQuerySchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _response = require("../../../response");
var _v = require("../../../../shared/schemas/v1");
var _v2 = require("../../../../shared/validation/v1");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const findMaintenanceWindowsQuerySchema = exports.findMaintenanceWindowsQuerySchema = _configSchema.schema.object({
  title: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'The title of the maintenance window.'
    }
  })),
  created_by: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'The user who created the maintenance window.'
    }
  })),
  status: _configSchema.schema.maybe(_configSchema.schema.oneOf([_v.maintenanceWindowStatusSchema, _configSchema.schema.arrayOf(_v.maintenanceWindowStatusSchema)], {
    meta: {
      description: 'The status of the maintenance window. One of "running", "upcoming", "finished", "archived", or "disabled".'
    }
  })),
  page: _v.maintenanceWindowPageSchema,
  per_page: _v.maintenanceWindowPerPageSchema
}, {
  validate: _v2.validatePagination
});
const findMaintenanceWindowsResponseSchema = exports.findMaintenanceWindowsResponseSchema = _configSchema.schema.object({
  page: _configSchema.schema.number(),
  per_page: _configSchema.schema.number(),
  total: _configSchema.schema.number(),
  maintenanceWindows: _configSchema.schema.arrayOf(_response.maintenanceWindowResponseSchemaV1)
});