"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PatternAnalysisEmbeddableInitializer = exports.FormControls = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _aiopsUtils = require("@kbn/aiops-utils");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
var _use_data_source = require("../../hooks/use_data_source");
var _embeddable_menu = require("../../components/log_categorization/log_categorization_for_embeddable/embeddable_menu");
var _time_field_warning = require("../../components/time_field_warning");
var _sampling_menu = require("../../components/log_categorization/sampling_menu");
var _random_sampler = require("../../components/log_categorization/sampling_menu/random_sampler");
var _minimum_time_range = require("../../components/log_categorization/log_categorization_for_embeddable/minimum_time_range");
var _field_selector = require("../../components/log_categorization/log_categorization_for_embeddable/field_selector");
var _sampling_panel = require("../../components/log_categorization/sampling_menu/sampling_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764590851516812192/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/embeddables/pattern_analysis/pattern_analysis_initializer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PatternAnalysisEmbeddableInitializer = ({
  initialInput,
  onCreate,
  onCancel,
  onPreview,
  isNewPanel
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    data: {
      dataViews
    },
    unifiedSearch: {
      ui: {
        IndexPatternSelect
      }
    }
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const [formInput, setFormInput] = (0, _react.useState)((0, _lodash.pick)(initialInput !== null && initialInput !== void 0 ? initialInput : {
    minimumTimeRangeOption: _minimum_time_range.DEFAULT_MINIMUM_TIME_RANGE_OPTION,
    randomSamplerMode: _random_sampler.RANDOM_SAMPLER_OPTION.ON_AUTOMATIC,
    randomSamplerProbability: _random_sampler.DEFAULT_PROBABILITY
  }, ['dataViewId', 'fieldName', 'minimumTimeRangeOption', 'randomSamplerMode', 'randomSamplerProbability']));
  const [isFormValid, setIsFormValid] = (0, _react.useState)(true);
  const updatedProps = (0, _react.useMemo)(() => {
    return {
      ...formInput,
      title: (0, _mlIsPopulatedObject.isPopulatedObject)(formInput) ? _i18n.i18n.translate('xpack.aiops.embeddablePatternAnalysis.attachmentTitle', {
        defaultMessage: 'Pattern analysis: {fieldName}',
        values: {
          fieldName: formInput.fieldName
        }
      }) : ''
    };
  }, [formInput]);
  (0, _react.useEffect)(function previewChanges() {
    if (isFormValid && updatedProps.fieldName !== undefined) {
      onPreview(updatedProps);
    }
  }, [isFormValid, onPreview, updatedProps]);
  const setDataViewId = (0, _react.useCallback)(dataViewId => {
    setFormInput({
      ...formInput,
      dataViewId: dataViewId !== null && dataViewId !== void 0 ? dataViewId : '',
      fieldName: undefined
    });
    setIsFormValid(false);
  }, [formInput]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    css: {
      pointerEvents: 'auto',
      backgroundColor: euiTheme.colors.emptyShade
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    "data-test-subj": "inlineEditingFlyoutLabel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 11
    }
  }, isNewPanel ? _i18n.i18n.translate('xpack.aiops.embeddablePatternAnalysis.config.title.new', {
    defaultMessage: 'Create pattern analysis'
  }) : _i18n.i18n.translate('xpack.aiops.embeddablePatternAnalysis.config.title.edit', {
    defaultMessage: 'Edit pattern analysis'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.aiops.embeddablePatternAnalysis.config.dataViewLabel', {
      defaultMessage: 'Data view'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(IndexPatternSelect, {
    autoFocus: !formInput.dataViewId,
    fullWidth: true,
    compressed: true,
    indexPatternId: formInput.dataViewId,
    placeholder: _i18n.i18n.translate('xpack.aiops.embeddablePatternAnalysis.config.dataViewSelectorPlaceholder', {
      defaultMessage: 'Select data view'
    }),
    onChange: newId => {
      setDataViewId(newId !== null && newId !== void 0 ? newId : '');
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_use_data_source.DataSourceContextProvider, {
    dataViews: dataViews,
    dataViewId: formInput.dataViewId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(FormControls, {
    formInput: formInput,
    onChange: setFormInput,
    onValidationChange: setIsFormValid,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "primary",
    size: "m",
    onClick: onCancel,
    "data-test-subj": "aiopsPatternAnalysisCancelButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.aiops.embeddablePatternAnalysis.config.cancelButtonLabel",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onCreate.bind(null, updatedProps),
    fill: true,
    "aria-label": _i18n.i18n.translate('xpack.aiops.embeddablePatternAnalysis.config.applyFlyoutAriaLabel', {
      defaultMessage: 'Apply changes'
    }),
    isDisabled: !isFormValid,
    iconType: "check",
    "data-test-subj": "aiopsPatternAnalysisConfirmButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.aiops.embeddablePatternAnalysis.config.applyAndCloseLabel",
    defaultMessage: "Apply and close",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 15
    }
  }))))));
};
exports.PatternAnalysisEmbeddableInitializer = PatternAnalysisEmbeddableInitializer;
const FormControls = ({
  formInput,
  onChange,
  onValidationChange
}) => {
  const dataViewId = formInput.dataViewId;
  const {
    data: {
      dataViews
    }
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const [fields, setFields] = (0, _react.useState)([]);
  const [selectedField, setSelectedField] = (0, _react.useState)(null);
  const [isDataViewTimeBased, setIsDataViewTimeBased] = (0, _react.useState)(true);
  const randomSampler = (0, _react.useMemo)(() => {
    var _formInput$randomSamp, _formInput$randomSamp2;
    return new _sampling_menu.RandomSampler({
      randomSamplerMode: (_formInput$randomSamp = formInput.randomSamplerMode) !== null && _formInput$randomSamp !== void 0 ? _formInput$randomSamp : _random_sampler.RANDOM_SAMPLER_OPTION.ON_AUTOMATIC,
      setRandomSamplerMode: () => {},
      randomSamplerProbability: (_formInput$randomSamp2 = formInput.randomSamplerProbability) !== null && _formInput$randomSamp2 !== void 0 ? _formInput$randomSamp2 : _random_sampler.DEFAULT_PROBABILITY,
      setRandomSamplerProbability: () => {}
    });
  }, [formInput.randomSamplerMode, formInput.randomSamplerProbability]);
  const randomSamplerMode = (0, _useObservable.default)(randomSampler.getMode$(), randomSampler.getMode());
  const randomSamplerProbability = (0, _useObservable.default)(randomSampler.getProbability$(), randomSampler.getProbability());
  const isMounted = (0, _useMountedState.default)();
  (0, _react.useEffect)(function initFields() {
    if (!dataViewId) {
      setFields([]);
      setSelectedField(null);
      return;
    }
    dataViews.get(dataViewId).then(dataView => {
      var _ref;
      if (!isMounted()) {
        return;
      }
      const isTimeBased = dataView.isTimeBased();
      setIsDataViewTimeBased(isTimeBased);
      if (isTimeBased === false) {
        setFields([]);
        setSelectedField(null);
        return;
      }
      const {
        dataViewFields,
        messageField
      } = (0, _aiopsUtils.getCategorizationDataViewField)(dataView);
      setFields(dataViewFields);
      const field = dataViewFields.find(f => f.name === formInput.fieldName);
      if (formInput.fieldName === undefined) {
        // form input does not contain a field name, select the found message field
        setSelectedField(messageField !== null && messageField !== void 0 ? messageField : null);
        return;
      }
      // otherwise, select the field from the form input
      setSelectedField((_ref = field !== null && field !== void 0 ? field : messageField) !== null && _ref !== void 0 ? _ref : null);
    }).catch(() => {
      setFields([]);
      setSelectedField(null);
    });
  }, [dataViewId, dataViews, formInput, isMounted, onChange]);
  (0, _react.useEffect)(function validateForm() {
    onValidationChange(selectedField !== null && formInput.dataViewId !== undefined);
  }, [selectedField, formInput, onValidationChange]);
  (0, _react.useEffect)(function samplerChange() {
    onChange({
      ...formInput,
      randomSamplerMode,
      randomSamplerProbability
    });
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [onChange, randomSamplerMode, randomSamplerProbability]);
  (0, _react.useEffect)(function samplerChange() {
    if (selectedField === null) {
      return;
    }
    onChange({
      ...formInput,
      fieldName: selectedField.name
    });
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [onChange, selectedField]);
  const setMinimumTimeRangeOption = option => {
    onChange({
      ...formInput,
      minimumTimeRangeOption: option
    });
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_field_selector.FieldSelector, {
    fields: fields,
    selectedField: selectedField,
    setSelectedField: setSelectedField,
    WarningComponent: isDataViewTimeBased === false ? _time_field_warning.TimeFieldWarning : fields.length === 0 ? TextFieldWarning : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 338,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 351,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_embeddable_menu.PatternAnalysisSettings, {
    categoryCount: undefined,
    minimumTimeRangeOption: formInput.minimumTimeRangeOption,
    setMinimumTimeRangeOption: setMinimumTimeRangeOption,
    compressed: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 353,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 360,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_sampling_panel.SamplingPanel, {
    randomSampler: randomSampler,
    reload: () => {},
    calloutPosition: "bottom",
    displayProbability: false,
    compressed: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 362,
      columnNumber: 7
    }
  }));
};
exports.FormControls = FormControls;
const TextFieldWarning = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    title: _i18n.i18n.translate('xpack.aiops.logCategorization.embeddableMenu.textFieldWarning.title', {
      defaultMessage: 'The selected data view does not contain any text fields.'
    }),
    color: "warning",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 376,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 387,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.aiops.logCategorization.embeddableMenu.textFieldWarning.title.description', {
    defaultMessage: 'Pattern analysis can only be run on data views with a text field.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 396,
      columnNumber: 7
    }
  }));
};