"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiSideNavItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _href_validator = require("../../services/security/href_validator");
var _inner_text = require("../inner_text");
var _icon = require("../icon");
var _side_nav_item = require("./side_nav_item.styles");
var _react2 = require("@emotion/react");
var _excluded = ["href", "target", "rel", "onClick", "className", "children", "disabled"],
  _excluded2 = ["isOpen", "isSelected", "isParent", "icon", "onClick", "href", "rel", "target", "items", "children", "renderItem", "depth", "className", "css", "style", "truncate", "emphasize", "buttonClassName", "childrenOnly"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/**
 * The props that are exposed to, or altered for, the consumer
 * for use in the object of items in `EuiSideNav`
 * can be found in the `side_nave_types.ts` file.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var DefaultRenderItem = function DefaultRenderItem(_ref) {
  var href = _ref.href,
    target = _ref.target,
    rel = _ref.rel,
    onClick = _ref.onClick,
    className = _ref.className,
    children = _ref.children,
    disabled = _ref.disabled,
    rest = _objectWithoutProperties(_ref, _excluded);
  if (href && !disabled) {
    var secureRel = (0, _services.getSecureRelForTarget)({
      href: href,
      rel: rel,
      target: target
    });
    return (0, _react2.jsx)("a", _extends({
      className: className,
      href: href,
      target: target,
      rel: secureRel,
      onClick: onClick
    }, rest), children);
  }
  if (onClick || disabled) {
    return (0, _react2.jsx)("button", _extends({
      type: "button",
      className: className,
      onClick: onClick,
      disabled: disabled
    }, rest), children);
  }
  return (0, _react2.jsx)("div", _extends({
    className: className
  }, rest), children);
};
var EuiSideNavItem = exports.EuiSideNavItem = function EuiSideNavItem(_ref2) {
  var isOpen = _ref2.isOpen,
    isSelected = _ref2.isSelected,
    isParent = _ref2.isParent,
    icon = _ref2.icon,
    onClick = _ref2.onClick,
    _href = _ref2.href,
    rel = _ref2.rel,
    target = _ref2.target,
    items = _ref2.items,
    children = _ref2.children,
    _ref2$renderItem = _ref2.renderItem,
    RenderItem = _ref2$renderItem === void 0 ? DefaultRenderItem : _ref2$renderItem,
    _ref2$depth = _ref2.depth,
    depth = _ref2$depth === void 0 ? 0 : _ref2$depth,
    className = _ref2.className,
    css = _ref2.css,
    style = _ref2.style,
    _ref2$truncate = _ref2.truncate,
    truncate = _ref2$truncate === void 0 ? true : _ref2$truncate,
    emphasize = _ref2.emphasize,
    buttonClassName = _ref2.buttonClassName,
    childrenOnly = _ref2.childrenOnly,
    rest = _objectWithoutProperties(_ref2, _excluded2);
  var isHrefValid = !_href || (0, _href_validator.validateHref)(_href);
  var href = isHrefValid ? _href : '';

  // Forcing accordion style item if not linked, but has children
  var _useState = (0, _react.useState)(isOpen),
    _useState2 = _slicedToArray(_useState, 2),
    itemIsOpen = _useState2[0],
    setItemIsOpen = _useState2[1];
  (0, _react.useEffect)(function () {
    setItemIsOpen(isOpen);
  }, [isOpen]);
  var toggleItemOpen = (0, _react.useCallback)(function () {
    setItemIsOpen(function (isOpen) {
      return !isOpen;
    });
  }, []);
  var isRoot = depth === 0;
  var isTrunk = depth === 1;
  var isBranch = depth > 1;
  var hasCaret = depth > 0 && childrenOnly;
  var hasChildItems = items && itemIsOpen;
  var classes = (0, _classnames.default)('euiSideNavItem', {
    'euiSideNavItem--root': isRoot,
    'euiSideNavItem--trunk': isTrunk,
    'euiSideNavItem--branch': isBranch,
    'euiSideNavItem--emphasized': emphasize,
    'euiSideNavItem-hasChildItems': hasChildItems
  }, className);
  var styles = (0, _services.useEuiMemoizedStyles)(_side_nav_item.euiSideNavItemStyles);
  var cssStyles = [styles.euiSideNavItem, isRoot && styles.root, isTrunk && styles.trunk, isBranch && styles.branch, emphasize && styles.emphasized, css];
  var itemsStyles = hasChildItems && [styles.items.euiSideNavItem__items, isRoot && icon && styles.items.rootWithIcon, isTrunk && styles.items.trunk, isBranch && styles.items.branch];
  var buttonClasses = (0, _classnames.default)('euiSideNavItemButton', {
    'euiSideNavItemButton-isOpen': depth > 0 && itemIsOpen && !isSelected,
    'euiSideNavItemButton-isSelected': isSelected
  }, buttonClassName);
  var buttonStyles = (0, _services.useEuiMemoizedStyles)(_side_nav_item.euiSideNavItemButtonStyles);
  var buttonCssStyles = [buttonStyles.euiSideNavItemButton, isSelected && buttonStyles.selected, emphasize && buttonStyles.emphasized, isRoot && buttonStyles.root, isTrunk && buttonStyles.trunk, isBranch && buttonStyles.branch];
  var labelCssStyles = [buttonStyles.label.euiSideNavItemButton__label, isRoot && buttonStyles.label.root];
  return (0, _react2.jsx)("div", {
    css: cssStyles,
    className: classes,
    style: style
  }, (0, _react2.jsx)(RenderItem, _extends({
    css: buttonCssStyles,
    className: buttonClasses,
    href: href,
    rel: rel,
    target: target,
    onClick: childrenOnly ? toggleItemOpen : onClick
  }, rest), (0, _react2.jsx)("span", {
    css: buttonStyles.euiSideNavItemButton__content,
    className: "euiSideNavItemButton__content"
  }, icon, (0, _react2.jsx)(_inner_text.EuiInnerText, null, function (ref, innerText) {
    return (0, _react2.jsx)("span", {
      ref: ref,
      title: truncate ? innerText : undefined,
      css: labelCssStyles,
      className: (0, _classnames.default)('euiSideNavItemButton__label', {
        'eui-textTruncate': truncate
      })
    }, children);
  }), hasCaret && (0, _react2.jsx)(_icon.EuiIcon, {
    type: itemIsOpen ? 'arrowDown' : 'arrowRight',
    size: "s"
  }))), hasChildItems && (0, _react2.jsx)("div", {
    css: itemsStyles,
    className: "euiSideNavItem__items"
  }, items));
};