"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Circline = void 0;
exports.wrapToTau = wrapToTau;
exports.diffAngle = diffAngle;
exports.meanAngle = meanAngle;
exports.trueBearingToStandardPositionAngle = trueBearingToStandardPositionAngle;
const constants_1 = require("./constants");
class Circline {
    x = NaN;
    y = NaN;
    r = NaN;
}
exports.Circline = Circline;
function wrapToTau(a) {
    if (0 <= a && a <= constants_1.TAU)
        return a;
    if (a < 0)
        a -= constants_1.TAU * Math.floor(a / constants_1.TAU);
    return a > constants_1.TAU ? a % constants_1.TAU : a;
}
function diffAngle(a, b) {
    return ((a - b + Math.PI + constants_1.TAU) % constants_1.TAU) - Math.PI;
}
function meanAngle(a, b) {
    return (constants_1.TAU + b + diffAngle(a, b) / 2) % constants_1.TAU;
}
function trueBearingToStandardPositionAngle(alphaIn) {
    return wrapToTau(constants_1.RIGHT_ANGLE - alphaIn);
}
//# sourceMappingURL=geometry.js.map