"use strict";
/*
 * ELASTICSEARCH CONFIDENTIAL
 * __________________
 *
 *  Copyright Elasticsearch B.V. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Elasticsearch B.V. and its suppliers, if any.
 * The intellectual and technical concepts contained herein
 * are proprietary to Elasticsearch B.V. and its suppliers and
 * may be covered by U.S. and Foreign Patents, patents in
 * process, and are protected by trade secret or copyright
 * law.  Dissemination of this information or reproduction of
 * this material is strictly forbidden unless prior written
 * permission is obtained from Elasticsearch B.V.
 */
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElasticLicense = exports.Constants = exports.ConfigurationService = exports.configSchema = void 0;
var joi_1 = __importDefault(require("joi"));
var server_ssl_config_1 = require("./server_ssl_config");
var elasticsearch_config_1 = require("./elasticsearch_config");
var read_config_1 = require("../utils/read_config");
var ElasticLicense;
(function (ElasticLicense) {
    ElasticLicense[ElasticLicense["oss"] = 0] = "oss";
    ElasticLicense[ElasticLicense["basic"] = 1] = "basic";
    ElasticLicense[ElasticLicense["gold"] = 2] = "gold";
    ElasticLicense[ElasticLicense["platinum"] = 3] = "platinum";
    ElasticLicense[ElasticLicense["enterprise"] = 4] = "enterprise";
    ElasticLicense[ElasticLicense["trial"] = 5] = "trial";
})(ElasticLicense || (exports.ElasticLicense = ElasticLicense = {}));
var ZoomLevel = [
    {
        zoom: 8,
        description: 'Large metropolitan area',
        size: 550589295,
        scale: 2000000,
    },
    {
        zoom: 9,
        description: 'Metropolitan area',
        size: 1550719650,
        scale: 1000000,
    },
    {
        zoom: 10,
        description: 'City',
        size: 3451064874,
        scale: 500000,
    },
    {
        zoom: 11,
        description: 'Town',
        size: 7455419339,
        scale: 250000,
    },
    {
        zoom: 12,
        description: 'Village',
        size: 16157726605,
        scale: 150000,
    },
    {
        zoom: 13,
        description: 'Neighborhood',
        size: 33093306850,
        scale: 70000,
    },
    {
        zoom: 14,
        description: 'City block',
        size: 78588033033,
        scale: 35000,
    },
];
var Constants = /** @class */ (function () {
    function Constants() {
    }
    Constants.ELASTIC_REQUIRED_LICENSE = ElasticLicense.enterprise;
    Constants.PLANET_MAX_ZOOM = 14;
    Constants.DEFAULT_EMS_PATH_CONF = '/usr/src/app/server/config/elastic-maps-server.yml';
    Constants.DEFAULT_EMS_SERVER_BASEPATH = '';
    Constants.DEFAULT_LOG_LEVEL = 'info';
    Constants.DEFAULT_LOG_PATH = '/var/log/elastic-maps-server/elastic-maps-server.log';
    Constants.ELASTIC_CHECK_INTERVAL = 30000;
    Constants.HTTP_INTERNAL_PORT = 8080;
    Constants.ELASTIC_CONNECT_RETRIES = 3;
    Constants.ELASTIC_CONNECT_RETRY_MULTIPLY = 1000;
    Constants.HEALTHCHECK_TILE = [4, 9, 10];
    Constants.BASEMAPS_DOWNLOAD_BASE = 'https://download.elastic.co/elastic-maps-server/';
    Constants.BASEMAPS_ZOOM_LEVELS = ZoomLevel;
    Constants.BASEMAPS_OMT_VERSION = '3.14.x';
    Constants.MBTILES_METADATA = {
        name: 'Elastic Maps Server',
        description: 'Elastic Maps Server vector tiles basemaps',
        attribution: '© <a rel="noreferrer noopener" href="https://www.openstreetmap.org/copyright">OpenStreetMap contributors</a> | <a rel="noreferrer noopener" href="https://openmaptiles.org">OpenMapTiles</a> | <a rel="noreferrer noopener" href="https://www.elastic.co/elastic-maps-service">Elastic Maps Service</a>',
        tilejson: '2.0.0',
        tiles: ['./data/v3/{z}/{x}/{y}.pbf'],
    };
    Constants.DEFAULT_FONT_STACK = 'Noto Sans Regular';
    Constants.EMS_PLATFORM = 'ubi';
    return Constants;
}());
exports.Constants = Constants;
var configSchema = joi_1.default.object({
    host: joi_1.default.string(),
    port: joi_1.default.number(),
    basePath: joi_1.default.string()
        .allow('')
        .pattern(/^$|^\/.*$/)
        .default(''),
    elasticsearch: elasticsearch_config_1.elasticsearchSchema.required(),
    path: joi_1.default.object({
        ems: joi_1.default.string().default('/usr/src/app'),
        planet: joi_1.default.string().default('/usr/src/app/data/planet.mbtiles'),
    }).default(),
    logging: joi_1.default.object({
        level: joi_1.default.string()
            .valid('trace', 'debug', 'info', 'warn', 'error', 'fatal', 'silent')
            .default('info'),
    }).default(),
    ssl: server_ssl_config_1.serverSslSchema,
    ui: joi_1.default.boolean().default(true),
}).default();
exports.configSchema = configSchema;
/*
 * Elastic Maps Server Configuration. The class constructor accepts the raw yaml config and
 * overrides config values with any matching environment variables. The config
 * is then validated against the configSchema and reports errors if any config values
 * are invalid.
 */
var ConfigurationService = /** @class */ (function () {
    function ConfigurationService(_conf, logger) {
        var e_1, _a;
        this._conf = _conf;
        this.logger = logger;
        var rawConfig = this._applyEnvVariableOverrides(_conf);
        var _b = configSchema.validate(rawConfig), value = _b.value, error = _b.error;
        if (error) {
            var errorMessage = 'Error validating config file';
            var errorMap = new Map();
            try {
                for (var _c = __values(error.details), _d = _c.next(); !_d.done; _d = _c.next()) {
                    var detail = _d.value;
                    var flatPath = detail.path.join('.');
                    errorMap.set(flatPath, detail.message);
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
                }
                finally { if (e_1) throw e_1.error; }
            }
            this.logger.error({ errors: Object.fromEntries(errorMap) }, errorMessage);
            throw new TypeError(errorMessage);
        }
        var host = value.host, port = value.port, basePath = value.basePath, logging = value.logging, path = value.path, elasticsearch = value.elasticsearch, ssl = value.ssl, ui = value.ui;
        // Set logging level based on config
        if (logging === null || logging === void 0 ? void 0 : logging.level) {
            this.logger.level = value.logging.level;
        }
        this.host = host;
        this.port = port;
        this.basePath = basePath;
        this.appPaths = path;
        this.elasticsearchConfig = new elasticsearch_config_1.ElasticsearchConfig(elasticsearch);
        this.ssl = new server_ssl_config_1.ServerSslConfig(ssl);
        this.ui = ui;
    }
    ConfigurationService.prototype._applyEnvVariableOverrides = function (rawConfig) {
        var e_2, _a;
        var _b;
        var configKeys = new Set();
        getJoiSchemaKeys(configKeys, configSchema.describe());
        var _loop_1 = function (key, type) {
            var matchingEnvVar = key.replace(/\./g, '_').toUpperCase();
            switch (type) {
                case 'string':
                case 'number':
                    if (matchingEnvVar in process.env) {
                        this_1.logger.info("Overriding {".concat(key, "} with an environment variable"));
                        rawConfig = (0, read_config_1.merge)(rawConfig, process.env[matchingEnvVar], key);
                    }
                    break;
                case 'boolean':
                    if (matchingEnvVar in process.env) {
                        var value = (_b = process.env[matchingEnvVar]) === null || _b === void 0 ? void 0 : _b.toLowerCase();
                        if (value === 'true' || value === 'false') {
                            this_1.logger.info("Overriding {".concat(key, "} with an environment variable"));
                            rawConfig = (0, read_config_1.merge)(rawConfig, value === 'true', key);
                        }
                        else {
                            throw new TypeError("Environment variable {".concat(key, "} is invalid"));
                        }
                    }
                    break;
                case 'array':
                    var envVars = Object.keys(process.env)
                        .filter(function (k) { return k.startsWith(matchingEnvVar); })
                        .map(function (k) { return process.env[k]; });
                    if (envVars.length > 0) {
                        this_1.logger.info("Overriding {".concat(key, "} with {").concat(envVars.length, "} environment variables"));
                        rawConfig = (0, read_config_1.merge)(rawConfig, envVars, key);
                    }
                default:
                    break;
            }
        };
        var this_1 = this;
        try {
            for (var configKeys_1 = __values(configKeys), configKeys_1_1 = configKeys_1.next(); !configKeys_1_1.done; configKeys_1_1 = configKeys_1.next()) {
                var _c = __read(configKeys_1_1.value, 2), key = _c[0], type = _c[1];
                _loop_1(key, type);
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (configKeys_1_1 && !configKeys_1_1.done && (_a = configKeys_1.return)) _a.call(configKeys_1);
            }
            finally { if (e_2) throw e_2.error; }
        }
        return rawConfig;
    };
    return ConfigurationService;
}());
exports.ConfigurationService = ConfigurationService;
var getJoiSchemaKeys = function (configKeys, schema, keyPrefix) {
    var e_3, _a;
    if (keyPrefix === void 0) { keyPrefix = ''; }
    try {
        for (var _b = __values(Object.entries(schema.keys)), _c = _b.next(); !_c.done; _c = _b.next()) {
            var _d = __read(_c.value, 2), k = _d[0], v = _d[1];
            var key = keyPrefix + k;
            if (v.type === 'object') {
                getJoiSchemaKeys(configKeys, v, "".concat(key, "."));
            }
            else {
                configKeys.add([key, v.type]);
            }
        }
    }
    catch (e_3_1) { e_3 = { error: e_3_1 }; }
    finally {
        try {
            if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
        }
        finally { if (e_3) throw e_3.error; }
    }
};
//# sourceMappingURL=config_service.js.map