/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.blockhash;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BitArray;
import org.elasticsearch.common.util.BytesRefArray;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.aggregation.blockhash.BlockHash;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.OrdinalBytesRefBlock;
import org.elasticsearch.compute.data.OrdinalBytesRefVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;
import org.elasticsearch.core.Releasables;

public final class TimeSeriesBlockHash
extends BlockHash {
    private final int tsHashChannel;
    private final int timestampIntervalChannel;
    private int lastTsidPosition = 0;
    private final BytesRefArrayWithSize tsidArray;
    private long lastTimestamp;
    private final LongArrayWithSize timestampArray;
    private int currentTimestampCount;
    private final IntArrayWithSize perTsidCountArray;

    public TimeSeriesBlockHash(int tsHashChannel, int timestampIntervalChannel, BlockFactory blockFactory) {
        super(blockFactory);
        this.tsHashChannel = tsHashChannel;
        this.timestampIntervalChannel = timestampIntervalChannel;
        this.tsidArray = new BytesRefArrayWithSize(blockFactory);
        this.timestampArray = new LongArrayWithSize(blockFactory);
        this.perTsidCountArray = new IntArrayWithSize(blockFactory);
    }

    public void close() {
        Releasables.close((Releasable[])new Releasable[]{this.tsidArray, this.timestampArray, this.perTsidCountArray});
    }

    private OrdinalBytesRefVector getTsidVector(Page page) {
        BytesRefBlock block = (BytesRefBlock)page.getBlock(this.tsHashChannel);
        OrdinalBytesRefBlock ordinalBlock = block.asOrdinals();
        if (ordinalBlock == null) {
            throw new IllegalStateException("expected ordinal block for tsid");
        }
        OrdinalBytesRefVector ordinalVector = ordinalBlock.asVector();
        if (ordinalVector == null) {
            throw new IllegalStateException("expected ordinal vector for tsid");
        }
        return ordinalVector;
    }

    private LongVector getTimestampVector(Page page) {
        LongBlock timestampsBlock = (LongBlock)page.getBlock(this.timestampIntervalChannel);
        LongVector timestampsVector = timestampsBlock.asVector();
        if (timestampsVector == null) {
            throw new IllegalStateException("expected long vector for timestamp");
        }
        return timestampsVector;
    }

    @Override
    public void add(Page page, GroupingAggregatorFunction.AddInput addInput) {
        OrdinalBytesRefVector tsidVector = this.getTsidVector(page);
        BytesRefVector tsidDict = tsidVector.getDictionaryVector();
        IntVector tsidOrdinals = tsidVector.getOrdinalsVector();
        try (IntVector.Builder ordsBuilder = this.blockFactory.newIntVectorBuilder(tsidOrdinals.getPositionCount());){
            BytesRef spare = new BytesRef();
            BytesRef lastTsid = new BytesRef();
            LongVector timestampVector = this.getTimestampVector(page);
            int lastOrd = -1;
            for (int i = 0; i < tsidOrdinals.getPositionCount(); ++i) {
                int newOrd = tsidOrdinals.getInt(i);
                boolean newGroup = false;
                if (lastOrd != newOrd) {
                    BytesRef newTsid = tsidDict.getBytesRef(newOrd, spare);
                    if (this.positionCount() == 0) {
                        newGroup = true;
                    } else if (lastOrd == -1) {
                        this.tsidArray.get(this.lastTsidPosition, lastTsid);
                        newGroup = !lastTsid.equals((Object)newTsid);
                    } else {
                        newGroup = true;
                    }
                    if (newGroup) {
                        this.endTsidGroup();
                        this.lastTsidPosition = this.tsidArray.count;
                        this.tsidArray.append(newTsid);
                    }
                    lastOrd = newOrd;
                }
                long timestamp = timestampVector.getLong(i);
                if (newGroup || timestamp != this.lastTimestamp) {
                    assert (newGroup || this.lastTimestamp >= timestamp) : "@timestamp goes backward " + this.lastTimestamp + " < " + timestamp;
                    this.timestampArray.append(timestamp);
                    this.lastTimestamp = timestamp;
                    ++this.currentTimestampCount;
                }
                ordsBuilder.appendInt(this.timestampArray.count - 1);
            }
            try (IntVector ords = ordsBuilder.build();){
                addInput.add(0, ords);
            }
        }
    }

    private void endTsidGroup() {
        if (this.currentTimestampCount > 0) {
            this.perTsidCountArray.append(this.currentTimestampCount);
            this.currentTimestampCount = 0;
        }
    }

    @Override
    public ReleasableIterator<IntBlock> lookup(Page page, ByteSizeValue targetBlockSize) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public Block[] getKeys() {
        this.endTsidGroup();
        Releasable[] blocks = new Block[2];
        try {
            blocks[0] = OrdinalBytesRefBlock.isDense(this.positionCount(), this.tsidArray.count) ? this.buildTsidBlockWithOrdinal() : this.buildTsidBlock();
            blocks[1] = this.timestampArray.toBlock();
            Releasable[] releasableArray = blocks;
            return releasableArray;
        }
        finally {
            if (blocks[blocks.length - 1] == null) {
                Releasables.close((Releasable[])blocks);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BytesRefBlock buildTsidBlockWithOrdinal() {
        try (IntVector.FixedBuilder ordinalBuilder = this.blockFactory.newIntVectorFixedBuilder(this.positionCount());){
            OrdinalBytesRefBlock ordinalBytesRefBlock;
            block12: {
                for (int i = 0; i < this.tsidArray.count; ++i) {
                    int numTimestamps = this.perTsidCountArray.array.get((long)i);
                    for (int t = 0; t < numTimestamps; ++t) {
                        ordinalBuilder.appendInt(i);
                    }
                }
                IntVector ordinalVector = ordinalBuilder.build();
                BytesRefVector dictionary = null;
                boolean success = false;
                try {
                    dictionary = this.tsidArray.toVector();
                    OrdinalBytesRefBlock result = new OrdinalBytesRefVector(ordinalVector, dictionary).asBlock();
                    success = true;
                    ordinalBytesRefBlock = result;
                    if (success) break block12;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        Releasables.close((Releasable[])new Releasable[]{ordinalVector, dictionary});
                    }
                    throw throwable;
                }
                Releasables.close((Releasable[])new Releasable[]{ordinalVector, dictionary});
            }
            return ordinalBytesRefBlock;
        }
    }

    private BytesRefBlock buildTsidBlock() {
        try (BytesRefVector.Builder tsidBuilder = this.blockFactory.newBytesRefVectorBuilder(this.positionCount());){
            BytesRef tsid = new BytesRef();
            for (int i = 0; i < this.tsidArray.count; ++i) {
                this.tsidArray.array.get((long)i, tsid);
                int numTimestamps = this.perTsidCountArray.array.get((long)i);
                for (int t = 0; t < numTimestamps; ++t) {
                    tsidBuilder.appendBytesRef(tsid);
                }
            }
            BytesRefBlock bytesRefBlock = tsidBuilder.build().asBlock();
            return bytesRefBlock;
        }
    }

    private int positionCount() {
        return this.timestampArray.count;
    }

    @Override
    public IntVector nonEmpty() {
        long endExclusive = this.positionCount();
        return IntVector.range(0, Math.toIntExact(endExclusive), this.blockFactory);
    }

    @Override
    public BitArray seenGroupIds(BigArrays bigArrays) {
        return new SeenGroupIds.Range(0, this.positionCount()).seenGroupIds(bigArrays);
    }

    public String toString() {
        return "TimeSeriesBlockHash{keys=[BytesRefKey[channel=" + this.tsHashChannel + "], LongKey[channel=" + this.timestampIntervalChannel + "]], entries=" + this.positionCount() + "b}";
    }

    private static class BytesRefArrayWithSize
    implements Releasable {
        private final BlockFactory blockFactory;
        private BytesRefArray array;
        private int count = 0;

        BytesRefArrayWithSize(BlockFactory blockFactory) {
            this.blockFactory = blockFactory;
            this.array = new BytesRefArray(1L, blockFactory.bigArrays());
        }

        void append(BytesRef value) {
            this.array.append(value);
            ++this.count;
        }

        void get(int index, BytesRef dest) {
            this.array.get((long)index, dest);
        }

        BytesRefVector toVector() {
            BytesRefVector vector = this.blockFactory.newBytesRefArrayVector(this.array, this.count);
            this.array = null;
            return vector;
        }

        public void close() {
            Releasables.close((Releasable)this.array);
        }
    }

    private static class LongArrayWithSize
    implements Releasable {
        private final BlockFactory blockFactory;
        private LongArray array;
        private int count = 0;

        LongArrayWithSize(BlockFactory blockFactory) {
            this.blockFactory = blockFactory;
            this.array = blockFactory.bigArrays().newLongArray(1L, false);
        }

        void append(long value) {
            this.array = this.blockFactory.bigArrays().grow(this.array, (long)(this.count + 1));
            this.array.set((long)this.count, value);
            ++this.count;
        }

        LongBlock toBlock() {
            try (LongVector.FixedBuilder builder = this.blockFactory.newLongVectorFixedBuilder(this.count);){
                for (int i = 0; i < this.count; ++i) {
                    builder.appendLong(this.array.get((long)i));
                }
                LongBlock longBlock = builder.build().asBlock();
                return longBlock;
            }
        }

        public void close() {
            Releasables.close((Releasable)this.array);
        }
    }

    private static class IntArrayWithSize
    implements Releasable {
        private final BlockFactory blockFactory;
        private IntArray array;
        private int count = 0;

        IntArrayWithSize(BlockFactory blockFactory) {
            this.blockFactory = blockFactory;
            this.array = blockFactory.bigArrays().newIntArray(1L, false);
        }

        void append(int value) {
            this.array = this.blockFactory.bigArrays().grow(this.array, (long)(this.count + 1));
            this.array.set((long)this.count, value);
            ++this.count;
        }

        public void close() {
            Releasables.close((Releasable)this.array);
        }
    }
}

