/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.blobstore.BlobStoreActionStats;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public class RepositoryStats
implements Writeable {
    public static final RepositoryStats EMPTY_STATS = new RepositoryStats(Collections.emptyMap());
    public final Map<String, BlobStoreActionStats> actionStats;

    public RepositoryStats(Map<String, BlobStoreActionStats> actionStats) {
        this.actionStats = Collections.unmodifiableMap(actionStats);
    }

    public RepositoryStats(StreamInput in) throws IOException {
        this.actionStats = in.getTransportVersion().supports(TransportVersions.V_8_18_0) ? in.readMap(BlobStoreActionStats::new) : in.readMap(si -> {
            long legacyValue = in.readLong();
            return new BlobStoreActionStats(legacyValue, legacyValue);
        });
    }

    public RepositoryStats merge(RepositoryStats otherStats) {
        HashMap<String, BlobStoreActionStats> result = new HashMap<String, BlobStoreActionStats>(this.actionStats);
        for (Map.Entry<String, BlobStoreActionStats> entry : otherStats.actionStats.entrySet()) {
            result.merge(entry.getKey(), entry.getValue(), BlobStoreActionStats::add);
        }
        return new RepositoryStats(result);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().supports(TransportVersions.V_8_18_0)) {
            out.writeMap(this.actionStats, (so, v) -> v.writeTo(so));
        } else {
            out.writeMap(this.actionStats, (so, v) -> so.writeLong(v.requests()));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryStats that = (RepositoryStats)o;
        return this.actionStats.equals(that.actionStats);
    }

    public int hashCode() {
        return Objects.hash(this.actionStats);
    }

    public String toString() {
        return "RepositoryStats{actionStats=" + String.valueOf(this.actionStats) + "}";
    }
}

