/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.rescore;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryRescorer;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.elasticsearch.common.lucene.search.function.ScriptScoreQuery;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.search.rescore.RescoreContext;
import org.elasticsearch.search.rescore.Rescorer;
import org.elasticsearch.search.vectors.KnnScoreDocQuery;

public class ScriptRescorer
implements Rescorer {
    public static final Rescorer INSTANCE = new ScriptRescorer();

    @Override
    public TopDocs rescore(TopDocs topDocs, IndexSearcher searcher, RescoreContext rescoreContext0) throws IOException {
        assert (rescoreContext0 != null);
        if (topDocs == null || topDocs.scoreDocs.length == 0) {
            return topDocs;
        }
        ScriptRescoreContext rescoreContext = (ScriptRescoreContext)rescoreContext0;
        TopDocs topNPreviousPass = Rescorer.topN(topDocs, rescoreContext.getWindowSize());
        Set<Integer> topNDocIDs = Collections.unmodifiableSet(Arrays.stream(topNPreviousPass.scoreDocs).map(scoreDoc -> scoreDoc.doc).collect(Collectors.toSet()));
        rescoreContext.setRescoredDocs(topNDocIDs);
        ScriptScoreQuery query = rescoreContext.getQuery();
        if (rescoreContext.needsScores()) {
            ScoreDoc[] topN = new ScoreDoc[topNPreviousPass.scoreDocs.length];
            System.arraycopy(topNPreviousPass.scoreDocs, 0, topN, 0, topN.length);
            KnnScoreDocQuery subQuery = new KnnScoreDocQuery(topN, searcher.getIndexReader());
            query = query.cloneWithNewSubQuery(subQuery);
            rescoreContext.setExplainQuery(query);
        }
        QueryRescorer rescorer = new QueryRescorer(this, query){

            protected float combine(float firstPassScore, boolean secondPassMatches, float secondPassScore) {
                return secondPassScore;
            }
        };
        TopDocs rescored = rescorer.rescore(searcher, topNPreviousPass, rescoreContext.getWindowSize());
        return ScriptRescorer.combine(topDocs, rescored);
    }

    private static TopDocs combine(TopDocs in, TopDocs resorted) {
        System.arraycopy(resorted.scoreDocs, 0, in.scoreDocs, 0, resorted.scoreDocs.length);
        if (in.scoreDocs.length > resorted.scoreDocs.length) {
            Arrays.sort(in.scoreDocs, SCORE_DOC_COMPARATOR);
        }
        return in;
    }

    @Override
    public Explanation explain(int topLevelDocId, IndexSearcher searcher, RescoreContext rescoreContext0, Explanation sourceExplanation) throws IOException {
        Explanation rescoreExplanation;
        if (sourceExplanation == null) {
            return Explanation.noMatch((String)"nothing matched", (Explanation[])new Explanation[0]);
        }
        if (!sourceExplanation.isMatch()) {
            return Explanation.noMatch((String)"no match", (Explanation[])new Explanation[]{sourceExplanation});
        }
        ScriptRescoreContext rescoreContext = (ScriptRescoreContext)rescoreContext0;
        if (rescoreContext.isRescored(topLevelDocId) && (rescoreExplanation = searcher.explain(rescoreContext.getExplainQuery(), topLevelDocId)) != null && rescoreExplanation.isMatch()) {
            if (!rescoreContext.needsScores()) {
                return rescoreExplanation;
            }
            Explanation scoreExp = Explanation.match((Number)sourceExplanation.getValue(), (String)"_score: ", (Explanation[])new Explanation[]{sourceExplanation});
            return Explanation.match((Number)Float.valueOf(rescoreExplanation.getValue().floatValue()), (String)(rescoreExplanation.getDescription() + ", computed as:"), (Explanation[])new Explanation[]{scoreExp});
        }
        return sourceExplanation;
    }

    public static class ScriptRescoreContext
    extends RescoreContext {
        private final ScriptScoreQuery query;
        private final List<ParsedQuery> parsedQueries;
        private Query explainQuery;

        public ScriptRescoreContext(ParsedQuery parsedQuery, int windowSize) {
            super(windowSize, INSTANCE);
            assert (parsedQuery != null) : "query must not be null";
            this.query = (ScriptScoreQuery)parsedQuery.query();
            this.parsedQueries = List.of(parsedQuery);
        }

        @Override
        public List<ParsedQuery> getParsedQueries() {
            return this.parsedQueries;
        }

        public ScriptScoreQuery getQuery() {
            return this.query;
        }

        public boolean needsScores() {
            return this.query.needsScore();
        }

        public void setExplainQuery(Query explainQuery) {
            this.explainQuery = explainQuery;
        }

        public Query getExplainQuery() {
            return this.explainQuery != null ? this.explainQuery : this.query;
        }
    }
}

