/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.index.mapper.BlockDocValuesReader;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.script.StringFieldScript;

public class KeywordScriptBlockDocValuesReader
extends BlockDocValuesReader {
    private final BytesRefBuilder bytesBuild = new BytesRefBuilder();
    private final StringFieldScript script;
    private int docId;

    KeywordScriptBlockDocValuesReader(StringFieldScript script) {
        this.script = script;
    }

    @Override
    public int docId() {
        return this.docId;
    }

    @Override
    public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered) throws IOException {
        try (BlockLoader.BytesRefBuilder builder = factory.bytesRefs(docs.count() - offset);){
            for (int i = offset; i < docs.count(); ++i) {
                this.read(docs.get(i), builder);
            }
            BlockLoader.Block block = builder.build();
            return block;
        }
    }

    @Override
    public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
        this.docId = docId;
        this.read(docId, (BlockLoader.BytesRefBuilder)builder);
    }

    private void read(int docId, BlockLoader.BytesRefBuilder builder) {
        this.script.runForDoc(docId);
        switch (this.script.getValues().size()) {
            case 0: {
                builder.appendNull();
                break;
            }
            case 1: {
                this.bytesBuild.copyChars((CharSequence)this.script.getValues().get(0));
                builder.appendBytesRef(this.bytesBuild.get());
                break;
            }
            default: {
                builder.beginPositionEntry();
                for (String v : this.script.getValues()) {
                    this.bytesBuild.copyChars((CharSequence)v);
                    builder.appendBytesRef(this.bytesBuild.get());
                }
                builder.endPositionEntry();
            }
        }
    }

    @Override
    public String toString() {
        return "ScriptKeywords";
    }

    static class KeywordScriptBlockLoader
    extends BlockDocValuesReader.DocValuesBlockLoader {
        private final StringFieldScript.LeafFactory factory;

        KeywordScriptBlockLoader(StringFieldScript.LeafFactory factory) {
            this.factory = factory;
        }

        @Override
        public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
            return factory.bytesRefs(expectedCount);
        }

        @Override
        public BlockLoader.AllReader reader(LeafReaderContext context) throws IOException {
            return new KeywordScriptBlockDocValuesReader(this.factory.newInstance(context));
        }
    }
}

