/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.CancelledKeyException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.StampedLock;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.network.CloseableChannel;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.NetworkExceptionHelper;
import org.elasticsearch.common.transport.PortsRange;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.common.util.concurrent.RunOnce;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.Strings;
import org.elasticsearch.http.BindHttpException;
import org.elasticsearch.http.CorsHandler;
import org.elasticsearch.http.DefaultRestChannel;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.http.HttpClientStatsTracker;
import org.elasticsearch.http.HttpHandlingSettings;
import org.elasticsearch.http.HttpInfo;
import org.elasticsearch.http.HttpReadTimeoutException;
import org.elasticsearch.http.HttpRequest;
import org.elasticsearch.http.HttpResponse;
import org.elasticsearch.http.HttpServerChannel;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.http.HttpStats;
import org.elasticsearch.http.HttpTracer;
import org.elasticsearch.http.HttpTransportSettings;
import org.elasticsearch.http.HttpUtils;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.telemetry.TelemetryProvider;
import org.elasticsearch.telemetry.metric.LongWithAttributes;
import org.elasticsearch.telemetry.metric.MeterRegistry;
import org.elasticsearch.telemetry.tracing.Tracer;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BindTransportException;
import org.elasticsearch.transport.TransportSettings;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentParserConfiguration;

public abstract class AbstractHttpServerTransport
extends AbstractLifecycleComponent
implements HttpServerTransport {
    private static final Logger logger = LogManager.getLogger(AbstractHttpServerTransport.class);
    protected final Settings settings;
    public final HttpHandlingSettings handlingSettings;
    protected final NetworkService networkService;
    protected final Recycler<BytesRef> recycler;
    protected final ThreadPool threadPool;
    protected final HttpServerTransport.Dispatcher dispatcher;
    protected final CorsHandler corsHandler;
    private final XContentParserConfiguration parserConfig;
    protected final PortsRange port;
    protected final ByteSizeValue maxContentLength;
    private final String[] bindHosts;
    private final String[] publishHosts;
    private volatile BoundTransportAddress boundAddress;
    private final AtomicLong totalChannelsAccepted = new AtomicLong();
    private final Map<HttpChannel, RequestTrackingHttpChannel> httpChannels = new ConcurrentHashMap<HttpChannel, RequestTrackingHttpChannel>();
    private final PlainActionFuture<Void> allClientsClosedListener = new PlainActionFuture();
    private final RefCounted refCounted = AbstractRefCounted.of(() -> this.allClientsClosedListener.onResponse(null));
    private final Set<HttpServerChannel> httpServerChannels = ConcurrentCollections.newConcurrentSet();
    private final long shutdownGracePeriodMillis;
    private final long shutdownPollPeriodMillis;
    private final HttpClientStatsTracker httpClientStatsTracker;
    private final HttpTracer httpLogger;
    private final Tracer tracer;
    private final MeterRegistry meterRegistry;
    private final List<AutoCloseable> metricsToClose = new ArrayList<AutoCloseable>(2);
    private volatile boolean shuttingDown;
    private final ReadWriteLock shuttingDownRWLock = new StampedLock().asReadWriteLock();
    private volatile long slowLogThresholdMs;

    protected AbstractHttpServerTransport(Settings settings, NetworkService networkService, Recycler<BytesRef> recycler, ThreadPool threadPool, NamedXContentRegistry xContentRegistry, HttpServerTransport.Dispatcher dispatcher, ClusterSettings clusterSettings, TelemetryProvider telemetryProvider) {
        this.settings = settings;
        this.networkService = networkService;
        this.recycler = recycler;
        this.threadPool = threadPool;
        this.parserConfig = XContentParserConfiguration.EMPTY.withRegistry(xContentRegistry).withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE);
        this.dispatcher = dispatcher;
        this.handlingSettings = HttpHandlingSettings.fromSettings(settings);
        this.corsHandler = CorsHandler.fromSettings(settings);
        List<String> httpBindHost = HttpTransportSettings.SETTING_HTTP_BIND_HOST.get(settings);
        this.bindHosts = (httpBindHost.isEmpty() ? NetworkService.GLOBAL_NETWORK_BIND_HOST_SETTING.get(settings) : httpBindHost).toArray(org.elasticsearch.common.Strings.EMPTY_ARRAY);
        List<String> httpPublishHost = HttpTransportSettings.SETTING_HTTP_PUBLISH_HOST.get(settings);
        this.publishHosts = (httpPublishHost.isEmpty() ? NetworkService.GLOBAL_NETWORK_PUBLISH_HOST_SETTING.get(settings) : httpPublishHost).toArray(org.elasticsearch.common.Strings.EMPTY_ARRAY);
        this.port = HttpTransportSettings.SETTING_HTTP_PORT.get(settings);
        this.maxContentLength = HttpTransportSettings.SETTING_HTTP_MAX_CONTENT_LENGTH.get(settings);
        this.tracer = telemetryProvider.getTracer();
        this.meterRegistry = telemetryProvider.getMeterRegistry();
        this.httpLogger = new HttpTracer(settings, clusterSettings);
        clusterSettings.addSettingsUpdateConsumer(TransportSettings.SLOW_OPERATION_THRESHOLD_SETTING, slowLogThreshold -> {
            this.slowLogThresholdMs = slowLogThreshold.getMillis();
        });
        this.slowLogThresholdMs = TransportSettings.SLOW_OPERATION_THRESHOLD_SETTING.get(settings).getMillis();
        this.httpClientStatsTracker = new HttpClientStatsTracker(settings, clusterSettings, threadPool);
        this.shutdownGracePeriodMillis = HttpTransportSettings.SETTING_HTTP_SERVER_SHUTDOWN_GRACE_PERIOD.get(settings).getMillis();
        this.shutdownPollPeriodMillis = HttpTransportSettings.SETTING_HTTP_SERVER_SHUTDOWN_POLL_PERIOD.get(settings).getMillis();
    }

    public Recycler<BytesRef> recycler() {
        return this.recycler;
    }

    @Override
    public BoundTransportAddress boundAddress() {
        return this.boundAddress;
    }

    @Override
    public HttpInfo info() {
        BoundTransportAddress boundTransportAddress = this.boundAddress();
        if (boundTransportAddress == null) {
            return null;
        }
        return new HttpInfo(boundTransportAddress, this.maxContentLength.getBytes());
    }

    @Override
    public HttpStats stats() {
        return new HttpStats(this.httpChannels.size(), this.totalChannelsAccepted.get(), this.httpClientStatsTracker.getClientStats(), this.dispatcher.getStats());
    }

    protected void bindServer() {
        InetAddress publishInetAddress;
        InetAddress[] hostAddresses;
        try {
            hostAddresses = this.networkService.resolveBindHostAddresses(this.bindHosts);
        }
        catch (IOException e) {
            throw new BindHttpException("Failed to resolve host [" + Arrays.toString(this.bindHosts) + "]", e);
        }
        ArrayList<TransportAddress> boundAddresses = new ArrayList<TransportAddress>(hostAddresses.length);
        for (InetAddress address : hostAddresses) {
            boundAddresses.add(this.bindAddress(address));
        }
        try {
            publishInetAddress = this.networkService.resolvePublishHostAddresses(this.publishHosts);
        }
        catch (Exception e) {
            throw new BindTransportException("Failed to resolve publish address", e);
        }
        int publishPort = AbstractHttpServerTransport.resolvePublishPort(this.settings, boundAddresses, publishInetAddress);
        TransportAddress publishAddress = new TransportAddress(new InetSocketAddress(publishInetAddress, publishPort));
        this.boundAddress = new BoundTransportAddress(boundAddresses.toArray(new TransportAddress[0]), publishAddress);
        logger.info("{}", (Object)this.boundAddress);
    }

    private TransportAddress bindAddress(InetAddress hostAddress) {
        AtomicReference boundSocket = new AtomicReference();
        AtomicReference lastException = new AtomicReference();
        boolean success = this.port.iterate(portNumber -> {
            try {
                Set<HttpServerChannel> set = this.httpServerChannels;
                synchronized (set) {
                    HttpServerChannel httpServerChannel = this.bind(new InetSocketAddress(hostAddress, portNumber));
                    this.httpServerChannels.add(httpServerChannel);
                    boundSocket.set(httpServerChannel.getLocalAddress());
                }
            }
            catch (Exception e) {
                lastException.set(e);
                return false;
            }
            return true;
        });
        if (!success) {
            throw new BindHttpException("Failed to bind to " + NetworkAddress.format(hostAddress, this.port), (Throwable)lastException.get());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Bound http to address {{}}", (Object)NetworkAddress.format((InetSocketAddress)boundSocket.get()));
        }
        return new TransportAddress((InetSocketAddress)boundSocket.get());
    }

    protected abstract HttpServerChannel bind(InetSocketAddress var1) throws Exception;

    @Override
    protected final void doStart() {
        this.metricsToClose.add(this.meterRegistry.registerLongAsyncCounter("es.http.connections.total", "total number of inbound HTTP connections accepted", "count", () -> new LongWithAttributes(this.totalChannelsAccepted.get())));
        this.metricsToClose.add(this.meterRegistry.registerLongGauge("es.http.connections.current", "number of inbound HTTP connections currently open", "count", () -> new LongWithAttributes(this.httpChannels.size())));
        this.startInternal();
    }

    protected abstract void startInternal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void doStop() {
        Set<HttpServerChannel> set = this.httpServerChannels;
        synchronized (set) {
            if (!this.httpServerChannels.isEmpty()) {
                try {
                    CloseableChannel.closeChannels(new ArrayList<HttpServerChannel>(this.httpServerChannels), true);
                }
                catch (Exception e) {
                    logger.warn("exception while closing channels", (Throwable)e);
                }
                finally {
                    this.httpServerChannels.clear();
                }
            }
        }
        Lock wlock = this.shuttingDownRWLock.writeLock();
        try {
            wlock.lock();
            this.shuttingDown = true;
            this.refCounted.decRef();
            this.httpChannels.values().forEach(RequestTrackingHttpChannel::setCloseWhenIdle);
        }
        finally {
            wlock.unlock();
        }
        boolean closed = false;
        long pollTimeMillis = this.shutdownPollPeriodMillis;
        if (this.shutdownGracePeriodMillis > 0L) {
            if (this.shutdownGracePeriodMillis < pollTimeMillis) {
                pollTimeMillis = this.shutdownGracePeriodMillis;
            }
            logger.debug(Strings.format((String)"waiting [%d]ms for clients to close connections", (Object[])new Object[]{this.shutdownGracePeriodMillis}));
        } else {
            logger.debug("waiting indefinitely for clients to close connections");
        }
        long startPollTimeMillis = System.currentTimeMillis();
        do {
            try {
                FutureUtils.get(this.allClientsClosedListener, pollTimeMillis, TimeUnit.MILLISECONDS);
                closed = true;
            }
            catch (ElasticsearchTimeoutException t) {
                logger.info(Strings.format((String)"still waiting on %d client connections to close", (Object[])new Object[]{this.httpChannels.size()}));
                if (this.shutdownGracePeriodMillis <= 0L) continue;
                long endPollTimeMillis = System.currentTimeMillis();
                long remainingGracePeriodMillis = this.shutdownGracePeriodMillis - (endPollTimeMillis - startPollTimeMillis);
                if (remainingGracePeriodMillis <= 0L) {
                    logger.warn(Strings.format((String)"timed out while waiting [%d]ms for clients to close connections", (Object[])new Object[]{this.shutdownGracePeriodMillis}));
                    break;
                }
                if (remainingGracePeriodMillis >= pollTimeMillis) continue;
                pollTimeMillis = remainingGracePeriodMillis;
            }
        } while (!closed);
        if (!closed) {
            try {
                CloseableChannel.closeChannels(new ArrayList<RequestTrackingHttpChannel>(this.httpChannels.values()), true);
            }
            catch (Exception e) {
                logger.warn("unexpected exception while closing http channels", (Throwable)e);
            }
            try {
                this.allClientsClosedListener.get();
            }
            catch (Exception e) {
                assert (false) : e;
                logger.warn("unexpected exception while waiting for http channels to close", (Throwable)e);
            }
        }
        for (AutoCloseable metricToClose : this.metricsToClose) {
            try {
                metricToClose.close();
            }
            catch (Exception e) {
                logger.warn("unexpected exception while closing metric [{}]", (Object)metricToClose);
                assert (false) : e;
            }
        }
        this.stopInternal();
    }

    boolean isAcceptingConnections() {
        return !this.shuttingDown;
    }

    @Override
    protected void doClose() {
    }

    protected abstract void stopInternal();

    static int resolvePublishPort(Settings settings, List<TransportAddress> boundAddresses, InetAddress publishInetAddress) {
        int publishPort = HttpTransportSettings.SETTING_HTTP_PUBLISH_PORT.get(settings);
        if (publishPort < 0) {
            for (TransportAddress boundAddress : boundAddresses) {
                InetAddress boundInetAddress = boundAddress.address().getAddress();
                if (!boundInetAddress.isAnyLocalAddress() && !boundInetAddress.equals(publishInetAddress)) continue;
                publishPort = boundAddress.getPort();
                break;
            }
        }
        if (publishPort < 0) {
            HashSet<Integer> ports = new HashSet<Integer>();
            for (TransportAddress boundAddress : boundAddresses) {
                ports.add(boundAddress.getPort());
            }
            if (ports.size() == 1) {
                publishPort = (Integer)ports.iterator().next();
            }
        }
        if (publishPort < 0) {
            throw new BindHttpException("Failed to auto-resolve http publish port, multiple bound addresses " + String.valueOf(boundAddresses) + " with distinct ports and none of them matched the publish address (" + String.valueOf(publishInetAddress) + "). Please specify a unique port by setting " + HttpTransportSettings.SETTING_HTTP_PORT.getKey() + " or " + HttpTransportSettings.SETTING_HTTP_PUBLISH_PORT.getKey());
        }
        return publishPort;
    }

    public void onException(HttpChannel channel, Exception e) {
        try {
            if (!this.lifecycle.started()) {
                return;
            }
            if (NetworkExceptionHelper.getCloseConnectionExceptionLevel(e, false) != Level.OFF) {
                logger.trace(() -> Strings.format((String)"close connection exception caught while handling client http traffic, closing connection %s", (Object[])new Object[]{channel}), (Throwable)e);
            } else if (NetworkExceptionHelper.isConnectException(e)) {
                logger.trace(() -> Strings.format((String)"connect exception caught while handling client http traffic, closing connection %s", (Object[])new Object[]{channel}), (Throwable)e);
            } else if (e instanceof HttpReadTimeoutException) {
                logger.trace(() -> Strings.format((String)"http read timeout, closing connection %s", (Object[])new Object[]{channel}), (Throwable)e);
            } else if (e instanceof CancelledKeyException) {
                logger.trace(() -> Strings.format((String)"cancelled key exception caught while handling client http traffic, closing connection %s", (Object[])new Object[]{channel}), (Throwable)e);
            } else {
                logger.warn(() -> Strings.format((String)"caught exception while handling client http traffic, closing connection %s", (Object[])new Object[]{channel}), (Throwable)e);
            }
        }
        finally {
            CloseableChannel.closeChannel(channel);
        }
    }

    protected static void onServerException(HttpServerChannel channel, Exception e) {
        logger.error(() -> "exception from http server channel caught on transport layer [channel=" + String.valueOf(channel) + "]", (Throwable)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serverAcceptedChannel(HttpChannel httpChannel) {
        Lock rlock = this.shuttingDownRWLock.readLock();
        try {
            rlock.lock();
            if (this.shuttingDown) {
                throw new IllegalStateException("Server cannot accept new channel while shutting down");
            }
            RequestTrackingHttpChannel trackingChannel = this.httpChannels.putIfAbsent(httpChannel, new RequestTrackingHttpChannel(httpChannel));
            assert (trackingChannel == null) : "Channel should only be added to http channel set once";
        }
        finally {
            rlock.unlock();
        }
        this.refCounted.incRef();
        httpChannel.addCloseListener(ActionListener.running(() -> {
            this.httpChannels.remove(httpChannel);
            this.refCounted.decRef();
        }));
        this.totalChannelsAccepted.incrementAndGet();
        this.httpClientStatsTracker.addClientStats(httpChannel);
        logger.trace(() -> Strings.format((String)"Http channel accepted: %s", (Object[])new Object[]{httpChannel}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingRequest(HttpRequest httpRequest, HttpChannel httpChannel) {
        this.httpClientStatsTracker.updateClientStats(httpRequest, httpChannel);
        RequestTrackingHttpChannel trackingChannel = this.httpChannels.get(httpChannel);
        long startTime = this.threadPool.rawRelativeTimeInMillis();
        try {
            if (trackingChannel == null) {
                httpRequest.release();
                logger.warn("http channel [{}] closed before starting to handle [{}][{}][{}]", (Object)httpChannel, (Object)httpRequest.header("X-Opaque-Id"), (Object)httpRequest.method(), (Object)httpRequest.uri());
                return;
            }
            trackingChannel.incomingRequest();
            this.handleIncomingRequest(httpRequest, trackingChannel, httpRequest.getInboundException());
        }
        finally {
            long took = this.threadPool.rawRelativeTimeInMillis() - startTime;
            this.networkService.getHandlingTimeTracker().addObservation(took);
            long logThreshold = this.slowLogThresholdMs;
            if (logThreshold > 0L && took > logThreshold) {
                logger.warn("handling request [{}][{}][{}][{}] took [{}ms] which is above the warn threshold of [{}ms]", (Object)httpRequest.header("X-Opaque-Id"), (Object)httpRequest.method(), (Object)httpRequest.uri(), (Object)httpChannel, (Object)took, (Object)logThreshold);
            }
        }
    }

    void dispatchRequest(RestRequest restRequest, RestChannel channel, Throwable badRequestCause) {
        block13: {
            ThreadContext threadContext = this.threadPool.getThreadContext();
            try (ThreadContext.StoredContext ignore = threadContext.stashContext();){
                if (badRequestCause != null) {
                    this.dispatcher.dispatchBadRequest(channel, threadContext, badRequestCause);
                    break block13;
                }
                try {
                    this.populatePerRequestThreadContext(restRequest, threadContext);
                }
                catch (Exception e) {
                    try {
                        this.dispatcher.dispatchBadRequest(channel, threadContext, e);
                    }
                    catch (Exception inner) {
                        inner.addSuppressed(e);
                        logger.error(() -> "failed to send failure response for uri [" + restRequest.uri() + "]", (Throwable)inner);
                    }
                    if (ignore != null) {
                        ignore.close();
                    }
                    return;
                }
                this.dispatcher.dispatchRequest(restRequest, channel, threadContext);
            }
        }
    }

    protected void populatePerRequestThreadContext(RestRequest restRequest, ThreadContext threadContext) {
    }

    private void handleIncomingRequest(HttpRequest httpRequest, HttpChannel httpChannel, Exception exception) {
        DefaultRestChannel innerChannel;
        RestRequest innerRestRequest;
        HttpResponse earlyResponse;
        if (exception == null && (earlyResponse = this.corsHandler.handleInbound(httpRequest)) != null) {
            httpChannel.sendResponse(earlyResponse, AbstractHttpServerTransport.earlyResponseListener(httpRequest, httpChannel));
            httpRequest.release();
            return;
        }
        Exception badRequestCause = exception;
        try {
            innerRestRequest = RestRequest.request(this.parserConfig, httpRequest, httpChannel);
        }
        catch (RestRequest.MediaTypeHeaderException e) {
            badRequestCause = ExceptionsHelper.useOrSuppress(badRequestCause, e);
            innerRestRequest = this.requestWithoutFailedHeader(httpRequest, httpChannel, badRequestCause, e.getFailedHeaderNames());
        }
        catch (RestRequest.BadParameterException e) {
            badRequestCause = ExceptionsHelper.useOrSuppress(badRequestCause, e);
            innerRestRequest = RestRequest.requestWithoutParameters(this.parserConfig, httpRequest, httpChannel);
        }
        RestRequest restRequest = innerRestRequest;
        HttpTracer maybeHttpLogger = this.httpLogger.maybeLogRequest(restRequest, exception);
        ThreadContext threadContext = this.threadPool.getThreadContext();
        try {
            innerChannel = new DefaultRestChannel(httpChannel, httpRequest, restRequest, this.recycler, this.handlingSettings, threadContext, this.corsHandler, maybeHttpLogger, this.tracer);
        }
        catch (IllegalArgumentException e) {
            badRequestCause = ExceptionsHelper.useOrSuppress(badRequestCause, e);
            RestRequest innerRequest = RestRequest.requestWithoutParameters(this.parserConfig, httpRequest, httpChannel);
            innerChannel = new DefaultRestChannel(httpChannel, httpRequest, innerRequest, this.recycler, this.handlingSettings, threadContext, this.corsHandler, this.httpLogger, this.tracer);
        }
        DefaultRestChannel channel = innerChannel;
        this.dispatchRequest(restRequest, channel, badRequestCause);
    }

    private RestRequest requestWithoutFailedHeader(HttpRequest httpRequest, HttpChannel httpChannel, Exception badRequestCause, Set<String> failedHeaderNames) {
        assert (failedHeaderNames.size() > 0);
        HttpRequest httpRequestWithoutHeader = httpRequest;
        for (String failedHeaderName : failedHeaderNames) {
            httpRequestWithoutHeader = httpRequestWithoutHeader.removeHeader(failedHeaderName);
        }
        try {
            return RestRequest.request(this.parserConfig, httpRequestWithoutHeader, httpChannel);
        }
        catch (RestRequest.MediaTypeHeaderException e) {
            badRequestCause = ExceptionsHelper.useOrSuppress(badRequestCause, e);
            return this.requestWithoutFailedHeader(httpRequestWithoutHeader, httpChannel, badRequestCause, e.getFailedHeaderNames());
        }
        catch (RestRequest.BadParameterException e) {
            badRequestCause.addSuppressed(e);
            return RestRequest.requestWithoutParameters(this.parserConfig, httpRequestWithoutHeader, httpChannel);
        }
    }

    private static ActionListener<Void> earlyResponseListener(HttpRequest request, HttpChannel httpChannel) {
        if (HttpUtils.shouldCloseConnection(request)) {
            return ActionListener.running(() -> CloseableChannel.closeChannel(httpChannel));
        }
        return ActionListener.noop();
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    private static class RequestTrackingHttpChannel
    implements HttpChannel {
        private final Runnable closeOnce = new RunOnce(this::closeInner);
        private volatile boolean closeWhenIdle;
        final RefCounted refCounted = AbstractRefCounted.of((Runnable)this.closeOnce);
        final HttpChannel inner;

        RequestTrackingHttpChannel(HttpChannel inner) {
            this.inner = inner;
        }

        public void incomingRequest() throws IllegalStateException {
            this.refCounted.incRef();
        }

        public void setCloseWhenIdle() {
            assert (!this.closeWhenIdle) : "setCloseWhenIdle() already called";
            this.closeWhenIdle = true;
            this.refCounted.decRef();
        }

        @Override
        public void close() {
            this.closeOnce.run();
        }

        private void closeInner() {
            if (this.inner.isOpen()) {
                this.inner.close();
            } else {
                logger.info("channel [{}] already closed", (Object)this.inner);
            }
        }

        @Override
        public void addCloseListener(ActionListener<Void> listener) {
            this.inner.addCloseListener(listener);
        }

        @Override
        public boolean isOpen() {
            return this.inner.isOpen();
        }

        @Override
        public void sendResponse(HttpResponse response, ActionListener<Void> listener) {
            assert (!response.containsHeader("connection"));
            if (this.closeWhenIdle) {
                response.addHeader("connection", "close");
            }
            this.inner.sendResponse(response, listener != null ? ActionListener.runAfter(listener, () -> ((RefCounted)this.refCounted).decRef()) : ActionListener.running(() -> ((RefCounted)this.refCounted).decRef()));
        }

        @Override
        public InetSocketAddress getLocalAddress() {
            return this.inner.getLocalAddress();
        }

        @Override
        public InetSocketAddress getRemoteAddress() {
            return this.inner.getRemoteAddress();
        }

        public String toString() {
            return this.inner.toString();
        }
    }
}

