/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.server.cli;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.server.cli.ErrorPumpThread;
import org.elasticsearch.server.cli.ProcessUtil;

public class ServerProcess {
    private final Process jvmProcess;
    private final ErrorPumpThread errorPump;
    private volatile boolean detached = false;

    ServerProcess(Process jvmProcess, ErrorPumpThread errorPump) {
        this.jvmProcess = jvmProcess;
        this.errorPump = errorPump;
    }

    public long pid() {
        return this.jvmProcess.pid();
    }

    public synchronized void detach() throws IOException {
        this.errorPump.drain();
        try {
            IOUtils.close((Closeable[])new Closeable[]{this.jvmProcess.getOutputStream(), this.jvmProcess.getInputStream(), this.jvmProcess.getErrorStream(), this.errorPump});
        }
        finally {
            this.detached = true;
        }
    }

    public int waitFor() throws IOException {
        this.errorPump.drain();
        int exitCode = ProcessUtil.nonInterruptible(this.jvmProcess::waitFor);
        this.errorPump.close();
        return exitCode;
    }

    public synchronized void stop() throws IOException {
        if (this.detached) {
            return;
        }
        this.sendShutdownMarker();
        this.waitFor();
    }

    public void forceStop() throws IOException {
        assert (!this.detached);
        this.jvmProcess.destroyForcibly();
        this.waitFor();
    }

    private void sendShutdownMarker() {
        try {
            OutputStream os = this.jvmProcess.getOutputStream();
            os.write(27);
            os.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

