/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.enrich.action;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.AbstractTransportRequest;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.enrich.action.EnrichStatsAction;
import org.elasticsearch.xpack.enrich.EnrichCache;
import org.elasticsearch.xpack.enrich.action.EnrichCoordinatorProxyAction;

public class EnrichCoordinatorStatsAction
extends ActionType<Response> {
    public static final EnrichCoordinatorStatsAction INSTANCE = new EnrichCoordinatorStatsAction();
    public static final String NAME = "cluster:monitor/xpack/enrich/coordinator_stats";

    private EnrichCoordinatorStatsAction() {
        super(NAME);
    }

    public static class TransportAction
    extends TransportNodesAction<Request, Response, NodeRequest, NodeResponse, Void> {
        private final EnrichCache enrichCache;
        private final EnrichCoordinatorProxyAction.Coordinator coordinator;

        @Inject
        public TransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, EnrichCache enrichCache, EnrichCoordinatorProxyAction.Coordinator coordinator) {
            super(EnrichCoordinatorStatsAction.NAME, clusterService, transportService, actionFilters, NodeRequest::new, (Executor)threadPool.executor("generic"));
            this.enrichCache = enrichCache;
            this.coordinator = coordinator;
        }

        protected DiscoveryNode[] resolveRequest(Request request, ClusterState clusterState) {
            return (DiscoveryNode[])clusterState.getNodes().getIngestNodes().values().toArray(DiscoveryNode[]::new);
        }

        protected Response newResponse(Request request, List<NodeResponse> nodeResponses, List<FailedNodeException> failures) {
            return new Response(this.clusterService.getClusterName(), nodeResponses, failures);
        }

        protected NodeRequest newNodeRequest(Request request) {
            return new NodeRequest();
        }

        protected NodeResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
            return new NodeResponse(in);
        }

        protected NodeResponse nodeOperation(NodeRequest request, Task task) {
            DiscoveryNode node = this.clusterService.localNode();
            return new NodeResponse(node, this.enrichCache.getStats(node.getId()), this.coordinator.getStats(node.getId()));
        }
    }

    public static class NodeResponse
    extends BaseNodeResponse {
        private final EnrichStatsAction.Response.CacheStats cacheStats;
        private final EnrichStatsAction.Response.CoordinatorStats coordinatorStats;

        NodeResponse(DiscoveryNode node, EnrichStatsAction.Response.CacheStats cacheStats, EnrichStatsAction.Response.CoordinatorStats coordinatorStats) {
            super(node);
            this.cacheStats = cacheStats;
            this.coordinatorStats = coordinatorStats;
        }

        NodeResponse(StreamInput in) throws IOException {
            super(in);
            this.cacheStats = new EnrichStatsAction.Response.CacheStats(in);
            this.coordinatorStats = new EnrichStatsAction.Response.CoordinatorStats(in);
        }

        public EnrichStatsAction.Response.CoordinatorStats getCoordinatorStats() {
            return this.coordinatorStats;
        }

        public EnrichStatsAction.Response.CacheStats getCacheStats() {
            return this.cacheStats;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.cacheStats.writeTo(out);
            this.coordinatorStats.writeTo(out);
        }
    }

    public static class Response
    extends BaseNodesResponse<NodeResponse> {
        Response(ClusterName clusterName, List<NodeResponse> nodes, List<FailedNodeException> failures) {
            super(clusterName, nodes, failures);
        }

        protected List<NodeResponse> readNodesFrom(StreamInput in) throws IOException {
            return (List)org.elasticsearch.action.support.TransportAction.localOnly();
        }

        protected void writeNodesTo(StreamOutput out, List<NodeResponse> nodes) throws IOException {
            org.elasticsearch.action.support.TransportAction.localOnly();
        }
    }

    public static class NodeRequest
    extends AbstractTransportRequest {
        NodeRequest() {
        }

        NodeRequest(StreamInput in) throws IOException {
            super(in);
        }
    }

    public static class Request
    extends BaseNodesRequest {
        public Request() {
            super(new String[0]);
        }
    }
}

