/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.system_indices.action;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.system_indices.action.GetFeatureUpgradeStatusResponse;
import org.elasticsearch.system_indices.action.PostFeatureUpgradeRequest;
import org.elasticsearch.system_indices.action.PostFeatureUpgradeResponse;
import org.elasticsearch.system_indices.action.TransportGetFeatureUpgradeStatusAction;
import org.elasticsearch.system_indices.task.SystemIndexMigrationTaskParams;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportPostFeatureUpgradeAction
extends TransportMasterNodeAction<PostFeatureUpgradeRequest, PostFeatureUpgradeResponse> {
    private static final Logger logger = LogManager.getLogger(TransportPostFeatureUpgradeAction.class);
    private final SystemIndices systemIndices;
    private final PersistentTasksService persistentTasksService;
    private final ProjectResolver projectResolver;

    @Inject
    public TransportPostFeatureUpgradeAction(TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, ClusterService clusterService, SystemIndices systemIndices, PersistentTasksService persistentTasksService, ProjectResolver projectResolver) {
        super("cluster:admin/migration/post_system_feature", transportService, clusterService, threadPool, actionFilters, PostFeatureUpgradeRequest::new, PostFeatureUpgradeResponse::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.systemIndices = systemIndices;
        this.persistentTasksService = persistentTasksService;
        this.projectResolver = projectResolver;
    }

    protected void masterOperation(Task task, PostFeatureUpgradeRequest request, ClusterState state, ActionListener<PostFeatureUpgradeResponse> listener) throws Exception {
        EnumSet<GetFeatureUpgradeStatusResponse.UpgradeStatus> upgradableStatuses = EnumSet.of(GetFeatureUpgradeStatusResponse.UpgradeStatus.MIGRATION_NEEDED, GetFeatureUpgradeStatusResponse.UpgradeStatus.ERROR);
        ProjectMetadata project = this.projectResolver.getProjectMetadata(state);
        List<PostFeatureUpgradeResponse.Feature> featuresToMigrate = this.systemIndices.getFeatures().stream().map(feature -> TransportGetFeatureUpgradeStatusAction.getFeatureUpgradeStatus(project, feature)).filter(status -> upgradableStatuses.contains((Object)status.getUpgradeStatus())).map(GetFeatureUpgradeStatusResponse.FeatureUpgradeStatus::getFeatureName).map(PostFeatureUpgradeResponse.Feature::new).sorted(Comparator.comparing(PostFeatureUpgradeResponse.Feature::getFeatureName)).toList();
        if (!featuresToMigrate.isEmpty()) {
            this.persistentTasksService.sendProjectStartRequest(project.id(), "upgrade-system-indices", "upgrade-system-indices", (PersistentTaskParams)new SystemIndexMigrationTaskParams(), TimeValue.THIRTY_SECONDS, ActionListener.wrap(startedTask -> listener.onResponse((Object)new PostFeatureUpgradeResponse(true, featuresToMigrate, null, null)), ex -> {
                logger.error("failed to start system index upgrade task", (Throwable)ex);
                listener.onResponse((Object)new PostFeatureUpgradeResponse(false, null, null, new ElasticsearchException((Throwable)ex)));
            }));
        } else {
            listener.onResponse((Object)new PostFeatureUpgradeResponse(false, null, "No system indices require migration", null));
        }
    }

    protected ClusterBlockException checkBlock(PostFeatureUpgradeRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

