/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.saml.sp;

import java.net.URL;
import java.time.Duration;
import java.util.Set;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.idp.privileges.ServiceProviderPrivileges;
import org.elasticsearch.xpack.idp.saml.sp.SamlServiceProvider;
import org.opensaml.security.x509.X509Credential;

public class CloudServiceProvider
implements SamlServiceProvider {
    private final String entityId;
    private final String name;
    private final boolean enabled;
    private final URL assertionConsumerService;
    private final String allowedNameIdFormat;
    private final Duration authnExpiry;
    private final ServiceProviderPrivileges privileges;
    private final SamlServiceProvider.AttributeNames attributeNames;
    private final Set<X509Credential> spSigningCredentials;
    private final boolean signAuthnRequests;
    private final boolean signLogoutRequests;

    public CloudServiceProvider(String entityId, String name, boolean enabled, URL assertionConsumerService, String allowedNameIdFormat, Duration authnExpiry, ServiceProviderPrivileges privileges, SamlServiceProvider.AttributeNames attributeNames, Set<X509Credential> spSigningCredentials, boolean signAuthnRequests, boolean signLogoutRequests) {
        if (Strings.isNullOrEmpty((String)entityId)) {
            throw new IllegalArgumentException("Service Provider Entity ID cannot be null or empty");
        }
        this.entityId = entityId;
        this.name = name;
        this.enabled = enabled;
        this.assertionConsumerService = assertionConsumerService;
        this.allowedNameIdFormat = allowedNameIdFormat;
        this.authnExpiry = authnExpiry;
        this.privileges = privileges;
        this.attributeNames = attributeNames;
        this.spSigningCredentials = spSigningCredentials == null ? Set.of() : Set.copyOf(spSigningCredentials);
        this.signLogoutRequests = signLogoutRequests;
        this.signAuthnRequests = signAuthnRequests;
    }

    @Override
    public String getEntityId() {
        return this.entityId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public String getAllowedNameIdFormat() {
        return this.allowedNameIdFormat;
    }

    @Override
    public URL getAssertionConsumerService() {
        return this.assertionConsumerService;
    }

    @Override
    public Duration getAuthnExpiry() {
        return this.authnExpiry;
    }

    @Override
    public SamlServiceProvider.AttributeNames getAttributeNames() {
        return this.attributeNames;
    }

    @Override
    public Set<X509Credential> getSpSigningCredentials() {
        return this.spSigningCredentials;
    }

    @Override
    public boolean shouldSignAuthnRequests() {
        return this.signAuthnRequests;
    }

    @Override
    public boolean shouldSignLogoutRequests() {
        return this.signLogoutRequests;
    }

    @Override
    public ServiceProviderPrivileges getPrivileges() {
        return this.privileges;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{entityId=[" + this.entityId + "] name=[" + this.name + "] enabled=" + this.enabled + " acs=[" + String.valueOf(this.assertionConsumerService) + "]}";
    }
}

