/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.kql.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.elasticsearch.xpack.kql.parser.KqlParsingException;

public final class ParserUtils {
    private static final String UNQUOTED_LITERAL_TERM_DELIMITER = " ";
    private static final char ESCAPE_CHAR = '\\';
    private static final char QUOTE_CHAR = '\"';
    private static final char WILDCARD_CHAR = '*';

    private ParserUtils() {
        throw new UnsupportedOperationException("No need to instantiate this class");
    }

    public static <T> T typedParsing(ParseTreeVisitor<?> visitor, ParserRuleContext ctx, Class<T> type) {
        Object result = ctx.accept(visitor);
        if (type.isInstance(result)) {
            return (T)result;
        }
        throw new KqlParsingException("Invalid query '{}'[{}] given; expected {} but found {}", ctx.start.getLine(), ctx.start.getCharPositionInLine(), ctx.getText(), ctx.getClass().getSimpleName(), type.getSimpleName(), result != null ? result.getClass().getSimpleName() : "null");
    }

    public static String extractText(ParserRuleContext ctx) {
        return String.join((CharSequence)UNQUOTED_LITERAL_TERM_DELIMITER, ParserUtils.extractTextTokens(ctx));
    }

    public static boolean hasWildcard(ParserRuleContext ctx) {
        return ctx.children.stream().anyMatch(childNode -> {
            ParserRuleContext childCtx;
            if (childNode instanceof TerminalNode) {
                TerminalNode terminalNode = (TerminalNode)childNode;
                Token token = terminalNode.getSymbol();
                return switch (token.getType()) {
                    case 16 -> true;
                    case 14 -> token.getText().matches("[^\\\\]*[*].*");
                    default -> false;
                };
            }
            return childNode instanceof ParserRuleContext && ParserUtils.hasWildcard(childCtx = (ParserRuleContext)childNode);
        });
    }

    public static String escapeLuceneQueryString(String queryText, boolean preserveWildcards) {
        if (preserveWildcards) {
            StringBuilder escapedQuery = new StringBuilder(queryText.length());
            StringBuilder subpart = new StringBuilder(queryText.length());
            for (char currentChar : queryText.toCharArray()) {
                if (currentChar == '*') {
                    escapedQuery.append(QueryParser.escape((String)subpart.toString())).append(currentChar);
                    subpart.setLength(0);
                    continue;
                }
                subpart.append(currentChar);
            }
            return escapedQuery.append(QueryParser.escape((String)subpart.toString())).toString();
        }
        return QueryParser.escape((String)queryText);
    }

    private static List<String> extractTextTokens(ParserRuleContext ctx) {
        assert (ctx.children != null);
        ArrayList<String> textTokens = new ArrayList<String>(ctx.children.size());
        for (ParseTree currentNode : ctx.children) {
            if (currentNode instanceof TerminalNode) {
                TerminalNode terminalNode = (TerminalNode)currentNode;
                textTokens.add(ParserUtils.extractText(terminalNode));
                continue;
            }
            if (currentNode instanceof ParserRuleContext) {
                ParserRuleContext childCtx = (ParserRuleContext)currentNode;
                textTokens.addAll(ParserUtils.extractTextTokens(childCtx));
                continue;
            }
            throw new KqlParsingException("Unable to extract text from ctx", ctx.start.getLine(), ctx.start.getCharPositionInLine(), new Object[0]);
        }
        return textTokens;
    }

    private static String extractText(TerminalNode node) {
        if (node.getSymbol().getType() == 15) {
            return ParserUtils.unescapeQuotedString(node);
        }
        if (node.getSymbol().getType() == 14) {
            return ParserUtils.unescapeUnquotedLiteral(node);
        }
        return node.getText();
    }

    private static String unescapeQuotedString(TerminalNode ctx) {
        String inputText = ctx.getText();
        assert (inputText.length() >= 2 && inputText.charAt(0) == '\"' && inputText.charAt(inputText.length() - 1) == '\"');
        StringBuilder sb = new StringBuilder();
        int i = 1;
        block8: while (i < inputText.length() - 1) {
            char currentChar;
            if ((currentChar = inputText.charAt(i++)) == '\\' && i + 1 < inputText.length()) {
                currentChar = inputText.charAt(i++);
                switch (currentChar) {
                    case 't': {
                        sb.append('\t');
                        continue block8;
                    }
                    case 'n': {
                        sb.append('\n');
                        continue block8;
                    }
                    case 'r': {
                        sb.append('\r');
                        continue block8;
                    }
                    case 'u': {
                        i = ParserUtils.handleUnicodeSequemce(ctx, sb, inputText, i);
                        continue block8;
                    }
                    case '\"': {
                        sb.append('\"');
                        continue block8;
                    }
                    case '\\': {
                        sb.append('\\');
                        continue block8;
                    }
                }
                sb.append('\\').append(currentChar);
                continue;
            }
            sb.append(currentChar);
        }
        return sb.toString();
    }

    private static String unescapeUnquotedLiteral(TerminalNode ctx) {
        String inputText = ctx.getText();
        if (inputText == null || inputText.isEmpty()) {
            return inputText;
        }
        StringBuilder sb = new StringBuilder(inputText.length());
        int i = 0;
        block9: while (i < inputText.length()) {
            char currentChar;
            if ((currentChar = inputText.charAt(i++)) == '\\' && i < inputText.length()) {
                if (ParserUtils.isEscapedKeywordSequence(inputText, i)) {
                    String sequence = ParserUtils.handleKeywordSequence(inputText, i);
                    sb.append(sequence);
                    i += sequence.length();
                    continue;
                }
                currentChar = inputText.charAt(i++);
                switch (currentChar) {
                    case 't': {
                        sb.append('\t');
                        continue block9;
                    }
                    case 'n': {
                        sb.append('\n');
                        continue block9;
                    }
                    case 'r': {
                        sb.append('\r');
                        continue block9;
                    }
                    case 'u': {
                        i = ParserUtils.handleUnicodeSequemce(ctx, sb, inputText, i);
                        continue block9;
                    }
                    case '\"': {
                        sb.append('\"');
                        continue block9;
                    }
                    case '\\': {
                        sb.append('\\');
                        continue block9;
                    }
                    case '(': 
                    case ')': 
                    case '*': 
                    case ':': 
                    case '<': 
                    case '>': 
                    case '{': 
                    case '}': {
                        sb.append(currentChar);
                        continue block9;
                    }
                }
                sb.append('\\').append(currentChar);
                continue;
            }
            sb.append(currentChar);
        }
        return sb.toString();
    }

    private static boolean isEscapedKeywordSequence(String input, int startIndex) {
        if (startIndex + 1 >= input.length()) {
            return false;
        }
        String remaining = input.substring(startIndex).toLowerCase(Locale.ROOT);
        return remaining.startsWith("and") || remaining.startsWith("or") || remaining.startsWith("not");
    }

    private static String handleKeywordSequence(String input, int startIndex) {
        String remaining = input.substring(startIndex);
        if (remaining.toLowerCase(Locale.ROOT).startsWith("and")) {
            return remaining.substring(0, 3);
        }
        if (remaining.toLowerCase(Locale.ROOT).startsWith("or")) {
            return remaining.substring(0, 2);
        }
        if (remaining.toLowerCase(Locale.ROOT).startsWith("not")) {
            return remaining.substring(0, 3);
        }
        return "";
    }

    private static int handleUnicodeSequemce(TerminalNode ctx, StringBuilder sb, String text, int startIdx) {
        int endIdx = startIdx + 4;
        String hex = text.substring(startIdx, endIdx);
        try {
            int code = Integer.parseInt(hex, 16);
            if (code >= 55296 && code <= 57343) {
                throw new KqlParsingException("Invalid unicode character code, [{}] is a surrogate code", ctx.getSymbol().getLine(), ctx.getSymbol().getCharPositionInLine() + startIdx, hex);
            }
            sb.append(String.valueOf(Character.toChars(code)));
        }
        catch (IllegalArgumentException e) {
            throw new KqlParsingException("Invalid unicode character code [{}]", ctx.getSymbol().getLine(), ctx.getSymbol().getCharPositionInLine() + startIdx, hex);
        }
        return endIdx;
    }
}

