/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.downsample;

import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.admin.cluster.stats.MappingVisitor;
import org.elasticsearch.action.admin.indices.create.CreateIndexClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.downsample.DownsampleAction;
import org.elasticsearch.action.downsample.DownsampleConfig;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.SimpleBatchedExecutor;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.DataTier;
import org.elasticsearch.cluster.routing.allocation.allocator.AllocationActionListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.TimeSeriesParams;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.downsample.DownsampleShardPersistentTaskState;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.security.authz.AuthorizationServiceField;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.downsample.DownsampleMetrics;
import org.elasticsearch.xpack.downsample.DownsampleShardTaskParams;
import org.elasticsearch.xpack.downsample.TimeseriesFieldTypeHelper;

public class TransportDownsampleAction
extends AcknowledgedTransportMasterNodeAction<DownsampleAction.Request> {
    private static final Logger logger = LogManager.getLogger(TransportDownsampleAction.class);
    private final Client client;
    private final IndicesService indicesService;
    private final MasterServiceTaskQueue<DownsampleClusterStateUpdateTask> taskQueue;
    private final MetadataCreateIndexService metadataCreateIndexService;
    private final IndexScopedSettings indexScopedSettings;
    private final PersistentTasksService persistentTasksService;
    private final DownsampleMetrics downsampleMetrics;
    private final ProjectResolver projectResolver;
    private final Supplier<Long> nowSupplier;
    private static final Set<String> FORBIDDEN_SETTINGS = Set.of(IndexSettings.DEFAULT_PIPELINE.getKey(), IndexSettings.FINAL_PIPELINE.getKey(), IndexMetadata.INDEX_BLOCKS_WRITE_SETTING.getKey(), LifecycleSettings.LIFECYCLE_NAME_SETTING.getKey());
    private static final Set<String> OVERRIDE_SETTINGS = Set.of(DataTier.TIER_PREFERENCE_SETTING.getKey());
    static final SimpleBatchedExecutor<DownsampleClusterStateUpdateTask, Void> STATE_UPDATE_TASK_EXECUTOR = new SimpleBatchedExecutor<DownsampleClusterStateUpdateTask, Void>(){

        public Tuple<ClusterState, Void> executeTask(DownsampleClusterStateUpdateTask task, ClusterState clusterState) throws Exception {
            return Tuple.tuple((Object)task.execute(clusterState), null);
        }

        public void taskSucceeded(DownsampleClusterStateUpdateTask task, Void unused) {
            task.listener.onResponse((Object)AcknowledgedResponse.TRUE);
        }
    };

    @Inject
    public TransportDownsampleAction(Client client, IndicesService indicesService, ClusterService clusterService, TransportService transportService, ThreadPool threadPool, MetadataCreateIndexService metadataCreateIndexService, ActionFilters actionFilters, ProjectResolver projectResolver, IndexScopedSettings indexScopedSettings, PersistentTasksService persistentTasksService, DownsampleMetrics downsampleMetrics) {
        this((Client)new OriginSettingClient(client, "rollup"), indicesService, clusterService, transportService, threadPool, metadataCreateIndexService, actionFilters, projectResolver, indexScopedSettings, persistentTasksService, downsampleMetrics, (MasterServiceTaskQueue<DownsampleClusterStateUpdateTask>)clusterService.createTaskQueue("downsample", Priority.URGENT, STATE_UPDATE_TASK_EXECUTOR), () -> client.threadPool().relativeTimeInMillis());
    }

    TransportDownsampleAction(Client client, IndicesService indicesService, ClusterService clusterService, TransportService transportService, ThreadPool threadPool, MetadataCreateIndexService metadataCreateIndexService, ActionFilters actionFilters, ProjectResolver projectResolver, IndexScopedSettings indexScopedSettings, PersistentTasksService persistentTasksService, DownsampleMetrics downsampleMetrics, MasterServiceTaskQueue<DownsampleClusterStateUpdateTask> taskQueue, Supplier<Long> nowSupplier) {
        super("indices:admin/xpack/downsample", transportService, clusterService, threadPool, actionFilters, DownsampleAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.client = client;
        this.indicesService = indicesService;
        this.metadataCreateIndexService = metadataCreateIndexService;
        this.projectResolver = projectResolver;
        this.indexScopedSettings = indexScopedSettings;
        this.taskQueue = taskQueue;
        this.persistentTasksService = persistentTasksService;
        this.downsampleMetrics = downsampleMetrics;
        this.nowSupplier = nowSupplier;
    }

    private void recordSuccessMetrics(long startTime) {
        this.recordOperation(startTime, DownsampleMetrics.ActionStatus.SUCCESS);
    }

    private void recordFailureMetrics(long startTime) {
        this.recordOperation(startTime, DownsampleMetrics.ActionStatus.FAILED);
    }

    private void recordInvalidConfigurationMetrics(long startTime) {
        this.recordOperation(startTime, DownsampleMetrics.ActionStatus.INVALID_CONFIGURATION);
    }

    private void recordOperation(long startTime, DownsampleMetrics.ActionStatus status) {
        this.downsampleMetrics.recordOperation(TimeValue.timeValueMillis((long)(this.nowSupplier.get() - startTime)).getMillis(), status);
    }

    protected void masterOperation(Task task, DownsampleAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        ProjectMetadata projectMetadata;
        IndexMetadata sourceIndexMetadata;
        IndicesAccessControl.IndexAccessControl indexPermissions;
        logger.debug("Starting downsampling [{}] with [{}] interval", (Object)request.getSourceIndex(), (Object)request.getDownsampleConfig().getFixedInterval());
        long startTime = this.nowSupplier.get();
        String sourceIndexName = request.getSourceIndex();
        IndexNameExpressionResolver.assertExpressionHasNullOrDataSelector((String)sourceIndexName);
        IndexNameExpressionResolver.assertExpressionHasNullOrDataSelector((String)request.getTargetIndex());
        IndicesAccessControl indicesAccessControl = (IndicesAccessControl)AuthorizationServiceField.INDICES_PERMISSIONS_VALUE.get(this.threadPool.getThreadContext());
        if (indicesAccessControl != null && (indexPermissions = indicesAccessControl.getIndexPermissions(sourceIndexName)) != null) {
            boolean hasDocumentLevelPermissions = indexPermissions.getDocumentPermissions().hasDocumentLevelPermissions();
            boolean hasFieldLevelSecurity = indexPermissions.getFieldPermissions().hasFieldLevelSecurity();
            if (hasDocumentLevelPermissions || hasFieldLevelSecurity) {
                this.recordInvalidConfigurationMetrics(startTime);
                listener.onFailure((Exception)new ElasticsearchException("Rollup forbidden for index [" + sourceIndexName + "] with document level or field level security settings.", new Object[0]));
                return;
            }
        }
        if ((sourceIndexMetadata = (projectMetadata = this.projectResolver.getProjectMetadata(state)).index(sourceIndexName)) == null) {
            this.recordInvalidConfigurationMetrics(startTime);
            listener.onFailure((Exception)((Object)new IndexNotFoundException(sourceIndexName)));
            return;
        }
        if (IndexSettings.MODE.get(sourceIndexMetadata.getSettings()) != IndexMode.TIME_SERIES) {
            this.recordInvalidConfigurationMetrics(startTime);
            listener.onFailure((Exception)new ElasticsearchException("Rollup requires setting [" + IndexSettings.MODE.getKey() + "=" + String.valueOf(IndexMode.TIME_SERIES) + "] for index [" + sourceIndexName + "]", new Object[0]));
            return;
        }
        if (!state.blocks().indexBlocked(projectMetadata.id(), ClusterBlockLevel.WRITE, sourceIndexName)) {
            this.recordInvalidConfigurationMetrics(startTime);
            listener.onFailure((Exception)new ElasticsearchException("Downsample requires setting [" + IndexMetadata.SETTING_BLOCKS_WRITE + " = true] for index [" + sourceIndexName + "]", new Object[0]));
            return;
        }
        TaskId parentTask = new TaskId(this.clusterService.localNode().getId(), task.getId());
        String downsampleIndexName = request.getTargetIndex();
        if (this.canShortCircuit(downsampleIndexName, parentTask, request.getWaitTimeout(), startTime, true, projectMetadata, listener)) {
            logger.info("Skipping downsampling, because a previous execution already completed downsampling");
            return;
        }
        try {
            MetadataCreateIndexService.validateIndexName((String)downsampleIndexName, (ProjectMetadata)projectMetadata, (RoutingTable)state.routingTable(projectMetadata.id()));
        }
        catch (ResourceAlreadyExistsException resourceAlreadyExistsException) {
            // empty catch block
        }
        GetMappingsRequest getMappingsRequest = new GetMappingsRequest(request.masterNodeTimeout()).indices(new String[]{sourceIndexName});
        getMappingsRequest.setParentTask(parentTask);
        this.client.admin().indices().getMappings(getMappingsRequest, listener.delegateFailureAndWrap((delegate, getMappingsResponse) -> {
            String mapping2;
            Map sourceIndexMappings = getMappingsResponse.mappings().entrySet().stream().filter(entry -> sourceIndexName.equals(entry.getKey())).findFirst().map(mappingMetadata -> ((MappingMetadata)mappingMetadata.getValue()).sourceAsMap()).orElseThrow(() -> new IllegalArgumentException("No mapping found for downsample source index [" + sourceIndexName + "]"));
            MapperService mapperService = this.indicesService.createIndexMapperServiceForValidation(sourceIndexMetadata);
            CompressedXContent sourceIndexCompressedXContent = new CompressedXContent(sourceIndexMappings);
            mapperService.merge("_doc", sourceIndexCompressedXContent, MapperService.MergeReason.INDEX_TEMPLATE);
            boolean forceMergeEnabled = this.isForceMergeEnabled(sourceIndexMappings);
            TransportDownsampleAction.validateDownsamplingInterval(mapperService, request.getDownsampleConfig());
            ArrayList dimensionFields = new ArrayList();
            ArrayList metricFields = new ArrayList();
            ArrayList labelFields = new ArrayList();
            TimeseriesFieldTypeHelper helper = new TimeseriesFieldTypeHelper.Builder(mapperService).build(request.getDownsampleConfig().getTimestampField());
            MappingVisitor.visitMapping((Map)sourceIndexMappings, (field, mapping) -> {
                List<String> flattenedDimensions = helper.extractFlattenedDimensions((String)field, (Map<String, ?>)mapping);
                if (flattenedDimensions != null) {
                    dimensionFields.addAll(flattenedDimensions);
                } else if (helper.isTimeSeriesDimension((String)field, (Map<String, ?>)mapping)) {
                    dimensionFields.add(field);
                } else if (helper.isTimeSeriesMetric((String)field, (Map<String, ?>)mapping)) {
                    metricFields.add(field);
                } else if (helper.isTimeSeriesLabel((String)field, (Map<String, ?>)mapping)) {
                    labelFields.add(field);
                }
            });
            ActionRequestValidationException validationException = new ActionRequestValidationException();
            if (dimensionFields.isEmpty()) {
                validationException.addValidationError("Index [" + sourceIndexName + "] does not contain any dimension fields");
            }
            if (!validationException.validationErrors().isEmpty()) {
                this.recordInvalidConfigurationMetrics(startTime);
                delegate.onFailure((Exception)validationException);
                return;
            }
            try {
                mapping2 = TransportDownsampleAction.createDownsampleIndexMapping(helper, request.getDownsampleConfig(), mapperService, sourceIndexMappings);
            }
            catch (IOException e2) {
                this.recordFailureMetrics(startTime);
                delegate.onFailure((Exception)e2);
                return;
            }
            int minNumReplicas = this.clusterService.getSettings().getAsInt("downsample.min_number_of_replicas", Integer.valueOf(0));
            this.createDownsampleIndex(projectMetadata.id(), downsampleIndexName, minNumReplicas, sourceIndexMetadata, mapping2, request, (ActionListener<AcknowledgedResponse>)ActionListener.wrap(createIndexResp -> {
                if (createIndexResp.isAcknowledged()) {
                    this.performShardDownsampling(projectMetadata.id(), request, (ActionListener<AcknowledgedResponse>)delegate, minNumReplicas, sourceIndexMetadata, downsampleIndexName, parentTask, startTime, metricFields, labelFields, dimensionFields, forceMergeEnabled);
                } else {
                    this.recordFailureMetrics(startTime);
                    delegate.onFailure((Exception)new ElasticsearchException("Failed to create downsample index [" + downsampleIndexName + "]", new Object[0]));
                }
            }, e -> {
                if (e instanceof ResourceAlreadyExistsException) {
                    if (this.canShortCircuit(request.getTargetIndex(), parentTask, request.getWaitTimeout(), startTime, forceMergeEnabled, this.clusterService.state().metadata().getProject(projectMetadata.id()), listener)) {
                        logger.info("Downsample tasks are not created, because a previous execution already completed downsampling");
                        return;
                    }
                    this.performShardDownsampling(projectMetadata.id(), request, (ActionListener<AcknowledgedResponse>)delegate, minNumReplicas, sourceIndexMetadata, downsampleIndexName, parentTask, startTime, metricFields, labelFields, dimensionFields, forceMergeEnabled);
                } else {
                    this.recordFailureMetrics(startTime);
                    delegate.onFailure(e);
                }
            }));
        }));
    }

    private boolean isForceMergeEnabled(Map<String, Object> sourceIndexMappings) {
        Map metadataMap;
        Object enabledForceMergeValue;
        Object object;
        if (sourceIndexMappings.containsKey("_meta") && (object = sourceIndexMappings.get("_meta")) instanceof Map && (enabledForceMergeValue = (metadataMap = (Map)object).get("downsample.forcemerge.enabled")) instanceof Boolean) {
            Boolean enabledForceMerge = (Boolean)enabledForceMergeValue;
            return enabledForceMerge;
        }
        return true;
    }

    private boolean canShortCircuit(String targetIndexName, TaskId parentTask, TimeValue waitTimeout, long startTime, boolean forceMergeEnabled, ProjectMetadata projectMetadata, ActionListener<AcknowledgedResponse> listener) {
        IndexMetadata targetIndexMetadata = projectMetadata.index(targetIndexName);
        if (targetIndexMetadata == null) {
            return false;
        }
        IndexMetadata.DownsampleTaskStatus downsampleStatus = (IndexMetadata.DownsampleTaskStatus)IndexMetadata.INDEX_DOWNSAMPLE_STATUS.get(targetIndexMetadata.getSettings());
        if (downsampleStatus == IndexMetadata.DownsampleTaskStatus.UNKNOWN) {
            listener.onFailure((Exception)((Object)new ResourceAlreadyExistsException(targetIndexMetadata.getIndex())));
            return true;
        }
        if (downsampleStatus == IndexMetadata.DownsampleTaskStatus.SUCCESS) {
            listener.onResponse((Object)AcknowledgedResponse.TRUE);
            return true;
        }
        if (targetIndexMetadata.getSettings().get(IndexMetadata.SETTING_BLOCKS_WRITE) != null) {
            RefreshRequest refreshRequest = new RefreshRequest(new String[]{targetIndexMetadata.getIndex().getName()});
            refreshRequest.setParentTask(parentTask);
            this.client.admin().indices().refresh(refreshRequest, (ActionListener)new RefreshDownsampleIndexActionListener(projectMetadata.id(), listener, parentTask, targetIndexMetadata.getIndex().getName(), waitTimeout, startTime, forceMergeEnabled));
            return true;
        }
        return false;
    }

    private void performShardDownsampling(final ProjectId projectId, final DownsampleAction.Request request, final ActionListener<AcknowledgedResponse> listener, final int minNumReplicas, final IndexMetadata sourceIndexMetadata, final String downsampleIndexName, final TaskId parentTask, final long startTime, List<String> metricFields, List<String> labelFields, List<String> dimensionFields, final boolean forceMergeEnabled) {
        final int numberOfShards = sourceIndexMetadata.getNumberOfShards();
        Index sourceIndex = sourceIndexMetadata.getIndex();
        final AtomicInteger countDown = new AtomicInteger(numberOfShards);
        final AtomicBoolean errorReported = new AtomicBoolean(false);
        for (int shardNum = 0; shardNum < numberOfShards; ++shardNum) {
            ShardId shardId = new ShardId(sourceIndex, shardNum);
            final String persistentTaskId = TransportDownsampleAction.createPersistentTaskId(downsampleIndexName, shardId, request.getDownsampleConfig().getInterval());
            final DownsampleShardTaskParams params = TransportDownsampleAction.createPersistentTaskParams(request.getDownsampleConfig(), sourceIndexMetadata, downsampleIndexName, metricFields, labelFields, dimensionFields, shardId);
            Predicate<PersistentTasksCustomMetadata.PersistentTask> predicate = runningTask -> {
                if (runningTask == null) {
                    return true;
                }
                DownsampleShardPersistentTaskState runningPersistentTaskState = (DownsampleShardPersistentTaskState)runningTask.getState();
                return runningPersistentTaskState != null && runningPersistentTaskState.done();
            };
            PersistentTasksService.WaitForPersistentTaskListener<PersistentTaskParams> taskListener = new PersistentTasksService.WaitForPersistentTaskListener<PersistentTaskParams>(){

                public void onResponse(PersistentTasksCustomMetadata.PersistentTask<PersistentTaskParams> persistentTask) {
                    DownsampleShardPersistentTaskState runningPersistentTaskState;
                    if (persistentTask != null && (runningPersistentTaskState = (DownsampleShardPersistentTaskState)persistentTask.getState()) != null) {
                        if (runningPersistentTaskState.failed()) {
                            this.onFailure((Exception)new ElasticsearchException("downsample task [" + persistentTaskId + "] failed", new Object[0]));
                            return;
                        }
                        if (runningPersistentTaskState.cancelled()) {
                            this.onFailure((Exception)new ElasticsearchException("downsample task [" + persistentTaskId + "] cancelled", new Object[0]));
                            return;
                        }
                    }
                    logger.info("Downsampling task [" + persistentTaskId + " completed for shard " + String.valueOf(params.shardId()));
                    if (countDown.decrementAndGet() == 0) {
                        logger.info("All downsampling tasks completed [" + numberOfShards + "]");
                        TransportDownsampleAction.this.updateTargetIndexSettingStep(projectId, request, (ActionListener<AcknowledgedResponse>)listener, minNumReplicas, sourceIndexMetadata, downsampleIndexName, parentTask, startTime, forceMergeEnabled);
                    }
                }

                public void onFailure(Exception e) {
                    logger.error("error while waiting for downsampling persistent task", (Throwable)e);
                    if (!errorReported.getAndSet(true)) {
                        TransportDownsampleAction.this.recordFailureMetrics(startTime);
                    }
                    listener.onFailure(e);
                }
            };
            this.persistentTasksService.sendStartRequest(persistentTaskId, "rollup-shard", (PersistentTaskParams)params, TimeValue.THIRTY_SECONDS, ActionListener.wrap(arg_0 -> this.lambda$performShardDownsampling$9(projectId, predicate, request, taskListener, arg_0), arg_0 -> this.lambda$performShardDownsampling$10(persistentTaskId, projectId, predicate, request, taskListener, listener, arg_0)));
        }
    }

    private void updateTargetIndexSettingStep(ProjectId projectId, DownsampleAction.Request request, ActionListener<AcknowledgedResponse> listener, int minNumReplicas, IndexMetadata sourceIndexMetadata, String downsampleIndexName, TaskId parentTask, long startTime, boolean forceMergeEnabled) {
        Settings.Builder settings = Settings.builder().put(IndexMetadata.SETTING_BLOCKS_WRITE, true);
        if (sourceIndexMetadata.getNumberOfReplicas() > 0 && minNumReplicas == 0) {
            settings.put("index.number_of_replicas", sourceIndexMetadata.getNumberOfReplicas());
        }
        if (!sourceIndexMetadata.isHidden()) {
            if (sourceIndexMetadata.getSettings().keySet().contains("index.hidden")) {
                settings.put("index.hidden", false);
            } else {
                settings.putNull("index.hidden");
            }
        }
        UpdateSettingsRequest updateSettingsReq = new UpdateSettingsRequest(settings.build(), new String[]{downsampleIndexName});
        updateSettingsReq.setParentTask(parentTask);
        this.client.admin().indices().updateSettings(updateSettingsReq, (ActionListener)new UpdateDownsampleIndexSettingsActionListener(projectId, listener, parentTask, downsampleIndexName, request.getWaitTimeout(), startTime, forceMergeEnabled));
    }

    private static DownsampleShardTaskParams createPersistentTaskParams(DownsampleConfig downsampleConfig, IndexMetadata sourceIndexMetadata, String targetIndexName, List<String> metricFields, List<String> labelFields, List<String> dimensionFields, ShardId shardId) {
        return new DownsampleShardTaskParams(downsampleConfig, targetIndexName, TransportDownsampleAction.parseTimestamp(sourceIndexMetadata, (Setting<Instant>)IndexSettings.TIME_SERIES_START_TIME), TransportDownsampleAction.parseTimestamp(sourceIndexMetadata, (Setting<Instant>)IndexSettings.TIME_SERIES_END_TIME), shardId, metricFields.toArray(new String[0]), labelFields.toArray(new String[0]), dimensionFields.toArray(new String[0]));
    }

    private static long parseTimestamp(IndexMetadata sourceIndexMetadata, Setting<Instant> timestampSetting) {
        return OffsetDateTime.parse(sourceIndexMetadata.getSettings().get(timestampSetting.getKey()), DateTimeFormatter.ISO_DATE_TIME).toInstant().toEpochMilli();
    }

    private static String createPersistentTaskId(String targetIndex, ShardId shardId, DateHistogramInterval interval) {
        return "downsample-" + targetIndex + "-" + shardId.id() + "-" + String.valueOf(interval);
    }

    protected ClusterBlockException checkBlock(DownsampleAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    public static String createDownsampleIndexMapping(TimeseriesFieldTypeHelper helper, DownsampleConfig config, MapperService mapperService, Map<String, Object> sourceIndexMappings) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
        TransportDownsampleAction.addDynamicTemplates(builder);
        builder.startObject("properties");
        TransportDownsampleAction.addTimestampField(config, sourceIndexMappings, builder);
        TransportDownsampleAction.addMetricFields(helper, sourceIndexMappings, builder);
        builder.endObject();
        builder.endObject();
        CompressedXContent mappingDiffXContent = CompressedXContent.fromJSON((String)XContentHelper.convertToJson((BytesReference)BytesReference.bytes((XContentBuilder)builder), (boolean)false, (XContentType)XContentType.JSON));
        return mapperService.merge("_doc", mappingDiffXContent, MapperService.MergeReason.INDEX_TEMPLATE).mappingSource().uncompressed().utf8ToString();
    }

    private static void addMetricFields(TimeseriesFieldTypeHelper helper, Map<String, Object> sourceIndexMappings, XContentBuilder builder) {
        MappingVisitor.visitMapping(sourceIndexMappings, (field, mapping) -> {
            if (helper.isTimeSeriesMetric((String)field, (Map<String, ?>)mapping)) {
                try {
                    TransportDownsampleAction.addMetricFieldMapping(builder, field, mapping);
                }
                catch (IOException e) {
                    throw new ElasticsearchException("Error while adding metric for field [" + field + "]", new Object[0]);
                }
            }
        });
    }

    private static void addTimestampField(DownsampleConfig config, Map<String, Object> sourceIndexMappings, XContentBuilder builder) throws IOException {
        String timestampField = config.getTimestampField();
        String dateIntervalType = config.getIntervalType();
        String dateInterval = config.getInterval().toString();
        String timezone = config.getTimeZone();
        builder.startObject(timestampField);
        MappingVisitor.visitMapping(sourceIndexMappings, (field, mapping) -> {
            try {
                if (timestampField.equals(field)) {
                    String timestampType = String.valueOf(mapping.get("type"));
                    builder.field("type", timestampType != null ? timestampType : "date");
                    if (mapping.get("format") != null) {
                        builder.field("format", mapping.get("format"));
                    }
                    if (mapping.get("ignore_malformed") != null) {
                        builder.field("ignore_malformed", mapping.get("ignore_malformed"));
                    }
                }
            }
            catch (IOException e) {
                throw new ElasticsearchException("Unable to create timestamp field mapping for field [" + timestampField + "]", (Throwable)e, new Object[0]);
            }
        });
        builder.startObject("meta").field(dateIntervalType, dateInterval).field("time_zone", timezone).endObject().endObject();
    }

    public static AggregateMetricDoubleFieldSupportedMetrics getSupportedMetrics(TimeSeriesParams.MetricType metricType, Map<String, ?> fieldProperties) {
        boolean sourceIsAggregate = fieldProperties.get("type").equals("aggregate_metric_double");
        List<String> supportedAggs = List.of(metricType.supportedAggs());
        if (sourceIsAggregate) {
            List currentAggs = (List)fieldProperties.get("metrics");
            supportedAggs = supportedAggs.stream().filter(currentAggs::contains).toList();
        }
        assert (supportedAggs.size() > 0);
        String defaultMetric = "max";
        if (!supportedAggs.contains(defaultMetric)) {
            defaultMetric = supportedAggs.get(0);
        }
        if (sourceIsAggregate) {
            defaultMetric = Objects.requireNonNullElse((String)fieldProperties.get("default_metric"), defaultMetric);
        }
        return new AggregateMetricDoubleFieldSupportedMetrics(defaultMetric, supportedAggs);
    }

    private static void addMetricFieldMapping(XContentBuilder builder, String field, Map<String, ?> fieldProperties) throws IOException {
        TimeSeriesParams.MetricType metricType = TimeSeriesParams.MetricType.fromString((String)fieldProperties.get("time_series_metric").toString());
        builder.startObject(field);
        if (metricType == TimeSeriesParams.MetricType.COUNTER) {
            for (String fieldProperty : fieldProperties.keySet()) {
                builder.field(fieldProperty, fieldProperties.get(fieldProperty));
            }
        } else {
            AggregateMetricDoubleFieldSupportedMetrics supported = TransportDownsampleAction.getSupportedMetrics(metricType, fieldProperties);
            builder.field("type", "aggregate_metric_double").stringListField("metrics", supported.supportedMetrics).field("default_metric", supported.defaultMetric).field("time_series_metric", (Enum)metricType);
        }
        builder.endObject();
    }

    private static void validateDownsamplingInterval(MapperService mapperService, DownsampleConfig config) {
        MappedFieldType timestampFieldType = mapperService.fieldType(config.getTimestampField());
        assert (timestampFieldType != null) : "Cannot find timestamp field [" + config.getTimestampField() + "] in the mapping";
        ActionRequestValidationException e = new ActionRequestValidationException();
        Map meta = timestampFieldType.meta();
        if (!meta.isEmpty()) {
            String sourceTimezone;
            String interval = (String)meta.get(config.getIntervalType());
            if (interval != null) {
                try {
                    DownsampleConfig sourceConfig = new DownsampleConfig(new DateHistogramInterval(interval));
                    DownsampleConfig.validateSourceAndTargetIntervals((DownsampleConfig)sourceConfig, (DownsampleConfig)config);
                }
                catch (IllegalArgumentException exception) {
                    e.addValidationError("Source index is a downsampled index. " + exception.getMessage());
                }
            }
            if ((sourceTimezone = (String)meta.get("time_zone")) != null && !sourceTimezone.equals(config.getTimeZone())) {
                e.addValidationError("Source index is a downsampled index. Downsampling timezone [" + config.getTimeZone() + "] cannot be different than the source index timezone [" + sourceTimezone + "].");
            }
            if (!e.validationErrors().isEmpty()) {
                throw e;
            }
        }
    }

    static IndexMetadata.Builder copyIndexMetadata(IndexMetadata sourceIndexMetadata, IndexMetadata downsampleIndexMetadata, IndexScopedSettings indexScopedSettings) {
        Settings.Builder targetSettings = Settings.builder().put(downsampleIndexMetadata.getSettings());
        for (String key : sourceIndexMetadata.getSettings().keySet()) {
            Setting setting = indexScopedSettings.get(key);
            if (setting == null) {
                assert (indexScopedSettings.isPrivateSetting(key)) : "expected [" + key + "] to be private but it was not";
            } else if (setting.getProperties().contains(Setting.Property.NotCopyableOnResize)) continue;
            if (FORBIDDEN_SETTINGS.contains(key)) continue;
            if (OVERRIDE_SETTINGS.contains(key)) {
                targetSettings.put(key, sourceIndexMetadata.getSettings().get(key));
            }
            if (targetSettings.keys().contains(key)) continue;
            targetSettings.copy(key, sourceIndexMetadata.getSettings());
        }
        Index sourceIndex = sourceIndexMetadata.getIndex();
        if (!IndexMetadata.INDEX_DOWNSAMPLE_ORIGIN_UUID.exists(sourceIndexMetadata.getSettings()) || !IndexMetadata.INDEX_DOWNSAMPLE_ORIGIN_NAME.exists(sourceIndexMetadata.getSettings())) {
            targetSettings.put(IndexMetadata.INDEX_DOWNSAMPLE_ORIGIN_NAME.getKey(), sourceIndex.getName()).put(IndexMetadata.INDEX_DOWNSAMPLE_ORIGIN_UUID.getKey(), sourceIndex.getUUID());
        }
        targetSettings.put("index.downsample.source.name", sourceIndex.getName());
        targetSettings.put("index.downsample.source.uuid", sourceIndex.getUUID());
        return IndexMetadata.builder((IndexMetadata)downsampleIndexMetadata).settings(targetSettings);
    }

    private static void addDynamicTemplates(XContentBuilder builder) throws IOException {
        builder.startArray("dynamic_templates").startObject().startObject("strings").field("match_mapping_type", "string").startObject("mapping").field("type", "keyword").endObject().endObject().endObject().endArray();
    }

    private void createDownsampleIndex(ProjectId projectId, final String downsampleIndexName, int minNumReplicas, final IndexMetadata sourceIndexMetadata, String mapping, DownsampleAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        String downsampleInterval = request.getDownsampleConfig().getInterval().toString();
        Settings.Builder builder = Settings.builder().put("index.hidden", true).put("index.number_of_shards", sourceIndexMetadata.getNumberOfShards()).put("index.number_of_replicas", minNumReplicas).put(IndexSettings.INDEX_REFRESH_INTERVAL_SETTING.getKey(), "-1").put(IndexMetadata.INDEX_DOWNSAMPLE_STATUS.getKey(), (Enum)IndexMetadata.DownsampleTaskStatus.STARTED).put(IndexMetadata.INDEX_DOWNSAMPLE_INTERVAL.getKey(), downsampleInterval).put(IndexSettings.MODE.getKey(), (Enum)sourceIndexMetadata.getIndexMode()).putList(IndexMetadata.INDEX_ROUTING_PATH.getKey(), sourceIndexMetadata.getRoutingPaths()).put(IndexSettings.TIME_SERIES_START_TIME.getKey(), sourceIndexMetadata.getSettings().get(IndexSettings.TIME_SERIES_START_TIME.getKey())).put(IndexSettings.TIME_SERIES_END_TIME.getKey(), sourceIndexMetadata.getSettings().get(IndexSettings.TIME_SERIES_END_TIME.getKey()));
        if (!sourceIndexMetadata.getTimeSeriesDimensions().isEmpty()) {
            builder.putList(IndexMetadata.INDEX_DIMENSIONS.getKey(), sourceIndexMetadata.getTimeSeriesDimensions());
        }
        if (sourceIndexMetadata.getSettings().hasValue(MapperService.INDEX_MAPPING_TOTAL_FIELDS_LIMIT_SETTING.getKey())) {
            builder.put(MapperService.INDEX_MAPPING_TOTAL_FIELDS_LIMIT_SETTING.getKey(), sourceIndexMetadata.getSettings().get(MapperService.INDEX_MAPPING_TOTAL_FIELDS_LIMIT_SETTING.getKey()));
        }
        if (sourceIndexMetadata.getSettings().hasValue(FieldMapper.IGNORE_MALFORMED_SETTING.getKey())) {
            builder.put(FieldMapper.IGNORE_MALFORMED_SETTING.getKey(), sourceIndexMetadata.getSettings().get(FieldMapper.IGNORE_MALFORMED_SETTING.getKey()));
        }
        final CreateIndexClusterStateUpdateRequest createIndexClusterStateUpdateRequest = new CreateIndexClusterStateUpdateRequest("downsample", projectId, downsampleIndexName, downsampleIndexName).settings(builder.build()).settingsSystemProvided(true).mappings(mapping).waitForActiveShards(ActiveShardCount.ONE);
        final AllocationActionListener delegate = new AllocationActionListener(listener, this.threadPool.getThreadContext());
        this.taskQueue.submitTask("create-downsample-index [" + downsampleIndexName + "]", (ClusterStateTaskListener)new DownsampleClusterStateUpdateTask(listener){

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                logger.debug("Creating downsample index [{}]", (Object)downsampleIndexName);
                return TransportDownsampleAction.this.metadataCreateIndexService.applyCreateIndexRequest(currentState, createIndexClusterStateUpdateRequest, true, (builder, indexMetadata) -> builder.put(TransportDownsampleAction.copyIndexMetadata(sourceIndexMetadata, indexMetadata, TransportDownsampleAction.this.indexScopedSettings)), delegate.reroute());
            }
        }, request.masterNodeTimeout());
    }

    private /* synthetic */ void lambda$performShardDownsampling$10(String persistentTaskId, ProjectId projectId, Predicate predicate, DownsampleAction.Request request, 2 taskListener, ActionListener listener, Exception e) {
        if (e instanceof ResourceAlreadyExistsException) {
            logger.info("Task [" + persistentTaskId + "] already exists. Waiting.");
            this.persistentTasksService.waitForPersistentTaskCondition(projectId, persistentTaskId, predicate, request.getWaitTimeout(), (PersistentTasksService.WaitForPersistentTaskListener)taskListener);
        } else {
            listener.onFailure((Exception)new ElasticsearchException("Task [" + persistentTaskId + "] failed starting", (Throwable)e, new Object[0]));
        }
    }

    private /* synthetic */ void lambda$performShardDownsampling$9(ProjectId projectId, Predicate predicate, DownsampleAction.Request request, 2 taskListener, PersistentTasksCustomMetadata.PersistentTask startedTask) throws Exception {
        this.persistentTasksService.waitForPersistentTaskCondition(projectId, startedTask.getId(), predicate, request.getWaitTimeout(), (PersistentTasksService.WaitForPersistentTaskListener)taskListener);
    }

    class RefreshDownsampleIndexActionListener
    implements ActionListener<BroadcastResponse> {
        private final ProjectId projectId;
        private final ActionListener<AcknowledgedResponse> actionListener;
        private final TaskId parentTask;
        private final String downsampleIndexName;
        private final TimeValue timeout;
        private final long startTime;
        private final boolean forceMergeEnabled;

        RefreshDownsampleIndexActionListener(ProjectId projectId, ActionListener<AcknowledgedResponse> actionListener, TaskId parentTask, String downsampleIndexName, TimeValue timeout, long startTime, boolean forceMergeEnabled) {
            this.projectId = projectId;
            this.actionListener = actionListener;
            this.parentTask = parentTask;
            this.downsampleIndexName = downsampleIndexName;
            this.timeout = timeout;
            this.startTime = startTime;
            this.forceMergeEnabled = forceMergeEnabled;
        }

        public void onResponse(BroadcastResponse response) {
            if (response.getFailedShards() != 0) {
                logger.info("Post refresh failed [{}],{}", (Object)this.downsampleIndexName, (Object)Strings.toString((ToXContent)response));
            }
            Object nextStepListener = this.forceMergeEnabled ? new ForceMergeActionListener(this.parentTask, this.downsampleIndexName, this.startTime, this.actionListener) : new MeasurementActionListener(this.startTime, this.actionListener);
            TransportDownsampleAction.this.taskQueue.submitTask("update-downsample-metadata [" + this.downsampleIndexName + "]", (ClusterStateTaskListener)new DownsampleClusterStateUpdateTask((ActionListener)nextStepListener){

                @Override
                public ClusterState execute(ClusterState currentState) {
                    logger.debug("Updating downsample index status for [{}]", (Object)RefreshDownsampleIndexActionListener.this.downsampleIndexName);
                    ProjectMetadata project = currentState.metadata().getProject(RefreshDownsampleIndexActionListener.this.projectId);
                    IndexMetadata downsampleIndex = project.index(RefreshDownsampleIndexActionListener.this.downsampleIndexName);
                    if (downsampleIndex == null) {
                        throw new IllegalStateException("Failed to update downsample status because [" + RefreshDownsampleIndexActionListener.this.downsampleIndexName + "] does not exist");
                    }
                    if (IndexMetadata.INDEX_DOWNSAMPLE_STATUS.get(downsampleIndex.getSettings()) == IndexMetadata.DownsampleTaskStatus.SUCCESS) {
                        return currentState;
                    }
                    ProjectMetadata.Builder projectBuilder = ProjectMetadata.builder((ProjectMetadata)project);
                    projectBuilder.updateSettings(Settings.builder().put(downsampleIndex.getSettings()).put(IndexMetadata.INDEX_DOWNSAMPLE_STATUS.getKey(), (Enum)IndexMetadata.DownsampleTaskStatus.SUCCESS).build(), new String[]{RefreshDownsampleIndexActionListener.this.downsampleIndexName});
                    return ClusterState.builder((ClusterState)currentState).putProjectMetadata(projectBuilder).build();
                }
            }, this.timeout);
        }

        public void onFailure(Exception e) {
            this.actionListener.onFailure(e);
        }
    }

    class UpdateDownsampleIndexSettingsActionListener
    implements ActionListener<AcknowledgedResponse> {
        final ProjectId projectId;
        final ActionListener<AcknowledgedResponse> listener;
        final TaskId parentTask;
        final String downsampleIndexName;
        final TimeValue timeout;
        final long startTime;
        final boolean forceMergeEnabled;

        UpdateDownsampleIndexSettingsActionListener(ProjectId projectId, ActionListener<AcknowledgedResponse> listener, TaskId parentTask, String downsampleIndexName, TimeValue timeout, long startTime, boolean forceMergeEnabled) {
            this.projectId = projectId;
            this.listener = listener;
            this.parentTask = parentTask;
            this.downsampleIndexName = downsampleIndexName;
            this.timeout = timeout;
            this.startTime = startTime;
            this.forceMergeEnabled = forceMergeEnabled;
        }

        public void onResponse(AcknowledgedResponse response) {
            logger.debug("Preparing to refresh downsample index [{}]", (Object)this.downsampleIndexName);
            RefreshRequest request = new RefreshRequest(new String[]{this.downsampleIndexName});
            request.setParentTask(this.parentTask);
            TransportDownsampleAction.this.client.admin().indices().refresh(request, (ActionListener)new RefreshDownsampleIndexActionListener(this.projectId, this.listener, this.parentTask, this.downsampleIndexName, this.timeout, this.startTime, this.forceMergeEnabled));
        }

        public void onFailure(Exception e) {
            this.listener.onFailure(e);
        }
    }

    public record AggregateMetricDoubleFieldSupportedMetrics(String defaultMetric, List<String> supportedMetrics) {
    }

    class MeasurementActionListener
    implements ActionListener<AcknowledgedResponse> {
        final ActionListener<AcknowledgedResponse> actionListener;
        private final long startTime;

        MeasurementActionListener(long startTime, ActionListener<AcknowledgedResponse> onFailure) {
            this.startTime = startTime;
            this.actionListener = onFailure;
        }

        public void onResponse(AcknowledgedResponse response) {
            TransportDownsampleAction.this.recordSuccessMetrics(this.startTime);
            logger.debug("Downsampling measured successfully");
            this.actionListener.onResponse((Object)AcknowledgedResponse.TRUE);
        }

        public void onFailure(Exception e) {
            TransportDownsampleAction.this.recordFailureMetrics(this.startTime);
            logger.debug("Downsampling failure measured successfully", (Throwable)e);
            this.actionListener.onFailure(e);
        }
    }

    class ForceMergeActionListener
    implements ActionListener<AcknowledgedResponse> {
        final ActionListener<AcknowledgedResponse> actionListener;
        private final TaskId parentTask;
        private final String downsampleIndexName;

        ForceMergeActionListener(TaskId parentTask, String downsampleIndexName, long startTime, ActionListener<AcknowledgedResponse> actionListener) {
            this.parentTask = parentTask;
            this.downsampleIndexName = downsampleIndexName;
            this.actionListener = new MeasurementActionListener(startTime, actionListener);
        }

        public void onResponse(AcknowledgedResponse response) {
            logger.debug("Preparing to force merge downsample index [{}]", (Object)this.downsampleIndexName);
            ForceMergeRequest request = new ForceMergeRequest(new String[]{this.downsampleIndexName});
            request.maxNumSegments(1);
            request.setParentTask(this.parentTask);
            TransportDownsampleAction.this.client.admin().indices().forceMerge(request, ActionListener.wrap(mergeIndexResp -> this.actionListener.onResponse((Object)AcknowledgedResponse.TRUE), t -> {
                logger.error("Failed to force-merge downsample index [" + this.downsampleIndexName + "]", (Throwable)t);
                this.actionListener.onResponse((Object)AcknowledgedResponse.TRUE);
            }));
        }

        public void onFailure(Exception e) {
            this.actionListener.onFailure(e);
        }
    }

    static abstract class DownsampleClusterStateUpdateTask
    implements ClusterStateTaskListener {
        final ActionListener<AcknowledgedResponse> listener;

        DownsampleClusterStateUpdateTask(ActionListener<AcknowledgedResponse> listener) {
            this.listener = listener;
        }

        public abstract ClusterState execute(ClusterState var1) throws Exception;

        public void onFailure(Exception e) {
            this.listener.onFailure(e);
        }
    }
}

