/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.restriction;

import java.util.Set;
import java.util.function.Predicate;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Predicates;

public final class WorkflowsRestriction {
    public static final WorkflowsRestriction NONE = new WorkflowsRestriction(null);
    private final Set<String> names;
    private final Predicate<String> predicate;

    public WorkflowsRestriction(Set<String> names) {
        this.names = names;
        this.predicate = names == null ? Predicates.always() : (names.isEmpty() ? Predicates.never() : name -> {
            if (name == null) {
                return false;
            }
            return names.contains(name);
        });
    }

    public boolean hasWorkflows() {
        return this.names != null;
    }

    public boolean isWorkflowAllowed(@Nullable String workflow) {
        return this.predicate.test(workflow);
    }
}

