/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.openai;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ServiceUtils;

public abstract class OpenAiTaskSettings<T extends OpenAiTaskSettings<T>>
implements TaskSettings {
    private static final Settings EMPTY_SETTINGS = new Settings(null, null);
    private final Settings taskSettings;

    public OpenAiTaskSettings(Map<String, Object> map) {
        this(OpenAiTaskSettings.fromMap(map));
    }

    public static Settings createSettings(String user, Map<String, String> stringHeaders) {
        if (user == null && stringHeaders == null) {
            return EMPTY_SETTINGS;
        }
        return new Settings(user, stringHeaders);
    }

    private static Settings fromMap(Map<String, Object> map) {
        if (map.isEmpty()) {
            return EMPTY_SETTINGS;
        }
        ValidationException validationException = new ValidationException();
        String user = ServiceUtils.extractOptionalString(map, "user", "task_settings", validationException);
        Map<String, Object> headers = ServiceUtils.extractOptionalMapRemoveNulls(map, "headers", validationException);
        Map<String, String> stringHeaders = ServiceUtils.validateMapStringValues(headers, "headers", validationException, false, null);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return OpenAiTaskSettings.createSettings(user, stringHeaders);
    }

    public OpenAiTaskSettings(@Nullable String user, @Nullable Map<String, String> headers) {
        this(new Settings(user, headers));
    }

    protected OpenAiTaskSettings(Settings taskSettings) {
        this.taskSettings = Objects.requireNonNull(taskSettings);
    }

    public String user() {
        return this.taskSettings.user();
    }

    public Map<String, String> headers() {
        return this.taskSettings.headers();
    }

    public boolean isEmpty() {
        return this.taskSettings.user() == null && (this.taskSettings.headers() == null || this.taskSettings.headers().isEmpty());
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.taskSettings.user() != null) {
            builder.field("user", this.taskSettings.user());
        }
        if (this.taskSettings.headers() != null && !this.taskSettings.headers().isEmpty()) {
            builder.field("headers", this.taskSettings.headers());
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenAiTaskSettings that = (OpenAiTaskSettings)o;
        return Objects.equals(this.taskSettings, that.taskSettings);
    }

    public int hashCode() {
        return Objects.hash(this.taskSettings);
    }

    public T updatedTaskSettings(Map<String, Object> newSettings) {
        Settings updatedSettings = OpenAiTaskSettings.fromMap(new HashMap<String, Object>(newSettings));
        String userToUse = updatedSettings.user() == null ? this.taskSettings.user() : updatedSettings.user();
        Map<String, String> headersToUse = updatedSettings.headers() == null ? this.taskSettings.headers() : updatedSettings.headers();
        return this.create(userToUse, headersToUse);
    }

    protected abstract T create(@Nullable String var1, @Nullable Map<String, String> var2);

    public record Settings(@Nullable String user, @Nullable Map<String, String> headers) {
    }
}

