/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.openai;

import java.util.concurrent.Flow;
import java.util.function.Function;
import org.apache.http.HttpResponse;
import org.elasticsearch.core.Strings;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.xpack.core.inference.results.StreamingChatCompletionResults;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.retry.BaseResponseHandler;
import org.elasticsearch.xpack.inference.external.http.retry.ContentTooLargeException;
import org.elasticsearch.xpack.inference.external.http.retry.ErrorResponse;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandlerUtils;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseParser;
import org.elasticsearch.xpack.inference.external.http.retry.RetryException;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.response.ErrorMessageResponseEntity;
import org.elasticsearch.xpack.inference.external.response.streaming.ServerSentEventParser;
import org.elasticsearch.xpack.inference.external.response.streaming.ServerSentEventProcessor;
import org.elasticsearch.xpack.inference.services.openai.OpenAiStreamingProcessor;

public class OpenAiResponseHandler
extends BaseResponseHandler {
    static final String REQUESTS_LIMIT = "x-ratelimit-limit-requests";
    static final String TOKENS_LIMIT = "x-ratelimit-limit-tokens";
    static final String REMAINING_REQUESTS = "x-ratelimit-remaining-requests";
    static final String REMAINING_TOKENS = "x-ratelimit-remaining-tokens";
    static final String CONTENT_TOO_LARGE_MESSAGE = "Please reduce your prompt; or completion length.";
    static final String VALIDATION_ERROR_MESSAGE = "Received an input validation error response";
    static final String OPENAI_SERVER_BUSY = "Received a server busy error status code";

    public OpenAiResponseHandler(String requestType, ResponseParser parseFunction, boolean canHandleStreamingResponses) {
        this(requestType, parseFunction, ErrorMessageResponseEntity::fromResponse, canHandleStreamingResponses);
    }

    protected OpenAiResponseHandler(String requestType, ResponseParser parseFunction, Function<HttpResult, ErrorResponse> errorParseFunction, boolean canHandleStreamingResponses) {
        super(requestType, parseFunction, errorParseFunction, canHandleStreamingResponses);
    }

    @Override
    protected void checkForFailureStatusCode(Request request, HttpResult result) throws RetryException {
        if (result.isSuccessfulResponse()) {
            return;
        }
        int statusCode = result.response().getStatusLine().getStatusCode();
        if (statusCode == 500) {
            throw new RetryException(true, this.buildError("Received a server error status code", request, result));
        }
        if (statusCode == 503) {
            throw new RetryException(true, this.buildError(OPENAI_SERVER_BUSY, request, result));
        }
        if (statusCode > 500) {
            throw new RetryException(false, this.buildError("Received a server error status code", request, result));
        }
        if (statusCode == 429) {
            throw this.buildExceptionHandling429(request, result);
        }
        if (OpenAiResponseHandler.isContentTooLarge(result)) {
            throw new ContentTooLargeException(this.buildError("Received a content too large status code", request, result));
        }
        if (statusCode == 401) {
            throw new RetryException(false, this.buildError("Received an authentication error status code", request, result));
        }
        if (statusCode >= 300 && statusCode < 400) {
            throw new RetryException(false, this.buildError("Unhandled redirection", request, result));
        }
        if (statusCode == 422) {
            throw new RetryException(false, this.buildError(VALIDATION_ERROR_MESSAGE, request, result));
        }
        if (statusCode == 400) {
            throw new RetryException(false, this.buildError("Received a bad request status code", request, result));
        }
        if (statusCode == 404) {
            throw new RetryException(false, this.buildError(OpenAiResponseHandler.resourceNotFoundError(request), request, result));
        }
        throw new RetryException(false, this.buildError("Received an unsuccessful status code", request, result));
    }

    private static String resourceNotFoundError(Request request) {
        return Strings.format((String)"Resource not found at [%s]", (Object[])new Object[]{request.getURI()});
    }

    protected RetryException buildExceptionHandling429(Request request, HttpResult result) {
        return new RetryException(true, this.buildError(OpenAiResponseHandler.buildRateLimitErrorMessage(result), request, result));
    }

    private static boolean isContentTooLarge(HttpResult result) {
        int statusCode = result.response().getStatusLine().getStatusCode();
        if (statusCode == 413) {
            return true;
        }
        if (statusCode == 400) {
            ErrorResponse errorEntity = ErrorMessageResponseEntity.fromResponse(result);
            return errorEntity != null && errorEntity.getErrorMessage().contains(CONTENT_TOO_LARGE_MESSAGE);
        }
        return false;
    }

    static String buildRateLimitErrorMessage(HttpResult result) {
        HttpResponse response = result.response();
        String tokenLimit = ResponseHandlerUtils.getFirstHeaderOrUnknown(response, TOKENS_LIMIT);
        String remainingTokens = ResponseHandlerUtils.getFirstHeaderOrUnknown(response, REMAINING_TOKENS);
        String requestLimit = ResponseHandlerUtils.getFirstHeaderOrUnknown(response, REQUESTS_LIMIT);
        String remainingRequests = ResponseHandlerUtils.getFirstHeaderOrUnknown(response, REMAINING_REQUESTS);
        String usageMessage = org.elasticsearch.common.Strings.format((String)"Token limit [%s], remaining tokens [%s]. Request limit [%s], remaining requests [%s]", (Object[])new Object[]{tokenLimit, remainingTokens, requestLimit, remainingRequests});
        return "Received a rate limit status code. " + usageMessage;
    }

    @Override
    public InferenceServiceResults parseResult(Request request, Flow.Publisher<HttpResult> flow) {
        ServerSentEventProcessor serverSentEventProcessor = new ServerSentEventProcessor(new ServerSentEventParser());
        OpenAiStreamingProcessor openAiProcessor = new OpenAiStreamingProcessor();
        flow.subscribe(serverSentEventProcessor);
        serverSentEventProcessor.subscribe(openAiProcessor);
        return new StreamingChatCompletionResults((Flow.Publisher)openAiProcessor);
    }
}

