/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.llama;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.inference.EmptySecretSettings;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.services.RateLimitGroupingModel;
import org.elasticsearch.xpack.inference.services.llama.action.LlamaActionVisitor;
import org.elasticsearch.xpack.inference.services.settings.DefaultSecretSettings;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public abstract class LlamaModel
extends RateLimitGroupingModel {
    protected URI uri;
    protected RateLimitSettings rateLimitSettings;

    protected LlamaModel(ModelConfigurations configurations, ModelSecrets secrets) {
        super(configurations, secrets);
    }

    protected LlamaModel(RateLimitGroupingModel model, ServiceSettings serviceSettings) {
        super(model, serviceSettings);
    }

    public URI uri() {
        return this.uri;
    }

    @Override
    public RateLimitSettings rateLimitSettings() {
        return this.rateLimitSettings;
    }

    @Override
    public int rateLimitGroupingHash() {
        return Objects.hash(this.getServiceSettings().modelId(), this.uri, this.getSecretSettings());
    }

    public void setURI(String newUri) {
        try {
            this.uri = new URI(newUri);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    protected static SecretSettings retrieveSecretSettings(Map<String, Object> secrets) {
        return secrets != null && secrets.isEmpty() ? EmptySecretSettings.INSTANCE : DefaultSecretSettings.fromMap(secrets);
    }

    protected abstract ExecutableAction accept(LlamaActionVisitor var1);
}

