/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.expression;

import java.util.List;
import java.util.function.Supplier;
import org.elasticsearch.xpack.esql.core.QlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.capabilities.Resolvable;
import org.elasticsearch.xpack.esql.core.capabilities.Resolvables;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;

public abstract class Expression
extends Node<Expression>
implements Resolvable {
    private TypeResolution lazyTypeResolution = null;
    private Boolean lazyChildrenResolved = null;
    private Expression lazyCanonical = null;
    private AttributeSet lazyReferences = null;

    public Expression(Source source, List<Expression> children) {
        super(source, children);
    }

    public boolean foldable() {
        return false;
    }

    public Object fold(FoldContext ctx) {
        throw new QlIllegalArgumentException("Should not fold expression");
    }

    public abstract Nullability nullable();

    public AttributeSet references() {
        if (this.lazyReferences == null) {
            this.lazyReferences = Expressions.references(this.children());
        }
        return this.lazyReferences;
    }

    public boolean childrenResolved() {
        if (this.lazyChildrenResolved == null) {
            this.lazyChildrenResolved = Resolvables.resolved(this.children());
        }
        return this.lazyChildrenResolved;
    }

    public final TypeResolution typeResolved() {
        if (this.lazyTypeResolution == null) {
            this.lazyTypeResolution = this.resolveType();
        }
        return this.lazyTypeResolution;
    }

    protected TypeResolution resolveType() {
        return TypeResolution.TYPE_RESOLVED;
    }

    public final Expression canonical() {
        if (this.lazyCanonical == null) {
            this.lazyCanonical = this.canonicalize();
        }
        return this.lazyCanonical;
    }

    protected Expression canonicalize() {
        if (this.children().isEmpty()) {
            return this;
        }
        List<Expression> canonicalChildren = Expressions.canonicalize(this.children());
        if (this.children().equals(canonicalChildren)) {
            return this;
        }
        return this.replaceChildrenSameSize(canonicalChildren);
    }

    public boolean semanticEquals(Expression other) {
        return this.canonical().equals(other.canonical());
    }

    public int semanticHash() {
        return this.canonical().hashCode();
    }

    @Override
    public boolean resolved() {
        return this.childrenResolved() && this.typeResolved().resolved();
    }

    public abstract DataType dataType();

    @Override
    public String toString() {
        return this.sourceText();
    }

    @Override
    public String propertiesToString(boolean skipIfChild) {
        return super.propertiesToString(false);
    }

    public static class TypeResolution {
        private final boolean failed;
        private final String message;
        public static final TypeResolution TYPE_RESOLVED = new TypeResolution(false, "");

        public TypeResolution(String message) {
            this(true, message);
        }

        private TypeResolution(boolean unresolved, String message) {
            this.failed = unresolved;
            this.message = message;
        }

        public boolean unresolved() {
            return this.failed;
        }

        public boolean resolved() {
            return !this.failed;
        }

        public TypeResolution and(TypeResolution other) {
            return this.failed ? this : other;
        }

        public TypeResolution or(TypeResolution other) {
            return this.failed ? other : this;
        }

        public TypeResolution and(Supplier<TypeResolution> other) {
            return this.failed ? this : other.get();
        }

        public String message() {
            return this.message;
        }

        public String toString() {
            return this.resolved() ? "" : this.message;
        }
    }
}

