/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.stats;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.stats.GetSecurityStatsAction;
import org.elasticsearch.xpack.core.security.action.stats.GetSecurityStatsNodeRequest;
import org.elasticsearch.xpack.core.security.action.stats.GetSecurityStatsNodeResponse;
import org.elasticsearch.xpack.core.security.action.stats.GetSecurityStatsNodesRequest;
import org.elasticsearch.xpack.core.security.action.stats.GetSecurityStatsNodesResponse;
import org.elasticsearch.xpack.security.authz.store.CompositeRolesStore;

public class TransportSecurityStatsAction
extends TransportNodesAction<GetSecurityStatsNodesRequest, GetSecurityStatsNodesResponse, GetSecurityStatsNodeRequest, GetSecurityStatsNodeResponse, Void> {
    @Nullable
    private final CompositeRolesStore rolesStore;

    @Inject
    public TransportSecurityStatsAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, CompositeRolesStore rolesStore) {
        super(GetSecurityStatsAction.INSTANCE.name(), clusterService, transportService, actionFilters, GetSecurityStatsNodeRequest::new, (Executor)threadPool.executor("management"));
        this.rolesStore = rolesStore;
    }

    protected GetSecurityStatsNodesResponse newResponse(GetSecurityStatsNodesRequest request, List<GetSecurityStatsNodeResponse> responses, List<FailedNodeException> failures) {
        return new GetSecurityStatsNodesResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected GetSecurityStatsNodeRequest newNodeRequest(GetSecurityStatsNodesRequest request) {
        return new GetSecurityStatsNodeRequest();
    }

    protected GetSecurityStatsNodeResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new GetSecurityStatsNodeResponse(in);
    }

    protected GetSecurityStatsNodeResponse nodeOperation(GetSecurityStatsNodeRequest request, Task task) {
        return new GetSecurityStatsNodeResponse(this.clusterService.localNode(), this.rolesStore == null ? null : this.rolesStore.usageStatsWithJustDls());
    }
}

