/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plugin;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.operator.DriverCompletionInfo;
import org.elasticsearch.compute.operator.DriverProfile;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.transport.TransportResponse;

final class ComputeResponse
extends TransportResponse {
    private static final TransportVersion ESQL_FAILURE_FROM_REMOTE = TransportVersion.fromName((String)"esql_failure_from_remote");
    private static final TransportVersion ESQL_DOCUMENTS_FOUND_AND_VALUES_LOADED = TransportVersion.fromName((String)"esql_documents_found_and_values_loaded");
    private final DriverCompletionInfo completionInfo;
    private final TimeValue took;
    public final int totalShards;
    public final int successfulShards;
    public final int skippedShards;
    public final int failedShards;
    public final List<ShardSearchFailure> failures;

    ComputeResponse(DriverCompletionInfo completionInfo) {
        this(completionInfo, null, null, null, null, null, List.of());
    }

    ComputeResponse(DriverCompletionInfo completionInfo, TimeValue took, Integer totalShards, Integer successfulShards, Integer skippedShards, Integer failedShards, List<ShardSearchFailure> failures) {
        this.completionInfo = completionInfo;
        this.took = took;
        this.totalShards = totalShards == null ? 0 : totalShards;
        this.successfulShards = successfulShards == null ? 0 : successfulShards;
        this.skippedShards = skippedShards == null ? 0 : skippedShards;
        this.failedShards = failedShards == null ? 0 : failedShards;
        this.failures = failures;
    }

    ComputeResponse(StreamInput in) throws IOException {
        this.completionInfo = ComputeResponse.supportsCompletionInfo(in.getTransportVersion()) ? DriverCompletionInfo.readFrom((StreamInput)in) : (in.readBoolean() ? new DriverCompletionInfo(0L, 0L, in.readCollectionAsImmutableList(DriverProfile::readFrom), List.of()) : DriverCompletionInfo.EMPTY);
        this.took = in.readOptionalTimeValue();
        this.totalShards = in.readVInt();
        this.successfulShards = in.readVInt();
        this.skippedShards = in.readVInt();
        this.failedShards = in.readVInt();
        this.failures = in.getTransportVersion().supports(ESQL_FAILURE_FROM_REMOTE) ? in.readCollectionAsImmutableList(ShardSearchFailure::readShardSearchFailure) : List.of();
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (ComputeResponse.supportsCompletionInfo(out.getTransportVersion())) {
            this.completionInfo.writeTo(out);
        } else {
            out.writeBoolean(true);
            out.writeCollection((Collection)this.completionInfo.driverProfiles());
        }
        out.writeOptionalTimeValue(this.took);
        out.writeVInt(this.totalShards);
        out.writeVInt(this.successfulShards);
        out.writeVInt(this.skippedShards);
        out.writeVInt(this.failedShards);
        if (out.getTransportVersion().supports(ESQL_FAILURE_FROM_REMOTE)) {
            out.writeCollection(this.failures, (o, v) -> v.writeTo(o));
        }
    }

    private static boolean supportsCompletionInfo(TransportVersion version) {
        return version.supports(ESQL_DOCUMENTS_FOUND_AND_VALUES_LOADED);
    }

    public DriverCompletionInfo getCompletionInfo() {
        return this.completionInfo;
    }

    public TimeValue getTook() {
        return this.took;
    }

    public int getTotalShards() {
        return this.totalShards;
    }

    public int getSuccessfulShards() {
        return this.successfulShards;
    }

    public int getSkippedShards() {
        return this.skippedShards;
    }

    public int getFailedShards() {
        return this.failedShards;
    }

    public List<ShardSearchFailure> getFailures() {
        return this.failures;
    }
}

