/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.planner.mapper;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorMode;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.expression.function.grouping.GroupingFunction;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.BinaryPlan;
import org.elasticsearch.xpack.esql.plan.logical.Enrich;
import org.elasticsearch.xpack.esql.plan.logical.EsRelation;
import org.elasticsearch.xpack.esql.plan.logical.Filter;
import org.elasticsearch.xpack.esql.plan.logical.Fork;
import org.elasticsearch.xpack.esql.plan.logical.LeafPlan;
import org.elasticsearch.xpack.esql.plan.logical.Limit;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.PipelineBreaker;
import org.elasticsearch.xpack.esql.plan.logical.TopN;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.esql.plan.logical.inference.Rerank;
import org.elasticsearch.xpack.esql.plan.logical.join.Join;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinConfig;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinTypes;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeExec;
import org.elasticsearch.xpack.esql.plan.physical.FragmentExec;
import org.elasticsearch.xpack.esql.plan.physical.HashJoinExec;
import org.elasticsearch.xpack.esql.plan.physical.LimitExec;
import org.elasticsearch.xpack.esql.plan.physical.LocalSourceExec;
import org.elasticsearch.xpack.esql.plan.physical.LookupJoinExec;
import org.elasticsearch.xpack.esql.plan.physical.MergeExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.TopNExec;
import org.elasticsearch.xpack.esql.plan.physical.inference.RerankExec;
import org.elasticsearch.xpack.esql.planner.mapper.MapperUtils;
import org.elasticsearch.xpack.esql.session.Versioned;

public class Mapper {
    public PhysicalPlan map(Versioned<LogicalPlan> versionedPlan) {
        return this.mapInner(versionedPlan.inner());
    }

    private PhysicalPlan mapInner(LogicalPlan p) {
        if (p instanceof LeafPlan) {
            LeafPlan leaf = (LeafPlan)p;
            return this.mapLeaf(leaf);
        }
        if (p instanceof UnaryPlan) {
            UnaryPlan unary = (UnaryPlan)p;
            return this.mapUnary(unary);
        }
        if (p instanceof BinaryPlan) {
            BinaryPlan binary = (BinaryPlan)p;
            return this.mapBinary(binary);
        }
        if (p instanceof Fork) {
            Fork fork = (Fork)p;
            return this.mapFork(fork);
        }
        return MapperUtils.unsupported(p);
    }

    private PhysicalPlan mapLeaf(LeafPlan leaf) {
        if (leaf instanceof EsRelation) {
            EsRelation esRelation = (EsRelation)leaf;
            return new FragmentExec(esRelation);
        }
        return MapperUtils.mapLeaf(leaf);
    }

    private PhysicalPlan mapUnary(UnaryPlan unary) {
        Limit limit;
        PhysicalPlan mappedChild = this.mapInner(unary.child());
        if (mappedChild instanceof FragmentExec) {
            TopN topN;
            Enrich enrich;
            if (unary instanceof Enrich && (enrich = (Enrich)unary).mode() == Enrich.Mode.COORDINATOR) {
                mappedChild = this.addExchangeForFragment(enrich.child(), mappedChild);
                return MapperUtils.mapUnary(unary, mappedChild);
            }
            if (!(unary instanceof PipelineBreaker) || unary instanceof Limit && (limit = (Limit)unary).local() || unary instanceof TopN && (topN = (TopN)unary).local()) {
                return new FragmentExec(unary);
            }
        }
        if (unary instanceof Aggregate) {
            Aggregate aggregate = (Aggregate)unary;
            List<Attribute> intermediate = MapperUtils.intermediateAttributes(aggregate);
            if ((mappedChild = this.addExchangeForFragment(aggregate, mappedChild)) instanceof ExchangeExec) {
                ExchangeExec exchange = (ExchangeExec)mappedChild;
                mappedChild = new ExchangeExec(mappedChild.source(), intermediate, true, exchange.child());
            } else {
                if (aggregate.groupings().stream().noneMatch(group -> group.anyMatch(expr -> expr instanceof GroupingFunction.NonEvaluatableGroupingFunction))) {
                    return MapperUtils.aggExec(aggregate, mappedChild, AggregatorMode.SINGLE, intermediate);
                }
                mappedChild = MapperUtils.aggExec(aggregate, mappedChild, AggregatorMode.INITIAL, intermediate);
            }
            return MapperUtils.aggExec(aggregate, mappedChild, AggregatorMode.FINAL, intermediate);
        }
        if (unary instanceof Limit) {
            limit = (Limit)unary;
            mappedChild = this.addExchangeForFragment(limit, mappedChild);
            return new LimitExec(limit.source(), mappedChild, limit.limit(), null);
        }
        if (unary instanceof TopN) {
            TopN topN = (TopN)unary;
            mappedChild = this.addExchangeForFragment(topN, mappedChild);
            return new TopNExec(topN.source(), mappedChild, topN.order(), topN.limit(), null);
        }
        if (unary instanceof Rerank) {
            Rerank rerank = (Rerank)unary;
            mappedChild = this.addExchangeForFragment(rerank, mappedChild);
            return new RerankExec(rerank.source(), mappedChild, rerank.inferenceId(), rerank.queryText(), rerank.rerankFields(), rerank.scoreAttribute());
        }
        return MapperUtils.mapUnary(unary, mappedChild);
    }

    private PhysicalPlan mapBinary(BinaryPlan bp) {
        if (bp instanceof Join) {
            FragmentExec fragment;
            boolean isIndexModeLookup;
            Join join = (Join)bp;
            JoinConfig config = join.config();
            if (config.type() != JoinTypes.LEFT) {
                throw new EsqlIllegalArgumentException("unsupported join type [" + String.valueOf(config.type()) + "]");
            }
            if (join.isRemote()) {
                return new FragmentExec(bp);
            }
            PhysicalPlan left = this.mapInner(bp.left());
            if (left instanceof FragmentExec) {
                return new FragmentExec(bp);
            }
            PhysicalPlan right = this.mapInner(bp.right());
            if (right instanceof LocalSourceExec) {
                LocalSourceExec localData = (LocalSourceExec)right;
                return new HashJoinExec(join.source(), left, localData, config.leftFields(), config.rightFields(), join.rightOutputFields());
            }
            if (right instanceof FragmentExec && (isIndexModeLookup = Mapper.isIndexModeLookup(fragment = (FragmentExec)right))) {
                return new LookupJoinExec(join.source(), left, right, config.leftFields(), config.rightFields(), join.rightOutputFields(), config.joinOnConditions());
            }
        }
        return MapperUtils.unsupported(bp);
    }

    private static boolean isIndexModeLookup(FragmentExec fragment) {
        Filter filter;
        LogicalPlan logicalPlan;
        EsRelation relation;
        LogicalPlan logicalPlan2 = fragment.fragment();
        boolean isIndexModeLookup = logicalPlan2 instanceof EsRelation && (relation = (EsRelation)logicalPlan2).indexMode() == IndexMode.LOOKUP;
        isIndexModeLookup = isIndexModeLookup || (logicalPlan = fragment.fragment()) instanceof Filter && (logicalPlan = (filter = (Filter)logicalPlan).child()) instanceof EsRelation && (relation = (EsRelation)logicalPlan).indexMode() == IndexMode.LOOKUP;
        return isIndexModeLookup;
    }

    private PhysicalPlan mapFork(Fork fork) {
        return new MergeExec(fork.source(), fork.children().stream().map(this::mapInner).toList(), fork.output());
    }

    private PhysicalPlan addExchangeForFragment(LogicalPlan logical, PhysicalPlan child) {
        if (child instanceof FragmentExec) {
            child = new FragmentExec(logical);
            child = new ExchangeExec(child.source(), child);
        }
        return child;
    }
}

