/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.planner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.compute.Describable;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.LocalCircuitBreaker;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.lucene.DataPartitioning;
import org.elasticsearch.compute.lucene.LuceneCountOperator;
import org.elasticsearch.compute.lucene.TimeSeriesSourceOperator;
import org.elasticsearch.compute.operator.ChangePointOperator;
import org.elasticsearch.compute.operator.ColumnExtractOperator;
import org.elasticsearch.compute.operator.ColumnLoadOperator;
import org.elasticsearch.compute.operator.Driver;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.FilterOperator;
import org.elasticsearch.compute.operator.LimitOperator;
import org.elasticsearch.compute.operator.LocalSourceOperator;
import org.elasticsearch.compute.operator.MvExpandOperator;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.compute.operator.OutputOperator;
import org.elasticsearch.compute.operator.ProjectOperator;
import org.elasticsearch.compute.operator.RowInTableLookupOperator;
import org.elasticsearch.compute.operator.SampleOperator;
import org.elasticsearch.compute.operator.ScoreOperator;
import org.elasticsearch.compute.operator.ShowOperator;
import org.elasticsearch.compute.operator.SinkOperator;
import org.elasticsearch.compute.operator.SourceOperator;
import org.elasticsearch.compute.operator.StringExtractOperator;
import org.elasticsearch.compute.operator.exchange.ExchangeSink;
import org.elasticsearch.compute.operator.exchange.ExchangeSinkOperator;
import org.elasticsearch.compute.operator.exchange.ExchangeSource;
import org.elasticsearch.compute.operator.exchange.ExchangeSourceOperator;
import org.elasticsearch.compute.operator.fuse.FuseConfig;
import org.elasticsearch.compute.operator.fuse.LinearConfig;
import org.elasticsearch.compute.operator.fuse.LinearScoreEvalOperator;
import org.elasticsearch.compute.operator.fuse.RrfConfig;
import org.elasticsearch.compute.operator.fuse.RrfScoreEvalOperator;
import org.elasticsearch.compute.operator.topn.TopNEncoder;
import org.elasticsearch.compute.operator.topn.TopNOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.node.Node;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.transport.RemoteClusterAware;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.action.ColumnInfoImpl;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.NameId;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.expression.TypedAttribute;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.enrich.EnrichLookupOperator;
import org.elasticsearch.xpack.esql.enrich.EnrichLookupService;
import org.elasticsearch.xpack.esql.enrich.LookupFromIndexOperator;
import org.elasticsearch.xpack.esql.enrich.LookupFromIndexService;
import org.elasticsearch.xpack.esql.enrich.MatchConfig;
import org.elasticsearch.xpack.esql.evaluator.EvalMapper;
import org.elasticsearch.xpack.esql.evaluator.command.GrokEvaluatorExtracter;
import org.elasticsearch.xpack.esql.expression.Foldables;
import org.elasticsearch.xpack.esql.expression.Order;
import org.elasticsearch.xpack.esql.inference.InferenceService;
import org.elasticsearch.xpack.esql.inference.XContentRowEncoder;
import org.elasticsearch.xpack.esql.inference.completion.CompletionOperator;
import org.elasticsearch.xpack.esql.inference.rerank.RerankOperator;
import org.elasticsearch.xpack.esql.plan.logical.EsRelation;
import org.elasticsearch.xpack.esql.plan.physical.AggregateExec;
import org.elasticsearch.xpack.esql.plan.physical.ChangePointExec;
import org.elasticsearch.xpack.esql.plan.physical.DissectExec;
import org.elasticsearch.xpack.esql.plan.physical.EnrichExec;
import org.elasticsearch.xpack.esql.plan.physical.EsQueryExec;
import org.elasticsearch.xpack.esql.plan.physical.EsStatsQueryExec;
import org.elasticsearch.xpack.esql.plan.physical.EvalExec;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeExec;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeSinkExec;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeSourceExec;
import org.elasticsearch.xpack.esql.plan.physical.FieldExtractExec;
import org.elasticsearch.xpack.esql.plan.physical.FilterExec;
import org.elasticsearch.xpack.esql.plan.physical.FragmentExec;
import org.elasticsearch.xpack.esql.plan.physical.FuseScoreEvalExec;
import org.elasticsearch.xpack.esql.plan.physical.GrokExec;
import org.elasticsearch.xpack.esql.plan.physical.HashJoinExec;
import org.elasticsearch.xpack.esql.plan.physical.LimitExec;
import org.elasticsearch.xpack.esql.plan.physical.LocalSourceExec;
import org.elasticsearch.xpack.esql.plan.physical.LookupJoinExec;
import org.elasticsearch.xpack.esql.plan.physical.MvExpandExec;
import org.elasticsearch.xpack.esql.plan.physical.OutputExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.ProjectExec;
import org.elasticsearch.xpack.esql.plan.physical.SampleExec;
import org.elasticsearch.xpack.esql.plan.physical.ShowExec;
import org.elasticsearch.xpack.esql.plan.physical.TimeSeriesAggregateExec;
import org.elasticsearch.xpack.esql.plan.physical.TopNExec;
import org.elasticsearch.xpack.esql.plan.physical.inference.CompletionExec;
import org.elasticsearch.xpack.esql.plan.physical.inference.RerankExec;
import org.elasticsearch.xpack.esql.planner.EsPhysicalOperationProviders;
import org.elasticsearch.xpack.esql.planner.ExchangeLayout;
import org.elasticsearch.xpack.esql.planner.Layout;
import org.elasticsearch.xpack.esql.planner.PhysicalOperationProviders;
import org.elasticsearch.xpack.esql.planner.PlannerSettings;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;
import org.elasticsearch.xpack.esql.plugin.QueryPragmas;
import org.elasticsearch.xpack.esql.score.ScoreMapper;
import org.elasticsearch.xpack.esql.session.Configuration;
import org.elasticsearch.xpack.esql.session.EsqlCCSUtils;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public class LocalExecutionPlanner {
    private static final Logger logger = LogManager.getLogger(LocalExecutionPlanner.class);
    private final String sessionId;
    private final String clusterAlias;
    private final CancellableTask parentTask;
    private final BigArrays bigArrays;
    private final BlockFactory blockFactory;
    private final Settings settings;
    private final Configuration configuration;
    private final Supplier<ExchangeSource> exchangeSourceSupplier;
    private final Supplier<ExchangeSink> exchangeSinkSupplier;
    private final EnrichLookupService enrichLookupService;
    private final LookupFromIndexService lookupFromIndexService;
    private final InferenceService inferenceService;
    private final PhysicalOperationProviders physicalOperationProviders;
    private final List<EsPhysicalOperationProviders.ShardContext> shardContexts;

    public LocalExecutionPlanner(String sessionId, String clusterAlias, CancellableTask parentTask, BigArrays bigArrays, BlockFactory blockFactory, Settings settings, Configuration configuration, Supplier<ExchangeSource> exchangeSourceSupplier, Supplier<ExchangeSink> exchangeSinkSupplier, EnrichLookupService enrichLookupService, LookupFromIndexService lookupFromIndexService, InferenceService inferenceService, PhysicalOperationProviders physicalOperationProviders, List<EsPhysicalOperationProviders.ShardContext> shardContexts) {
        this.sessionId = sessionId;
        this.clusterAlias = clusterAlias;
        this.parentTask = parentTask;
        this.bigArrays = bigArrays;
        this.blockFactory = blockFactory;
        this.settings = settings;
        this.configuration = configuration;
        this.exchangeSourceSupplier = exchangeSourceSupplier;
        this.exchangeSinkSupplier = exchangeSinkSupplier;
        this.enrichLookupService = enrichLookupService;
        this.lookupFromIndexService = lookupFromIndexService;
        this.inferenceService = inferenceService;
        this.physicalOperationProviders = physicalOperationProviders;
        this.shardContexts = shardContexts;
    }

    public LocalExecutionPlan plan(String description, FoldContext foldCtx, PlannerSettings plannerSettings, PhysicalPlan localPhysicalPlan) {
        boolean timeSeries = localPhysicalPlan.anyMatch(p -> p instanceof TimeSeriesAggregateExec);
        LocalExecutionPlannerContext context = new LocalExecutionPlannerContext(description, new ArrayList<DriverFactory>(), (Holder<DriverParallelism>)new Holder((Object)DriverParallelism.SINGLE), this.configuration.pragmas(), this.bigArrays, this.blockFactory, foldCtx, plannerSettings, timeSeries, this.shardContexts);
        localPhysicalPlan = (PhysicalPlan)localPhysicalPlan.transformUp(AggregateExec.class, a -> a.getMode().isOutputPartial() ? a : new ProjectExec(a.source(), (PhysicalPlan)((Object)a), Expressions.asAttributes(a.aggregates())));
        PhysicalOperation physicalOperation = this.plan(localPhysicalPlan, context);
        TimeValue statusInterval = this.configuration.pragmas().statusInterval();
        context.addDriverFactory(new DriverFactory(new DriverSupplier(description, ((ClusterName)ClusterName.CLUSTER_NAME_SETTING.get(this.settings)).value(), (String)Node.NODE_NAME_SETTING.get(this.settings), context.bigArrays, context.blockFactory, physicalOperation, statusInterval, this.settings), (DriverParallelism)context.driverParallelism().get()));
        return new LocalExecutionPlan(context.driverFactories);
    }

    private PhysicalOperation plan(PhysicalPlan node, LocalExecutionPlannerContext context) {
        if (node instanceof AggregateExec) {
            AggregateExec aggregate = (AggregateExec)node;
            return this.planAggregation(aggregate, context);
        }
        if (node instanceof FieldExtractExec) {
            FieldExtractExec fieldExtractExec = (FieldExtractExec)node;
            return this.planFieldExtractNode(fieldExtractExec, context);
        }
        if (node instanceof ExchangeExec) {
            ExchangeExec exchangeExec = (ExchangeExec)node;
            return this.planExchange(exchangeExec, context);
        }
        if (node instanceof TopNExec) {
            TopNExec topNExec = (TopNExec)node;
            return this.planTopN(topNExec, context);
        }
        if (node instanceof EvalExec) {
            EvalExec eval = (EvalExec)node;
            return this.planEval(eval, context);
        }
        if (node instanceof DissectExec) {
            DissectExec dissect = (DissectExec)node;
            return this.planDissect(dissect, context);
        }
        if (node instanceof GrokExec) {
            GrokExec grok = (GrokExec)node;
            return this.planGrok(grok, context);
        }
        if (node instanceof ProjectExec) {
            ProjectExec project = (ProjectExec)node;
            return this.planProject(project, context);
        }
        if (node instanceof FilterExec) {
            FilterExec filter = (FilterExec)node;
            return this.planFilter(filter, context);
        }
        if (node instanceof LimitExec) {
            LimitExec limit = (LimitExec)node;
            return this.planLimit(limit, context);
        }
        if (node instanceof MvExpandExec) {
            MvExpandExec mvExpand = (MvExpandExec)node;
            return this.planMvExpand(mvExpand, context);
        }
        if (node instanceof RerankExec) {
            RerankExec rerank = (RerankExec)node;
            return this.planRerank(rerank, context);
        }
        if (node instanceof ChangePointExec) {
            ChangePointExec changePoint = (ChangePointExec)node;
            return this.planChangePoint(changePoint, context);
        }
        if (node instanceof CompletionExec) {
            CompletionExec completion = (CompletionExec)node;
            return this.planCompletion(completion, context);
        }
        if (node instanceof SampleExec) {
            SampleExec Sample2 = (SampleExec)node;
            return this.planSample(Sample2, context);
        }
        if (node instanceof EsQueryExec) {
            EsQueryExec esQuery = (EsQueryExec)node;
            return this.planEsQueryNode(esQuery, context);
        }
        if (node instanceof EsStatsQueryExec) {
            EsStatsQueryExec statsQuery = (EsStatsQueryExec)node;
            return this.planEsStats(statsQuery, context);
        }
        if (node instanceof LocalSourceExec) {
            LocalSourceExec localSource = (LocalSourceExec)node;
            return this.planLocal(localSource, context);
        }
        if (node instanceof ShowExec) {
            ShowExec show = (ShowExec)node;
            return this.planShow(show);
        }
        if (node instanceof ExchangeSourceExec) {
            ExchangeSourceExec exchangeSource = (ExchangeSourceExec)node;
            return this.planExchangeSource(exchangeSource, this.exchangeSourceSupplier);
        }
        if (node instanceof EnrichExec) {
            EnrichExec enrich = (EnrichExec)node;
            return this.planEnrich(enrich, context);
        }
        if (node instanceof HashJoinExec) {
            HashJoinExec join = (HashJoinExec)node;
            return this.planHashJoin(join, context);
        }
        if (node instanceof LookupJoinExec) {
            LookupJoinExec join = (LookupJoinExec)node;
            return this.planLookupJoin(join, context);
        }
        if (node instanceof OutputExec) {
            OutputExec outputExec = (OutputExec)node;
            return this.planOutput(outputExec, context);
        }
        if (node instanceof ExchangeSinkExec) {
            ExchangeSinkExec exchangeSink = (ExchangeSinkExec)node;
            return this.planExchangeSink(exchangeSink, context);
        }
        if (node instanceof FuseScoreEvalExec) {
            FuseScoreEvalExec fuse = (FuseScoreEvalExec)node;
            return this.planFuseScoreEvalExec(fuse, context);
        }
        throw new EsqlIllegalArgumentException("unknown physical plan node [" + node.nodeName() + "]");
    }

    private PhysicalOperation planCompletion(CompletionExec completion, LocalExecutionPlannerContext context) {
        PhysicalOperation source = this.plan(completion.child(), context);
        String inferenceId = BytesRefs.toString((Object)completion.inferenceId().fold(context.foldCtx()));
        Layout outputLayout = source.layout.builder().append((NamedExpression)completion.targetField()).build();
        EvalOperator.ExpressionEvaluator.Factory promptEvaluatorFactory = EvalMapper.toEvaluator(context.foldCtx(), completion.prompt(), source.layout);
        return source.with(new CompletionOperator.Factory(this.inferenceService, inferenceId, promptEvaluatorFactory), outputLayout);
    }

    private PhysicalOperation planFuseScoreEvalExec(FuseScoreEvalExec fuse, LocalExecutionPlannerContext context) {
        PhysicalOperation source = this.plan(fuse.child(), context);
        Layout layout = source.layout;
        int scorePosition = layout.get(fuse.score().id()).channel();
        int discriminatorPosition = layout.get(fuse.discriminator().id()).channel();
        FuseConfig fuseConfig = fuse.fuseConfig();
        if (fuseConfig instanceof RrfConfig) {
            RrfConfig rrfConfig = (RrfConfig)fuseConfig;
            return source.with((Operator.OperatorFactory)new RrfScoreEvalOperator.Factory(discriminatorPosition, scorePosition, rrfConfig, fuse.sourceText(), fuse.sourceLocation().getLineNumber(), fuse.sourceLocation().getColumnNumber()), source.layout);
        }
        fuseConfig = fuse.fuseConfig();
        if (fuseConfig instanceof LinearConfig) {
            LinearConfig linearConfig = (LinearConfig)fuseConfig;
            return source.with((Operator.OperatorFactory)new LinearScoreEvalOperator.Factory(discriminatorPosition, scorePosition, linearConfig, fuse.sourceText(), fuse.sourceLocation().getLineNumber(), fuse.sourceLocation().getColumnNumber()), source.layout);
        }
        throw new EsqlIllegalArgumentException("unknown FUSE score method [" + String.valueOf(fuse.fuseConfig()) + "]");
    }

    private PhysicalOperation planAggregation(AggregateExec aggregate, LocalExecutionPlannerContext context) {
        PhysicalOperation source = this.plan(aggregate.child(), context);
        return this.physicalOperationProviders.groupingPhysicalOperation(aggregate, source, context);
    }

    private PhysicalOperation planEsQueryNode(EsQueryExec esQueryExec, LocalExecutionPlannerContext context) {
        return this.physicalOperationProviders.sourcePhysicalOperation(esQueryExec, context);
    }

    private PhysicalOperation planEsStats(EsStatsQueryExec statsQuery, LocalExecutionPlannerContext context) {
        if (!(this.physicalOperationProviders instanceof EsPhysicalOperationProviders)) {
            throw new EsqlIllegalArgumentException("EsStatsQuery should only occur against a Lucene backend");
        }
        if (statsQuery.stats().size() > 1) {
            throw new EsqlIllegalArgumentException("EsStatsQuery currently supports only one field statistic");
        }
        EsStatsQueryExec.Stat stat = statsQuery.stats().get(0);
        EsPhysicalOperationProviders esProvider = (EsPhysicalOperationProviders)this.physicalOperationProviders;
        LuceneCountOperator.Factory luceneFactory = esProvider.countSource(context, stat.filter(statsQuery.query()), statsQuery.limit());
        Layout.Builder layout = new Layout.Builder();
        layout.append((Collection<? extends NamedExpression>)statsQuery.outputSet());
        int instanceCount = Math.max(1, luceneFactory.taskConcurrency());
        context.driverParallelism(new DriverParallelism(DriverParallelism.Type.DATA_PARALLELISM, instanceCount));
        return PhysicalOperation.fromSource((SourceOperator.SourceOperatorFactory)luceneFactory, layout.build());
    }

    private PhysicalOperation planFieldExtractNode(FieldExtractExec fieldExtractExec, LocalExecutionPlannerContext context) {
        return this.physicalOperationProviders.fieldExtractPhysicalOperation(fieldExtractExec, this.plan(fieldExtractExec.child(), context));
    }

    private PhysicalOperation planOutput(OutputExec outputExec, LocalExecutionPlannerContext context) {
        PhysicalOperation source = this.plan(outputExec.child(), context);
        List<Attribute> output = outputExec.output();
        return source.withSink((SinkOperator.SinkOperatorFactory)new OutputOperator.OutputOperatorFactory(Expressions.names(output), LocalExecutionPlanner.alignPageToAttributes(output, source.layout), outputExec.getPageConsumer()), source.layout);
    }

    private static Function<Page, Page> alignPageToAttributes(List<Attribute> attrs, Layout layout) {
        int[] mappedPosition = new int[attrs.size()];
        int index = -1;
        boolean transformRequired = false;
        for (Attribute attribute : attrs) {
            mappedPosition[++index] = layout.get(attribute.id()).channel();
            transformRequired |= mappedPosition[index] != index;
        }
        Function<Page, Page> transformer = transformRequired ? p -> {
            Block[] blocks = new Block[mappedPosition.length];
            for (int i = 0; i < blocks.length; ++i) {
                blocks[i] = p.getBlock(mappedPosition[i]);
                blocks[i].incRef();
            }
            p.releaseBlocks();
            return new Page(blocks);
        } : Function.identity();
        return transformer;
    }

    private PhysicalOperation planExchange(ExchangeExec exchangeExec, LocalExecutionPlannerContext context) {
        throw new UnsupportedOperationException("Exchange needs to be replaced with a sink/source");
    }

    private PhysicalOperation planExchangeSink(ExchangeSinkExec exchangeSink, LocalExecutionPlannerContext context) {
        Objects.requireNonNull(this.exchangeSinkSupplier, "ExchangeSinkHandler wasn't provided");
        PhysicalPlan child = exchangeSink.child();
        PhysicalOperation source = this.plan(child, context);
        return source.withSink((SinkOperator.SinkOperatorFactory)new ExchangeSinkOperator.ExchangeSinkOperatorFactory(this.exchangeSinkSupplier), source.layout);
    }

    private PhysicalOperation planExchangeSource(ExchangeSourceExec exchangeSource, Supplier<ExchangeSource> exchangeSourceSupplier) {
        Objects.requireNonNull(exchangeSourceSupplier, "ExchangeSourceHandler wasn't provided");
        Layout.Builder builder = new Layout.Builder();
        builder.append(exchangeSource.output());
        Layout l = builder.build();
        Layout layout = exchangeSource.isIntermediateAgg() ? new ExchangeLayout(l) : l;
        return PhysicalOperation.fromSource((SourceOperator.SourceOperatorFactory)new ExchangeSourceOperator.ExchangeSourceOperatorFactory(exchangeSourceSupplier), layout);
    }

    private PhysicalOperation planTopN(TopNExec topNExec, LocalExecutionPlannerContext context) {
        Object object;
        Integer rowSize = topNExec.estimatedRowSize();
        assert (rowSize != null && rowSize > 0) : "estimated row size [" + rowSize + "] wasn't set";
        PhysicalOperation source = this.plan(topNExec.child(), context);
        ElementType[] elementTypes = new ElementType[source.layout.numberOfChannels()];
        TopNEncoder[] encoders = new TopNEncoder[source.layout.numberOfChannels()];
        List<Layout.ChannelSet> inverse = source.layout.inverse();
        for (int channel = 0; channel < inverse.size(); ++channel) {
            elementTypes[channel] = PlannerUtils.toElementType(inverse.get(channel).type());
            encoders[channel] = switch (inverse.get(channel).type()) {
                default -> throw new MatchException(null, null);
                case DataType.IP -> TopNEncoder.IP;
                case DataType.TEXT, DataType.KEYWORD -> TopNEncoder.UTF8;
                case DataType.VERSION -> TopNEncoder.VERSION;
                case DataType.BOOLEAN, DataType.NULL, DataType.BYTE, DataType.SHORT, DataType.INTEGER, DataType.LONG, DataType.DOUBLE, DataType.FLOAT, DataType.HALF_FLOAT, DataType.DATETIME, DataType.DATE_NANOS, DataType.DATE_PERIOD, DataType.TIME_DURATION, DataType.OBJECT, DataType.SCALED_FLOAT, DataType.UNSIGNED_LONG, DataType.DOC_DATA_TYPE, DataType.TSID_DATA_TYPE -> TopNEncoder.DEFAULT_SORTABLE;
                case DataType.GEO_POINT, DataType.CARTESIAN_POINT, DataType.GEO_SHAPE, DataType.CARTESIAN_SHAPE, DataType.COUNTER_LONG, DataType.COUNTER_INTEGER, DataType.COUNTER_DOUBLE, DataType.SOURCE, DataType.AGGREGATE_METRIC_DOUBLE, DataType.DENSE_VECTOR, DataType.GEOHASH, DataType.GEOTILE, DataType.GEOHEX -> TopNEncoder.DEFAULT_UNSORTABLE;
                case DataType.PARTIAL_AGG, DataType.UNSUPPORTED -> TopNEncoder.UNSUPPORTED;
            };
        }
        List<TopNOperator.SortOrder> orders = topNExec.order().stream().map(order -> {
            Expression patt0$temp = order.child();
            if (!(patt0$temp instanceof Attribute)) {
                throw new EsqlIllegalArgumentException("order by expression must be an attribute");
            }
            Attribute a = (Attribute)patt0$temp;
            int sortByChannel = source.layout.get(a.id()).channel();
            return new TopNOperator.SortOrder(sortByChannel, order.direction().equals((Object)Order.OrderDirection.ASC), order.nullsPosition().equals((Object)Order.NullsPosition.FIRST));
        }).toList();
        Expression expression = topNExec.limit();
        if (expression instanceof Literal) {
            Literal literal = (Literal)expression;
            Object object2 = literal.value();
            if (object2 instanceof BytesRef) {
                BytesRef br = (BytesRef)object2;
                object = BytesRefs.toString((Object)br);
            } else {
                object = literal.value();
            }
        } else {
            throw new EsqlIllegalArgumentException("limit only supported with literal values");
        }
        Object val = object;
        int limit = EsqlDataTypeConverter.stringToInt(val.toString());
        return source.with((Operator.OperatorFactory)new TopNOperator.TopNOperatorFactory(limit, Arrays.asList(elementTypes), Arrays.asList(encoders), orders, context.pageSize(topNExec, rowSize)), source.layout);
    }

    private PhysicalOperation planEval(EvalExec eval, LocalExecutionPlannerContext context) {
        PhysicalOperation source = this.plan(eval.child(), context);
        for (Alias field : eval.fields()) {
            EvalOperator.ExpressionEvaluator.Factory evaluatorSupplier = EvalMapper.toEvaluator(context.foldCtx(), field.child(), source.layout, context.shardContexts);
            Layout.Builder layout = source.layout.builder();
            layout.append((NamedExpression)field.toAttribute());
            source = source.with((Operator.OperatorFactory)new EvalOperator.EvalOperatorFactory(evaluatorSupplier), layout.build());
        }
        return source;
    }

    private PhysicalOperation planDissect(DissectExec dissect, LocalExecutionPlannerContext context) {
        PhysicalOperation source = this.plan(dissect.child(), context);
        Layout.Builder layoutBuilder = source.layout.builder();
        layoutBuilder.append(dissect.extractedFields());
        Expression expr = dissect.inputExpression();
        String[] patternNames = Expressions.names(dissect.parser().keyAttributes(Source.EMPTY)).toArray(new String[0]);
        Layout layout = layoutBuilder.build();
        source = source.with((Operator.OperatorFactory)new StringExtractOperator.StringExtractOperatorFactory(patternNames, EvalMapper.toEvaluator(context.foldCtx(), expr, layout), () -> input -> dissect.parser().parser().parse(input)), layout);
        return source;
    }

    private PhysicalOperation planGrok(GrokExec grok, LocalExecutionPlannerContext context) {
        PhysicalOperation source = this.plan(grok.child(), context);
        Layout.Builder layoutBuilder = source.layout.builder();
        List<Attribute> extractedFields = grok.extractedFields();
        layoutBuilder.append(extractedFields);
        Map fieldToPos = Maps.newHashMapWithExpectedSize((int)extractedFields.size());
        Map fieldToType = Maps.newHashMapWithExpectedSize((int)extractedFields.size());
        ElementType[] types = new ElementType[extractedFields.size()];
        List<Attribute> extractedFieldsFromPattern = grok.pattern().extractedFields();
        for (int i = 0; i < extractedFields.size(); ++i) {
            DataType extractedFieldType = extractedFields.get(i).dataType();
            String patternName = extractedFieldsFromPattern.get(i).name();
            ElementType type = PlannerUtils.toElementType(extractedFieldType);
            fieldToPos.put(patternName, i);
            fieldToType.put(patternName, type);
            types[i] = type;
        }
        Layout layout = layoutBuilder.build();
        source = source.with((Operator.OperatorFactory)new ColumnExtractOperator.Factory(types, EvalMapper.toEvaluator(context.foldCtx(), grok.inputExpression(), layout), () -> new GrokEvaluatorExtracter(grok.pattern().grok(), grok.pattern().pattern(), fieldToPos, fieldToType)), layout);
        return source;
    }

    private PhysicalOperation planEnrich(EnrichExec enrich, LocalExecutionPlannerContext context) {
        PhysicalOperation source = this.plan(enrich.child(), context);
        Layout.Builder layoutBuilder = source.layout.builder();
        layoutBuilder.append(enrich.enrichFields());
        Layout layout = layoutBuilder.build();
        String enrichIndex = enrich.concreteIndices().get(this.clusterAlias);
        if (enrichIndex == null) {
            throw new EsqlIllegalArgumentException("No concrete enrich index for cluster [" + this.clusterAlias + "]");
        }
        Layout.ChannelAndType input = source.layout.get(enrich.matchField().id());
        return source.with(new EnrichLookupOperator.Factory(this.sessionId, this.parentTask, context.queryPragmas().enrichMaxWorkers(), input.channel(), this.enrichLookupService, input.type(), enrichIndex, enrich.matchType(), enrich.policyMatchField(), enrich.enrichFields(), enrich.source()), layout);
    }

    private PhysicalOperation planRerank(RerankExec rerank, LocalExecutionPlannerContext context) {
        EvalOperator.ExpressionEvaluator.Factory rowEncoderFactory;
        PhysicalOperation source = this.plan(rerank.child(), context);
        if (rerank.rerankFields().size() > 1) {
            LinkedHashMap rerankFieldsEvaluatorSuppliers = Maps.newLinkedHashMapWithExpectedSize((int)rerank.rerankFields().size());
            for (Alias rerankField : rerank.rerankFields()) {
                rerankFieldsEvaluatorSuppliers.put(new ColumnInfoImpl(rerankField.name(), rerankField.dataType(), null), EvalMapper.toEvaluator(context.foldCtx(), rerankField.child(), source.layout));
            }
            rowEncoderFactory = XContentRowEncoder.yamlRowEncoderFactory(rerankFieldsEvaluatorSuppliers);
        } else {
            rowEncoderFactory = EvalMapper.toEvaluator(context.foldCtx(), rerank.rerankFields().get(0).child(), source.layout);
        }
        String inferenceId = BytesRefs.toString((Object)rerank.inferenceId().fold(context.foldCtx));
        String queryText = BytesRefs.toString((Object)rerank.queryText().fold(context.foldCtx));
        Layout outputLayout = source.layout;
        if (source.layout.get(rerank.scoreAttribute().id()) == null) {
            outputLayout = source.layout.builder().append((NamedExpression)rerank.scoreAttribute()).build();
        }
        int scoreChannel = outputLayout.get(rerank.scoreAttribute().id()).channel();
        return source.with(new RerankOperator.Factory(this.inferenceService, inferenceId, queryText, rowEncoderFactory, scoreChannel), outputLayout);
    }

    private PhysicalOperation planHashJoin(HashJoinExec join, LocalExecutionPlannerContext context) {
        Block localField;
        PhysicalOperation source = this.plan(join.left(), context);
        int positionsChannel = source.layout.numberOfChannels();
        Layout.Builder layoutBuilder = source.layout.builder();
        for (Attribute f : join.output()) {
            if (join.left().outputSet().contains((Object)f)) continue;
            layoutBuilder.append((NamedExpression)f);
        }
        Layout layout = layoutBuilder.build();
        LocalSourceExec localSourceExec = (LocalSourceExec)join.joinData();
        Block[] localData = (Block[])localSourceExec.supplier().get();
        RowInTableLookupOperator.Key[] keys = new RowInTableLookupOperator.Key[join.leftFields().size()];
        int[] blockMapping = new int[join.leftFields().size()];
        for (int k = 0; k < join.leftFields().size(); ++k) {
            Attribute left = join.leftFields().get(k);
            Attribute right = join.rightFields().get(k);
            localField = null;
            List<Attribute> output = join.joinData().output();
            for (int l = 0; l < output.size(); ++l) {
                if (!output.get(l).name().equals(right.name())) continue;
                localField = localData[l];
            }
            if (localField == null) {
                throw new IllegalArgumentException("can't find local data for [" + String.valueOf(right) + "]");
            }
            keys[k] = new RowInTableLookupOperator.Key(left.name(), localField);
            Layout.ChannelAndType input = source.layout.get(left.id());
            blockMapping[k] = input.channel();
        }
        source = source.with((Operator.OperatorFactory)new RowInTableLookupOperator.Factory(keys, blockMapping), layout);
        List<Attribute> joinDataOutput = join.joinData().output();
        for (Attribute f : join.addedFields()) {
            localField = null;
            for (int l = 0; l < joinDataOutput.size(); ++l) {
                if (!joinDataOutput.get(l).name().equals(f.name())) continue;
                localField = localData[l];
            }
            if (localField == null) {
                throw new IllegalArgumentException("can't find local data for [" + String.valueOf(f) + "]");
            }
            source = source.with((Operator.OperatorFactory)new ColumnLoadOperator.Factory(new ColumnLoadOperator.Values(f.name(), localField), positionsChannel), layout);
        }
        ArrayList projection = new ArrayList();
        IntStream.range(0, positionsChannel).boxed().forEach(projection::add);
        IntStream.range(positionsChannel + 1, positionsChannel + 1 + join.addedFields().size()).boxed().forEach(projection::add);
        return source.with((Operator.OperatorFactory)new ProjectOperator.ProjectOperatorFactory(projection), layout);
    }

    private PhysicalOperation planLookupJoin(LookupJoinExec join, LocalExecutionPlannerContext context) {
        Map.Entry entry;
        PhysicalOperation source = this.plan(join.left(), context);
        Layout.Builder layoutBuilder = source.layout.builder();
        for (Attribute f2 : join.addedFields()) {
            layoutBuilder.append((NamedExpression)f2);
        }
        Layout layout = layoutBuilder.build();
        EsRelation esRelation = LocalExecutionPlanner.findEsRelation(join.lookup());
        if (esRelation == null || esRelation.indexMode() != IndexMode.LOOKUP) {
            throw new IllegalArgumentException("can't plan [" + String.valueOf(join) + "]");
        }
        if (esRelation.indexNameWithModes().size() == 1) {
            entry = esRelation.indexNameWithModes().entrySet().iterator().next();
        } else {
            Optional<Map.Entry> maybeEntry = esRelation.indexNameWithModes().entrySet().stream().filter(e -> RemoteClusterAware.parseClusterAlias((String)((String)e.getKey())).equals(this.clusterAlias)).findFirst();
            entry = maybeEntry.orElseThrow(() -> new IllegalStateException("can't plan [" + String.valueOf(join) + "]: no matching index found " + EsqlCCSUtils.inClusterName(this.clusterAlias)));
        }
        if (entry.getValue() != IndexMode.LOOKUP) {
            throw new IllegalStateException("can't plan [" + String.valueOf(join) + "], found index with mode [" + String.valueOf(entry.getValue()) + "]");
        }
        String[] indexSplit = RemoteClusterAware.splitIndexName((String)entry.getKey());
        if (indexSplit[0] != null && !this.clusterAlias.equals(indexSplit[0])) {
            throw new IllegalStateException("can't plan [" + String.valueOf(join) + "]: no matching index found " + EsqlCCSUtils.inClusterName(this.clusterAlias));
        }
        String indexName = indexSplit[1];
        if (join.leftFields().size() != join.rightFields().size()) {
            throw new IllegalArgumentException("can't plan [" + String.valueOf(join) + "]: mismatching left and right field count");
        }
        ArrayList<MatchConfig> matchFields = new ArrayList<MatchConfig>(join.leftFields().size());
        for (int i = 0; i < join.leftFields().size(); ++i) {
            TypedAttribute left = (TypedAttribute)join.leftFields().get(i);
            FieldAttribute right = (FieldAttribute)join.rightFields().get(i);
            Layout.ChannelAndType input = source.layout.get(left.id());
            if (input == null) {
                throw new IllegalArgumentException("can't plan [" + String.valueOf(join) + "][" + String.valueOf(left) + "]");
            }
            String fieldName = right.exactAttribute().fieldName().string();
            if (join.isOnJoinExpression()) {
                fieldName = left.name();
            }
            matchFields.add(new MatchConfig(fieldName, input));
        }
        return source.with(new LookupFromIndexOperator.Factory(matchFields, this.sessionId, this.parentTask, context.queryPragmas().enrichMaxWorkers(), ctx -> this.lookupFromIndexService, esRelation.indexPattern(), indexName, join.addedFields().stream().map(f -> f).toList(), join.source(), join.right(), join.joinOnConditions()), layout);
    }

    private static EsRelation findEsRelation(PhysicalPlan node) {
        FragmentExec fragmentExec;
        List esRelations;
        if (node instanceof FragmentExec && (esRelations = (fragmentExec = (FragmentExec)node).fragment().collectFirstChildren(x -> x instanceof EsRelation)).size() == 1) {
            return (EsRelation)((Object)esRelations.get(0));
        }
        return null;
    }

    private PhysicalOperation planLocal(LocalSourceExec localSourceExec, LocalExecutionPlannerContext context) {
        Layout.Builder layout = new Layout.Builder();
        layout.append(localSourceExec.output());
        LocalSourceOperator.BlockSupplier supplier = () -> (Block[])localSourceExec.supplier().get();
        LocalSourceOperator operator = new LocalSourceOperator(supplier);
        return PhysicalOperation.fromSource((SourceOperator.SourceOperatorFactory)new LocalSourceOperator.LocalSourceFactory(() -> operator), layout.build());
    }

    private PhysicalOperation planShow(ShowExec showExec) {
        Layout.Builder layout = new Layout.Builder();
        layout.append(showExec.output());
        return PhysicalOperation.fromSource((SourceOperator.SourceOperatorFactory)new ShowOperator.ShowOperatorFactory(showExec.values()), layout.build());
    }

    private PhysicalOperation planProject(ProjectExec project, LocalExecutionPlannerContext context) {
        PhysicalOperation source = this.plan(project.child(), context);
        List<? extends NamedExpression> projections = project.projections();
        ArrayList<Integer> projectionList = new ArrayList<Integer>(projections.size());
        Layout.Builder layout = new Layout.Builder();
        for (NamedExpression namedExpression : projections) {
            NameId nameId;
            if (namedExpression instanceof Alias) {
                Alias a = (Alias)namedExpression;
                nameId = ((NamedExpression)a.child()).id();
            } else {
                nameId = namedExpression.id();
            }
            NameId inputId = nameId;
            Layout.ChannelAndType input = source.layout.get(inputId);
            if (input == null) {
                throw new IllegalStateException("can't find input for [" + String.valueOf(namedExpression) + "]");
            }
            layout.append(namedExpression);
            projectionList.add(input.channel());
        }
        return source.with((Operator.OperatorFactory)new ProjectOperator.ProjectOperatorFactory(projectionList), layout.build());
    }

    private PhysicalOperation planFilter(FilterExec filter, LocalExecutionPlannerContext context) {
        PhysicalOperation source = this.plan(filter.child(), context);
        PhysicalOperation filterOperation = source.with((Operator.OperatorFactory)new FilterOperator.FilterOperatorFactory(EvalMapper.toEvaluator(context.foldCtx(), filter.condition(), source.layout, this.shardContexts)), source.layout);
        if (PlannerUtils.usesScoring(filter)) {
            int scoreBlock = 0;
            for (Attribute attribute : filter.output()) {
                if ("_score".equals(attribute.name())) break;
                ++scoreBlock;
            }
            if (scoreBlock == filter.output().size()) {
                throw new IllegalStateException("Couldn't find _score attribute in a WHERE clause");
            }
            filterOperation = filterOperation.with((Operator.OperatorFactory)new ScoreOperator.ScoreOperatorFactory(ScoreMapper.toScorer(filter.condition(), this.shardContexts), scoreBlock), filterOperation.layout);
        }
        return filterOperation;
    }

    private PhysicalOperation planLimit(LimitExec limit, LocalExecutionPlannerContext context) {
        PhysicalOperation source = this.plan(limit.child(), context);
        return source.with((Operator.OperatorFactory)new LimitOperator.Factory(((Integer)limit.limit().fold(context.foldCtx)).intValue()), source.layout);
    }

    private PhysicalOperation planMvExpand(MvExpandExec mvExpandExec, LocalExecutionPlannerContext context) {
        PhysicalOperation source = this.plan(mvExpandExec.child(), context);
        int blockSize = 5000;
        Layout.Builder layout = source.layout.builder();
        layout.replace(mvExpandExec.target().id(), mvExpandExec.expanded().id());
        return source.with((Operator.OperatorFactory)new MvExpandOperator.Factory(source.layout.get(mvExpandExec.target().id()).channel(), blockSize), layout.build());
    }

    private PhysicalOperation planChangePoint(ChangePointExec changePoint, LocalExecutionPlannerContext context) {
        PhysicalOperation source = this.plan(changePoint.child(), context);
        Layout layout = source.layout.builder().append((NamedExpression)changePoint.targetType()).append((NamedExpression)changePoint.targetPvalue()).build();
        return source.with((Operator.OperatorFactory)new ChangePointOperator.Factory(layout.get(changePoint.value().id()).channel(), changePoint.sourceText(), changePoint.sourceLocation().getLineNumber(), changePoint.sourceLocation().getColumnNumber()), layout);
    }

    private PhysicalOperation planSample(SampleExec rsx, LocalExecutionPlannerContext context) {
        PhysicalOperation source = this.plan(rsx.child(), context);
        double probability = (Double)Foldables.valueOf(context.foldCtx(), rsx.probability());
        return source.with((Operator.OperatorFactory)new SampleOperator.Factory(probability), source.layout);
    }

    public record LocalExecutionPlannerContext(String description, List<DriverFactory> driverFactories, Holder<DriverParallelism> driverParallelism, QueryPragmas queryPragmas, BigArrays bigArrays, BlockFactory blockFactory, FoldContext foldCtx, PlannerSettings plannerSettings, boolean timeSeries, List<EsPhysicalOperationProviders.ShardContext> shardContexts) {
        void addDriverFactory(DriverFactory driverFactory) {
            this.driverFactories.add(driverFactory);
        }

        void driverParallelism(DriverParallelism parallelism) {
            this.driverParallelism.set((Object)parallelism);
        }

        DataPartitioning.AutoStrategy autoPartitioningStrategy() {
            return this.timeSeries ? DataPartitioning.AutoStrategy.DEFAULT_TIME_SERIES : DataPartitioning.AutoStrategy.DEFAULT;
        }

        int pageSize(PhysicalPlan node, Integer estimatedRowSize) {
            if (estimatedRowSize == null) {
                throw new IllegalStateException("estimated row size hasn't been set");
            }
            if (estimatedRowSize == 0) {
                throw new IllegalStateException("estimated row size can't be 0");
            }
            if (this.queryPragmas.pageSize() != 0) {
                return this.queryPragmas.pageSize();
            }
            if (this.timeSeries && node instanceof EsQueryExec) {
                return TimeSeriesSourceOperator.pageSize((long)estimatedRowSize.intValue(), (long)this.plannerSettings.valuesLoadingJumboSize().getBytes());
            }
            return Math.max(32, SourceOperator.TARGET_PAGE_SIZE / estimatedRowSize);
        }
    }

    record DriverParallelism(Type type, int instanceCount) {
        static final DriverParallelism SINGLE = new DriverParallelism(Type.SINGLETON, 1);

        DriverParallelism {
            if (instanceCount <= 0) {
                throw new IllegalArgumentException("instance count must be greater than zero; got: " + instanceCount);
            }
        }

        static enum Type {
            SINGLETON,
            DATA_PARALLELISM,
            TASK_LEVEL_PARALLELISM;

        }
    }

    public static class PhysicalOperation
    implements Describable {
        final SourceOperator.SourceOperatorFactory sourceOperatorFactory;
        final List<Operator.OperatorFactory> intermediateOperatorFactories;
        final SinkOperator.SinkOperatorFactory sinkOperatorFactory;
        final Layout layout;

        static PhysicalOperation fromSource(SourceOperator.SourceOperatorFactory sourceOperatorFactory, Layout layout) {
            return new PhysicalOperation(sourceOperatorFactory, layout);
        }

        PhysicalOperation with(Layout layout) {
            return new PhysicalOperation(this, Optional.empty(), Optional.empty(), layout);
        }

        PhysicalOperation with(Operator.OperatorFactory operatorFactory, Layout layout) {
            return new PhysicalOperation(this, Optional.of(operatorFactory), Optional.empty(), layout);
        }

        PhysicalOperation withSink(SinkOperator.SinkOperatorFactory sink, Layout layout) {
            return new PhysicalOperation(this, Optional.empty(), Optional.of(sink), layout);
        }

        private PhysicalOperation(SourceOperator.SourceOperatorFactory sourceOperatorFactory, Layout layout) {
            this.sourceOperatorFactory = sourceOperatorFactory;
            this.intermediateOperatorFactories = List.of();
            this.sinkOperatorFactory = null;
            this.layout = layout;
        }

        private PhysicalOperation(PhysicalOperation physicalOperation, Optional<Operator.OperatorFactory> intermediateOperatorFactory, Optional<SinkOperator.SinkOperatorFactory> sinkOperatorFactory, Layout layout) {
            this.sourceOperatorFactory = physicalOperation.sourceOperatorFactory;
            this.intermediateOperatorFactories = new ArrayList<Operator.OperatorFactory>();
            this.intermediateOperatorFactories.addAll(physicalOperation.intermediateOperatorFactories);
            intermediateOperatorFactory.ifPresent(this.intermediateOperatorFactories::add);
            this.sinkOperatorFactory = sinkOperatorFactory.isPresent() ? sinkOperatorFactory.get() : null;
            this.layout = layout;
        }

        public SourceOperator source(DriverContext driverContext) {
            return this.sourceOperatorFactory.get(driverContext);
        }

        public void operators(List<Operator> operators, DriverContext driverContext) {
            this.intermediateOperatorFactories.stream().map(opFactory -> opFactory.get(driverContext)).forEach(operators::add);
        }

        public SinkOperator sink(DriverContext driverContext) {
            return this.sinkOperatorFactory.get(driverContext);
        }

        public String describe() {
            return Stream.concat(Stream.concat(Stream.of(this.sourceOperatorFactory), this.intermediateOperatorFactories.stream()), Stream.of(this.sinkOperatorFactory)).map(describable -> describable == null ? "null" : describable.describe()).collect(Collectors.joining("\n\\_", "\\_", ""));
        }

        public String toString() {
            return this.describe();
        }
    }

    record DriverFactory(DriverSupplier driverSupplier, DriverParallelism driverParallelism) implements Describable
    {
        public String describe() {
            return "DriverFactory(instances = " + this.driverParallelism.instanceCount() + ", type = " + String.valueOf((Object)this.driverParallelism.type()) + ")\n" + this.driverSupplier.describe();
        }
    }

    record DriverSupplier(String description, String clusterName, String nodeName, BigArrays bigArrays, BlockFactory blockFactory, PhysicalOperation physicalOperation, TimeValue statusInterval, Settings settings) implements Function<String, Driver>,
    Describable
    {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Driver apply(String sessionId) {
            Driver driver;
            block3: {
                SourceOperator source = null;
                ArrayList<Operator> operators = new ArrayList<Operator>();
                SinkOperator sink = null;
                boolean success = false;
                LocalCircuitBreaker.SizeSettings localBreakerSettings = new LocalCircuitBreaker.SizeSettings(this.settings);
                LocalCircuitBreaker localBreaker = new LocalCircuitBreaker(this.blockFactory.breaker(), localBreakerSettings.overReservedBytes(), localBreakerSettings.maxOverReservedBytes());
                DriverContext driverContext = new DriverContext(this.bigArrays, this.blockFactory.newChildFactory(localBreaker));
                try {
                    source = this.physicalOperation.source(driverContext);
                    this.physicalOperation.operators(operators, driverContext);
                    sink = this.physicalOperation.sink(driverContext);
                    success = true;
                    driver = new Driver(sessionId, this.description, this.clusterName, this.nodeName, System.currentTimeMillis(), System.nanoTime(), driverContext, this.physicalOperation::describe, source, operators, sink, this.statusInterval, (Releasable)localBreaker);
                    if (success) break block3;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        Releasables.close((Releasable[])new Releasable[]{source, () -> Releasables.close((Iterable)operators), sink, localBreaker});
                    }
                    throw throwable;
                }
                Releasables.close((Releasable[])new Releasable[]{source, () -> Releasables.close((Iterable)operators), sink, localBreaker});
            }
            return driver;
        }

        public String describe() {
            return this.physicalOperation.describe();
        }
    }

    public static class LocalExecutionPlan
    implements Describable {
        final List<DriverFactory> driverFactories;

        LocalExecutionPlan(List<DriverFactory> driverFactories) {
            this.driverFactories = driverFactories;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<Driver> createDrivers(String sessionId) {
            ArrayList<Driver> drivers = new ArrayList<Driver>();
            boolean success = false;
            try {
                for (DriverFactory df : this.driverFactories) {
                    for (int i = 0; i < df.driverParallelism.instanceCount; ++i) {
                        logger.trace("building {} {}", new Object[]{i, df});
                        drivers.add(df.driverSupplier.apply(sessionId));
                    }
                }
                success = true;
                ArrayList<Driver> arrayList = drivers;
                return arrayList;
            }
            finally {
                if (!success) {
                    Releasables.close((Releasable)Releasables.wrap(drivers));
                }
            }
        }

        public String describe() {
            return this.driverFactories.stream().map(DriverFactory::describe).collect(Collectors.joining("\n"));
        }
    }
}

