/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical.join;

import java.util.Collections;
import java.util.List;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.esql.capabilities.PostAnalysisVerificationAware;
import org.elasticsearch.xpack.esql.capabilities.TelemetryAware;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.plan.logical.Limit;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.SurrogateLogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.join.Join;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinConfig;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinType;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinTypes;

public class LookupJoin
extends Join
implements SurrogateLogicalPlan,
TelemetryAware,
PostAnalysisVerificationAware {
    public LookupJoin(Source source, LogicalPlan left, LogicalPlan right, List<Attribute> joinFields, boolean isRemote, @Nullable Expression joinOnConditions) {
        this(source, left, right, new JoinTypes.UsingJoinType(JoinTypes.LEFT, joinFields), Collections.emptyList(), Collections.emptyList(), isRemote, joinOnConditions);
    }

    public LookupJoin(Source source, LogicalPlan left, LogicalPlan right, JoinType type, List<Attribute> leftFields, List<Attribute> rightFields, boolean isRemote, Expression joinOnConditions) {
        this(source, left, right, new JoinConfig(type, leftFields, rightFields, joinOnConditions), isRemote);
    }

    public LookupJoin(Source source, LogicalPlan left, LogicalPlan right, JoinConfig joinConfig) {
        this(source, left, right, joinConfig, false);
    }

    public LookupJoin(Source source, LogicalPlan left, LogicalPlan right, JoinConfig joinConfig, boolean isRemote) {
        super(source, left, right, joinConfig, isRemote);
    }

    @Override
    public LogicalPlan surrogate() {
        return new Join(this.source(), this.left(), this.right(), this.config(), this.isRemote());
    }

    @Override
    public Join replaceChildren(LogicalPlan left, LogicalPlan right) {
        return new LookupJoin(this.source(), left, right, this.config(), this.isRemote());
    }

    @Override
    protected NodeInfo<Join> info() {
        return NodeInfo.create((Node)this, LookupJoin::new, (Object)((Object)this.left()), (Object)((Object)this.right()), (Object)this.config().type(), this.config().leftFields(), this.config().rightFields(), (Object)this.isRemote(), (Object)this.config().joinOnConditions());
    }

    @Override
    public String telemetryLabel() {
        if (this.config().joinOnConditions() == null) {
            return "LOOKUP JOIN";
        }
        return "LOOKUP JOIN ON EXPRESSION";
    }

    @Override
    public void postAnalysisVerification(Failures failures) {
        super.postAnalysisVerification(failures);
        if (this.isRemote()) {
            this.checkRemoteJoin(failures);
        }
    }

    private void checkRemoteJoin(Failures failures) {
        this.forEachUp(Limit.class, f -> failures.add(Failure.fail(this, "LOOKUP JOIN with remote indices can't be executed after [" + f.source().text() + "]" + String.valueOf(f.source().source()), new Object[0])));
    }
}

