/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.versionfield;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.script.field.AbstractScriptFieldFactory;
import org.elasticsearch.script.field.DocValuesScriptFieldFactory;
import org.elasticsearch.script.field.Field;
import org.elasticsearch.xpack.versionfield.Version;
import org.elasticsearch.xpack.versionfield.VersionEncoder;
import org.elasticsearch.xpack.versionfield.VersionScriptDocValues;

public class VersionStringDocValuesField
extends AbstractScriptFieldFactory<Version>
implements Field<Version>,
DocValuesScriptFieldFactory,
ScriptDocValues.Supplier<String> {
    protected final SortedSetDocValues input;
    protected final String name;
    protected long[] ords = new long[0];
    protected int count;
    private VersionScriptDocValues versionScriptDocValues = null;

    public VersionStringDocValuesField(SortedSetDocValues input, String name) {
        this.input = input;
        this.name = name;
    }

    public void setNextDocId(int docId) throws IOException {
        this.count = 0;
        if (this.input.advanceExact(docId)) {
            for (int i = 0; i < this.input.docValueCount(); ++i) {
                long ord = this.input.nextOrd();
                this.ords = ArrayUtil.grow((long[])this.ords, (int)(this.count + 1));
                this.ords[this.count++] = ord;
            }
        }
    }

    public String getInternal(int index) {
        return VersionEncoder.decodeVersion(this.getBytesRefInternal(index)).utf8ToString();
    }

    private BytesRef getBytesRefInternal(int index) {
        try {
            return this.input.lookupOrd(this.ords[index]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int size() {
        return this.count;
    }

    public ScriptDocValues<?> toScriptDocValues() {
        if (this.versionScriptDocValues == null) {
            this.versionScriptDocValues = new VersionScriptDocValues(this);
        }
        return this.versionScriptDocValues;
    }

    public String asString(String defaultValue) {
        return this.asString(0, defaultValue);
    }

    public String asString(int index, String defaultValue) {
        if (this.isEmpty() || index < 0 || index >= this.size()) {
            return defaultValue;
        }
        return this.getInternal(index);
    }

    public List<String> asStrings() {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> values = new ArrayList<String>(this.size());
        for (int i = 0; i < this.size(); ++i) {
            values.add(this.getInternal(i));
        }
        return values;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Version get(Version defaultValue) {
        return this.get(0, defaultValue);
    }

    public Version get(int index, Version defaultValue) {
        if (this.isEmpty() || index < 0 || index >= this.size()) {
            return defaultValue;
        }
        return new Version(this.getBytesRefInternal(index));
    }

    public Iterator<Version> iterator() {
        return new Iterator<Version>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < VersionStringDocValuesField.this.size();
            }

            @Override
            public Version next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return new Version(VersionStringDocValuesField.this.getBytesRefInternal(this.index++));
            }
        };
    }
}

