/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.logsdb.patterntext;

import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.LeafReader;
import org.elasticsearch.index.mapper.CompositeSyntheticFieldLoader;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.logsdb.patterntext.PatternTextFieldMapper;

class PatternTextSyntheticFieldLoaderLayer
implements CompositeSyntheticFieldLoader.DocValuesLayer {
    private PatternTextSyntheticFieldLoader loader;
    private final String name;
    private final PatternTextFieldMapper.DocValuesSupplier docValuesSupplier;

    PatternTextSyntheticFieldLoaderLayer(String name, PatternTextFieldMapper.DocValuesSupplier docValuesSupplier) {
        this.name = name;
        this.docValuesSupplier = docValuesSupplier;
    }

    public long valueCount() {
        return this.loader != null && this.loader.hasValue() ? 1L : 0L;
    }

    public SourceLoader.SyntheticFieldLoader.DocValuesLoader docValuesLoader(LeafReader leafReader, int[] docIdsInLeaf) throws IOException {
        BinaryDocValues docValues = this.docValuesSupplier.get(leafReader);
        if (docValues == null) {
            return null;
        }
        this.loader = new PatternTextSyntheticFieldLoader(docValues);
        return this.loader;
    }

    public boolean hasValue() {
        return this.loader != null && this.loader.hasValue();
    }

    public void write(XContentBuilder b) throws IOException {
        if (this.loader != null) {
            this.loader.write(b);
        }
    }

    public String fieldName() {
        return this.name;
    }

    private static class PatternTextSyntheticFieldLoader
    implements SourceLoader.SyntheticFieldLoader.DocValuesLoader {
        private final BinaryDocValues docValues;
        private boolean hasValue = false;

        PatternTextSyntheticFieldLoader(BinaryDocValues docValues) {
            this.docValues = docValues;
        }

        public boolean hasValue() {
            assert (this.docValues.docID() != Integer.MAX_VALUE);
            return this.hasValue;
        }

        public boolean advanceToDoc(int docId) throws IOException {
            this.hasValue = this.docValues.advanceExact(docId);
            return this.hasValue;
        }

        public void write(XContentBuilder b) throws IOException {
            if (this.hasValue) {
                b.value(this.docValues.binaryValue().utf8ToString());
            }
        }
    }
}

