/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Comparator;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.PlainArray;
import org.ojalgo.array.ReferenceTypeArray;
import org.ojalgo.array.operation.AMAX;
import org.ojalgo.array.operation.AXPY;
import org.ojalgo.function.BigFunction;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.function.aggregator.BigAggregator;
import org.ojalgo.machine.MemoryEstimator;
import org.ojalgo.scalar.BigScalar;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Mutate1D;

public class BigArray
extends ReferenceTypeArray<BigDecimal> {
    public static final DenseArray.Factory<BigDecimal> FACTORY = new DenseArray.Factory<BigDecimal>(){

        @Override
        public AggregatorSet<BigDecimal> aggregator() {
            return BigAggregator.getSet();
        }

        @Override
        public FunctionSet<BigDecimal> function() {
            return BigFunction.getSet();
        }

        @Override
        public Scalar.Factory<BigDecimal> scalar() {
            return BigScalar.FACTORY;
        }

        @Override
        long getElementSize() {
            return ELEMENT_SIZE;
        }

        @Override
        PlainArray<BigDecimal> makeDenseArray(long size) {
            return BigArray.make((int)size);
        }
    };
    static final long ELEMENT_SIZE = MemoryEstimator.estimateObject(BigDecimal.class);

    public static final BigArray make(int size) {
        return new BigArray(size);
    }

    public static final BigArray wrap(BigDecimal ... data) {
        return new BigArray(data);
    }

    protected BigArray(BigDecimal[] data) {
        super(FACTORY, (Comparable[])data);
    }

    protected BigArray(int size) {
        super(FACTORY, size);
    }

    @Override
    public final void axpy(double a, Mutate1D.Modifiable<?> y) {
        AXPY.invoke(y, a, (BigDecimal[])this.data);
    }

    @Override
    public final void sortAscending() {
        Arrays.parallelSort((Comparable[])this.data);
    }

    @Override
    public void sortDescending() {
        Arrays.parallelSort(this.data, Comparator.reverseOrder());
    }

    @Override
    protected final void add(int index, Comparable<?> addend) {
        this.fillOne(index, ((BigDecimal)this.get(index)).add((BigDecimal)this.valueOf(addend)));
    }

    @Override
    protected final void add(int index, double addend) {
        this.fillOne(index, ((BigDecimal)this.get(index)).add((BigDecimal)this.valueOf(addend)));
    }

    @Override
    protected final void add(int index, float addend) {
        this.fillOne(index, ((BigDecimal)this.get(index)).add((BigDecimal)this.valueOf(addend)));
    }

    @Override
    protected final double doubleValue(int index) {
        return ((BigDecimal[])this.data)[index].doubleValue();
    }

    @Override
    protected final void fillOne(int index, Access1D<?> values, long valueIndex) {
        ((BigDecimal[])this.data)[index] = (BigDecimal)this.valueOf((Comparable<?>)values.get(valueIndex));
    }

    @Override
    protected final float floatValue(int index) {
        return ((BigDecimal[])this.data)[index].floatValue();
    }

    @Override
    protected final int indexOfLargest(int first, int limit, int step) {
        return AMAX.invoke((BigDecimal[])this.data, first, limit, step);
    }

    @Override
    protected boolean isAbsolute(int index) {
        return BigScalar.isAbsolute(((BigDecimal[])this.data)[index]);
    }

    @Override
    protected boolean isSmall(int index, double comparedTo) {
        return BigScalar.isSmall(comparedTo, ((BigDecimal[])this.data)[index]);
    }
}

