/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.exponentialhistogram;

import java.util.Arrays;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.exponentialhistogram.RamEstimationUtil;

class DownscaleStats {
    static final long SIZE = RamUsageEstimator.shallowSizeOf(DownscaleStats.class) + RamEstimationUtil.estimateIntArray(62);
    int[] collapsedBucketCount = new int[62];

    DownscaleStats() {
    }

    void reset() {
        Arrays.fill(this.collapsedBucketCount, 0);
    }

    void add(long previousBucketIndex, long currentBucketIndex) {
        assert (currentBucketIndex > previousBucketIndex);
        assert (previousBucketIndex >= -4611686018427387903L && previousBucketIndex <= 0x3FFFFFFFFFFFFFFFL);
        assert (currentBucketIndex <= 0x3FFFFFFFFFFFFFFFL);
        long bitXor = previousBucketIndex ^ currentBucketIndex;
        int numEqualLeadingBits = Long.numberOfLeadingZeros(bitXor);
        if (numEqualLeadingBits > 0) {
            int requiredScaleChange = 64 - numEqualLeadingBits;
            int n = requiredScaleChange - 1;
            this.collapsedBucketCount[n] = this.collapsedBucketCount[n] + 1;
        }
    }

    int getCollapsedBucketCountAfterScaleReduction(int reduction) {
        assert (reduction >= 0 && reduction <= 62);
        int totalCollapsed = 0;
        for (int i = 0; i < reduction; ++i) {
            totalCollapsed += this.collapsedBucketCount[i];
        }
        return totalCollapsed;
    }

    int getRequiredScaleReductionToReduceBucketCountBy(int desiredCollapsedBucketCount) {
        assert (desiredCollapsedBucketCount >= 0);
        if (desiredCollapsedBucketCount == 0) {
            return 0;
        }
        int totalCollapsed = 0;
        for (int i = 0; i < this.collapsedBucketCount.length; ++i) {
            if ((totalCollapsed += this.collapsedBucketCount[i]) < desiredCollapsedBucketCount) continue;
            return i + 1;
        }
        throw new IllegalStateException("Cannot reduce the bucket count by " + desiredCollapsedBucketCount);
    }
}

