/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.optimizer;

import java.time.DateTimeException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.xpack.ql.expression.Alias;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.AttributeMap;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.expression.Nullability;
import org.elasticsearch.xpack.ql.expression.Order;
import org.elasticsearch.xpack.ql.expression.function.Function;
import org.elasticsearch.xpack.ql.expression.function.Functions;
import org.elasticsearch.xpack.ql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.ql.expression.function.scalar.SurrogateFunction;
import org.elasticsearch.xpack.ql.expression.predicate.BinaryOperator;
import org.elasticsearch.xpack.ql.expression.predicate.BinaryPredicate;
import org.elasticsearch.xpack.ql.expression.predicate.Negatable;
import org.elasticsearch.xpack.ql.expression.predicate.Predicates;
import org.elasticsearch.xpack.ql.expression.predicate.Range;
import org.elasticsearch.xpack.ql.expression.predicate.logical.And;
import org.elasticsearch.xpack.ql.expression.predicate.logical.BinaryLogic;
import org.elasticsearch.xpack.ql.expression.predicate.logical.Not;
import org.elasticsearch.xpack.ql.expression.predicate.logical.Or;
import org.elasticsearch.xpack.ql.expression.predicate.nulls.IsNotNull;
import org.elasticsearch.xpack.ql.expression.predicate.nulls.IsNull;
import org.elasticsearch.xpack.ql.expression.predicate.operator.arithmetic.ArithmeticOperation;
import org.elasticsearch.xpack.ql.expression.predicate.operator.arithmetic.BinaryComparisonInversible;
import org.elasticsearch.xpack.ql.expression.predicate.operator.arithmetic.DefaultBinaryArithmeticOperation;
import org.elasticsearch.xpack.ql.expression.predicate.operator.arithmetic.Neg;
import org.elasticsearch.xpack.ql.expression.predicate.operator.arithmetic.Sub;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.BinaryComparison;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.Equals;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.GreaterThan;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.GreaterThanOrEqual;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.In;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.LessThan;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.LessThanOrEqual;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.NotEquals;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.NullEquals;
import org.elasticsearch.xpack.ql.expression.predicate.regex.RegexMatch;
import org.elasticsearch.xpack.ql.plan.logical.Aggregate;
import org.elasticsearch.xpack.ql.plan.logical.Filter;
import org.elasticsearch.xpack.ql.plan.logical.Limit;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.plan.logical.OrderBy;
import org.elasticsearch.xpack.ql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.ql.rule.Rule;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.CollectionUtils;
import org.elasticsearch.xpack.ql.util.ReflectionUtils;

public final class OptimizerRules {

    public static enum TransformDirection {
        UP,
        DOWN;

    }

    public static abstract class OptimizerExpressionRule<E extends Expression>
    extends Rule<LogicalPlan, LogicalPlan> {
        private final TransformDirection direction;
        private final Class<E> expressionTypeToken = ReflectionUtils.detectSuperTypeForRuleLike(this.getClass());

        public OptimizerExpressionRule(TransformDirection direction) {
            this.direction = direction;
        }

        @Override
        public final LogicalPlan apply(LogicalPlan plan) {
            return this.direction == TransformDirection.DOWN ? (LogicalPlan)plan.transformExpressionsDown(this.expressionTypeToken, this::rule) : (LogicalPlan)plan.transformExpressionsUp(this.expressionTypeToken, this::rule);
        }

        protected LogicalPlan rule(LogicalPlan plan) {
            return plan;
        }

        protected abstract Expression rule(E var1);

        public Class<E> expressionToken() {
            return this.expressionTypeToken;
        }
    }

    public static abstract class OptimizerRule<SubPlan extends LogicalPlan>
    extends Rule<SubPlan, LogicalPlan> {
        private final TransformDirection direction;

        public OptimizerRule() {
            this(TransformDirection.DOWN);
        }

        protected OptimizerRule(TransformDirection direction) {
            this.direction = direction;
        }

        @Override
        public final LogicalPlan apply(LogicalPlan plan) {
            return this.direction == TransformDirection.DOWN ? plan.transformDown(this.typeToken(), this::rule) : plan.transformUp(this.typeToken(), this::rule);
        }

        protected abstract LogicalPlan rule(SubPlan var1);
    }

    public static final class SetAsOptimized
    extends Rule<LogicalPlan, LogicalPlan> {
        @Override
        public LogicalPlan apply(LogicalPlan plan) {
            plan.forEachUp(SetAsOptimized::rule);
            return plan;
        }

        private static void rule(LogicalPlan plan) {
            if (!plan.optimized()) {
                plan.setOptimized();
            }
        }
    }

    public static class InferIsNotNull
    extends Rule<LogicalPlan, LogicalPlan> {
        @Override
        public LogicalPlan apply(LogicalPlan plan) {
            AttributeMap aliases = new AttributeMap();
            plan = plan.transformUp(p -> this.inspectPlan((LogicalPlan)p, aliases));
            return plan;
        }

        private LogicalPlan inspectPlan(LogicalPlan plan, AttributeMap<Expression> aliases) {
            plan.forEachExpression(Alias.class, a -> aliases.put(a.toAttribute(), a.child()));
            LogicalPlan newPlan = (LogicalPlan)plan.transformExpressionsOnlyUp(IsNotNull.class, inn -> this.inferNotNullable((IsNotNull)inn, aliases));
            return newPlan;
        }

        private Expression inferNotNullable(IsNotNull inn, AttributeMap<Expression> aliases) {
            Expression result = inn;
            Set<Expression> refs = this.resolveExpressionAsRootAttributes(inn.field(), aliases);
            if (refs.size() > 0) {
                List<Expression> innList = CollectionUtils.combine(refs.stream().map(r -> new IsNotNull(inn.source(), (Expression)r)).toList(), inn);
                result = Predicates.combineAnd(innList);
            }
            return result;
        }

        protected Set<Expression> resolveExpressionAsRootAttributes(Expression exp, AttributeMap<Expression> aliases) {
            LinkedHashSet<Expression> resolvedExpressions = new LinkedHashSet<Expression>();
            boolean changed = this.doResolve(exp, aliases, resolvedExpressions);
            return changed ? resolvedExpressions : Collections.emptySet();
        }

        private boolean doResolve(Expression exp, AttributeMap<Expression> aliases, Set<Expression> resolvedExpressions) {
            boolean changed = false;
            if (this.skipExpression(exp)) {
                resolvedExpressions.add(exp);
            } else {
                for (Expression e : exp.references()) {
                    Expression resolved = aliases.resolve(e, e);
                    if (resolved instanceof Attribute) {
                        Attribute a = (Attribute)resolved;
                        if (resolved == e) {
                            resolvedExpressions.add(a);
                            changed |= resolved != exp;
                            continue;
                        }
                    }
                    changed |= this.doResolve(resolved, aliases, resolvedExpressions);
                }
            }
            return changed;
        }

        protected boolean skipExpression(Expression e) {
            return e.nullable() == Nullability.FALSE;
        }
    }

    public static class PropagateNullable
    extends OptimizerExpressionRule<And> {
        public PropagateNullable() {
            super(TransformDirection.DOWN);
        }

        @Override
        protected Expression rule(And and) {
            List<Expression> splits = Predicates.splitAnd(and);
            LinkedHashSet<Expression> nullExpressions = new LinkedHashSet<Expression>();
            LinkedHashSet<Expression> notNullExpressions = new LinkedHashSet<Expression>();
            LinkedList<Expression> others = new LinkedList<Expression>();
            for (Expression ex : splits) {
                if (ex instanceof IsNull) {
                    IsNull isn = (IsNull)ex;
                    nullExpressions.add(isn.field());
                    continue;
                }
                if (ex instanceof IsNotNull) {
                    IsNotNull isnn = (IsNotNull)ex;
                    notNullExpressions.add(isnn.field());
                    continue;
                }
                others.add(ex);
            }
            if (Sets.haveNonEmptyIntersection(nullExpressions, notNullExpressions)) {
                return Literal.of(and, Boolean.FALSE);
            }
            boolean modified = PropagateNullable.replace(nullExpressions, others, splits, this::nullify);
            if (modified |= PropagateNullable.replace(notNullExpressions, others, splits, this::nonNullify)) {
                return Predicates.combineAnd(splits);
            }
            return and;
        }

        private static boolean replace(Iterable<Expression> pattern, List<Expression> target, List<Expression> originalExpressions, BiFunction<Expression, Expression, Expression> replacer) {
            boolean modified = false;
            for (Expression s : pattern) {
                for (int i = 0; i < target.size(); ++i) {
                    Expression replacement;
                    Expression t = target.get(i);
                    if (!t.anyMatch(s::semanticEquals) || (replacement = replacer.apply(t, s)) == t) continue;
                    modified = true;
                    target.set(i, replacement);
                    originalExpressions.replaceAll(e -> t.semanticEquals((Expression)e) ? replacement : e);
                }
            }
            return modified;
        }

        protected Expression nullify(Expression exp, Expression nullExp) {
            return exp.nullable() == Nullability.TRUE ? Literal.of(exp, null) : exp;
        }

        protected Expression nonNullify(Expression exp, Expression nonNullExp) {
            return exp;
        }
    }

    public static class FoldNull
    extends OptimizerExpressionRule<Expression> {
        public FoldNull() {
            super(TransformDirection.UP);
        }

        @Override
        protected Expression rule(Expression e) {
            Expression result = this.tryReplaceIsNullIsNotNull(e);
            if (result != e) {
                return result;
            }
            if (e instanceof In) {
                In in = (In)e;
                if (Expressions.isNull(in.value())) {
                    return Literal.of(in, null);
                }
            } else if (!(e instanceof Alias) && e.nullable() == Nullability.TRUE && Expressions.anyMatch(e.children(), Expressions::isNull)) {
                return Literal.of(e, null);
            }
            return e;
        }

        protected Expression tryReplaceIsNullIsNotNull(Expression e) {
            IsNull isn;
            if (e instanceof IsNotNull) {
                IsNotNull isnn = (IsNotNull)e;
                if (isnn.field().nullable() == Nullability.FALSE) {
                    return new Literal(e.source(), Boolean.TRUE, DataTypes.BOOLEAN);
                }
            } else if (e instanceof IsNull && (isn = (IsNull)e).field().nullable() == Nullability.FALSE) {
                return new Literal(e.source(), Boolean.FALSE, DataTypes.BOOLEAN);
            }
            return e;
        }
    }

    public static class ReplaceRegexMatch
    extends OptimizerExpressionRule<RegexMatch<?>> {
        public ReplaceRegexMatch() {
            super(TransformDirection.DOWN);
        }

        @Override
        protected Expression rule(RegexMatch<?> regexMatch) {
            Expression e = regexMatch;
            Object pattern = regexMatch.pattern();
            if (pattern.matchesAll()) {
                e = new IsNotNull(e.source(), regexMatch.field());
            } else {
                String match = pattern.exactMatch();
                if (match != null) {
                    Literal literal = new Literal(regexMatch.source(), match, DataTypes.KEYWORD);
                    e = this.regexToEquals(regexMatch, literal);
                }
            }
            return e;
        }

        protected Expression regexToEquals(RegexMatch<?> regexMatch, Literal literal) {
            return new Equals(regexMatch.source(), regexMatch.field(), literal);
        }
    }

    public static abstract class SkipQueryOnLimitZero
    extends OptimizerRule<Limit> {
        @Override
        protected LogicalPlan rule(Limit limit) {
            if (limit.limit().foldable() && Integer.valueOf(0).equals(limit.limit().fold())) {
                return this.skipPlan(limit);
            }
            return limit;
        }

        protected abstract LogicalPlan skipPlan(Limit var1);
    }

    public static abstract class PruneCast<C extends Expression>
    extends Rule<LogicalPlan, LogicalPlan> {
        private final Class<C> castType;

        public PruneCast(Class<C> castType) {
            this.castType = castType;
        }

        @Override
        public final LogicalPlan apply(LogicalPlan plan) {
            return this.rule(plan);
        }

        protected final LogicalPlan rule(LogicalPlan plan) {
            return (LogicalPlan)plan.transformExpressionsUp(this.castType, this::maybePruneCast);
        }

        protected abstract Expression maybePruneCast(C var1);
    }

    public static final class PruneLiteralsInOrderBy
    extends OptimizerRule<OrderBy> {
        @Override
        protected LogicalPlan rule(OrderBy ob) {
            ArrayList<Order> prunedOrders = new ArrayList<Order>();
            for (Order o : ob.order()) {
                if (!o.child().foldable()) continue;
                prunedOrders.add(o);
            }
            if (prunedOrders.size() == ob.order().size()) {
                return ob.child();
            }
            if (prunedOrders.size() > 0) {
                ArrayList<Order> newOrders = new ArrayList<Order>(ob.order());
                newOrders.removeAll(prunedOrders);
                return new OrderBy(ob.source(), ob.child(), newOrders);
            }
            return ob;
        }
    }

    public static abstract class PruneFilters
    extends OptimizerRule<Filter> {
        @Override
        protected LogicalPlan rule(Filter filter) {
            Expression condition = filter.condition().transformUp(BinaryLogic.class, PruneFilters::foldBinaryLogic);
            if (condition instanceof Literal) {
                if (Literal.TRUE.equals(condition)) {
                    return filter.child();
                }
                if (Literal.FALSE.equals(condition) || Expressions.isNull(condition)) {
                    return this.skipPlan(filter);
                }
            }
            if (!condition.equals(filter.condition())) {
                return new Filter(filter.source(), filter.child(), condition);
            }
            return filter;
        }

        protected abstract LogicalPlan skipPlan(Filter var1);

        private static Expression foldBinaryLogic(BinaryLogic binaryLogic) {
            And and;
            if (binaryLogic instanceof Or) {
                Or or = (Or)binaryLogic;
                boolean nullLeft = Expressions.isNull(or.left());
                boolean nullRight = Expressions.isNull(or.right());
                if (nullLeft && nullRight) {
                    return new Literal(binaryLogic.source(), null, DataTypes.NULL);
                }
                if (nullLeft) {
                    return or.right();
                }
                if (nullRight) {
                    return or.left();
                }
            }
            if (binaryLogic instanceof And && (Expressions.isNull((and = (And)binaryLogic).left()) || Expressions.isNull(and.right()))) {
                return new Literal(binaryLogic.source(), null, DataTypes.NULL);
            }
            return binaryLogic;
        }
    }

    public static final class SimplifyComparisonsArithmetics
    extends OptimizerExpressionRule<BinaryComparison> {
        BiFunction<DataType, DataType, Boolean> typesCompatible;

        public SimplifyComparisonsArithmetics(BiFunction<DataType, DataType, Boolean> typesCompatible) {
            super(TransformDirection.UP);
            this.typesCompatible = typesCompatible;
        }

        @Override
        protected Expression rule(BinaryComparison bc) {
            if (bc.right() instanceof Literal) {
                if (bc.left() instanceof ArithmeticOperation) {
                    return this.simplifyBinaryComparison(bc);
                }
                if (bc.left() instanceof Neg) {
                    return SimplifyComparisonsArithmetics.foldNegation(bc);
                }
            }
            return bc;
        }

        private Expression simplifyBinaryComparison(BinaryComparison comparison) {
            ArithmeticOperation operation = (ArithmeticOperation)comparison.left();
            String opSymbol = operation.symbol();
            if (opSymbol.equals(DefaultBinaryArithmeticOperation.MOD.symbol())) {
                return comparison;
            }
            OperationSimplifier simplification = null;
            if (SimplifyComparisonsArithmetics.isMulOrDiv(opSymbol)) {
                simplification = new MulDivSimplifier(comparison);
            } else if (opSymbol.equals(DefaultBinaryArithmeticOperation.ADD.symbol()) || opSymbol.equals(DefaultBinaryArithmeticOperation.SUB.symbol())) {
                simplification = new AddSubSimplifier(comparison);
            }
            return simplification == null || simplification.isUnsafe(this.typesCompatible) ? comparison : simplification.apply();
        }

        private static boolean isMulOrDiv(String opSymbol) {
            return opSymbol.equals(DefaultBinaryArithmeticOperation.MUL.symbol()) || opSymbol.equals(DefaultBinaryArithmeticOperation.DIV.symbol());
        }

        private static Expression foldNegation(BinaryComparison bc) {
            Literal bcLiteral = (Literal)bc.right();
            Expression literalNeg = SimplifyComparisonsArithmetics.tryFolding(new Neg(bcLiteral.source(), bcLiteral));
            return literalNeg == null ? bc : bc.reverse().replaceChildren((List)Arrays.asList(((Neg)bc.left()).field(), literalNeg));
        }

        private static Expression tryFolding(Expression expression) {
            if (expression.foldable()) {
                try {
                    expression = new Literal(expression.source(), expression.fold(), expression.dataType());
                }
                catch (ArithmeticException | DateTimeException e) {
                    expression = null;
                }
            }
            return expression;
        }

        private static class MulDivSimplifier
        extends OperationSimplifier {
            private final boolean isDiv;
            private final int opRightSign;

            MulDivSimplifier(BinaryComparison comparison) {
                super(comparison);
                this.isDiv = this.operation.symbol().equals(DefaultBinaryArithmeticOperation.DIV.symbol());
                this.opRightSign = MulDivSimplifier.sign(this.opRight);
            }

            @Override
            boolean isOpUnsafe() {
                if (this.operation.dataType().isInteger() && this.isDiv) {
                    return true;
                }
                if (!this.isDiv && this.opLeft.dataType().isInteger()) {
                    long opLiteralValue = ((Number)this.opLiteral.value()).longValue();
                    return opLiteralValue == 0L || ((Number)this.bcLiteral.value()).longValue() % opLiteralValue != 0L;
                }
                return this.opRightSign == 0;
            }

            @Override
            Expression postProcess(BinaryComparison binaryComparison) {
                return this.opRightSign < 0 ? binaryComparison.reverse() : binaryComparison;
            }

            private static int sign(Object obj) {
                ArithmeticOperation operation;
                int sign = 1;
                if (obj instanceof Number) {
                    sign = (int)Math.signum(((Number)obj).doubleValue());
                } else if (obj instanceof Literal) {
                    sign = MulDivSimplifier.sign(((Literal)obj).value());
                } else if (obj instanceof Neg) {
                    sign = -MulDivSimplifier.sign(((Neg)obj).field());
                } else if (obj instanceof ArithmeticOperation && SimplifyComparisonsArithmetics.isMulOrDiv((operation = (ArithmeticOperation)obj).symbol())) {
                    sign = MulDivSimplifier.sign(operation.left()) * MulDivSimplifier.sign(operation.right());
                }
                return sign;
            }
        }

        private static class AddSubSimplifier
        extends OperationSimplifier {
            AddSubSimplifier(BinaryComparison comparison) {
                super(comparison);
            }

            @Override
            boolean isOpUnsafe() {
                if (this.operation.dataType().isRational()) {
                    return true;
                }
                if (this.operation.symbol().equals(DefaultBinaryArithmeticOperation.SUB.symbol()) && !(this.opRight instanceof Literal)) {
                    return SimplifyComparisonsArithmetics.tryFolding(new Sub(Source.EMPTY, this.opLeft, this.bcLiteral)) == null;
                }
                return false;
            }
        }

        private static abstract class OperationSimplifier {
            final BinaryComparison comparison;
            final Literal bcLiteral;
            final ArithmeticOperation operation;
            final Expression opLeft;
            final Expression opRight;
            final Literal opLiteral;

            OperationSimplifier(BinaryComparison comparison) {
                this.comparison = comparison;
                this.operation = (ArithmeticOperation)comparison.left();
                this.bcLiteral = (Literal)comparison.right();
                this.opLeft = this.operation.left();
                this.opRight = this.operation.right();
                this.opLiteral = this.opLeft instanceof Literal ? (Literal)this.opLeft : (this.opRight instanceof Literal ? (Literal)this.opRight : null);
            }

            final boolean isUnsafe(BiFunction<DataType, DataType, Boolean> typesCompatible) {
                if (this.opLiteral == null) {
                    return true;
                }
                if (this.opLiteral.dataType().isRational() || this.bcLiteral.dataType().isRational()) {
                    return true;
                }
                if (!typesCompatible.apply(this.bcLiteral.dataType(), this.opLiteral.dataType()).booleanValue()) {
                    return true;
                }
                return this.isOpUnsafe();
            }

            final Expression apply() {
                Literal bcl = this.operation.dataType().isRational() ? Literal.of(this.bcLiteral, ((Number)this.bcLiteral.value()).doubleValue()) : this.bcLiteral;
                Expression bcRightExpression = ((BinaryComparisonInversible)((Object)this.operation)).binaryComparisonInverse().create(bcl.source(), bcl, this.opRight);
                bcRightExpression = SimplifyComparisonsArithmetics.tryFolding(bcRightExpression);
                return bcRightExpression != null ? this.postProcess((BinaryComparison)this.comparison.replaceChildren(List.of(this.opLeft, bcRightExpression))) : this.comparison;
            }

            abstract boolean isOpUnsafe();

            Expression postProcess(BinaryComparison binaryComparison) {
                return binaryComparison;
            }
        }
    }

    public static class ReplaceSurrogateFunction
    extends OptimizerExpressionRule<Expression> {
        public ReplaceSurrogateFunction() {
            super(TransformDirection.DOWN);
        }

        @Override
        protected Expression rule(Expression e) {
            if (e instanceof SurrogateFunction) {
                e = ((SurrogateFunction)((Object)e)).substitute();
            }
            return e;
        }
    }

    public static class PushDownAndCombineFilters
    extends OptimizerRule<Filter> {
        @Override
        protected LogicalPlan rule(Filter filter) {
            UnaryPlan plan = filter;
            LogicalPlan child = filter.child();
            Expression condition = filter.condition();
            if (child instanceof Filter) {
                Filter f = (Filter)child;
                plan = f.with(new And(f.source(), f.condition(), condition));
            } else if (child instanceof UnaryPlan) {
                UnaryPlan unary = (UnaryPlan)child;
                if (unary instanceof Aggregate && condition.anyMatch(Functions::isAggregate)) {
                    ArrayList<Expression> conjunctions = new ArrayList<Expression>(Predicates.splitAnd(condition));
                    ArrayList<Expression> inPlace = new ArrayList<Expression>();
                    Iterator iterator = conjunctions.iterator();
                    while (iterator.hasNext()) {
                        Expression conjunction = (Expression)iterator.next();
                        if (!conjunction.anyMatch(Functions::isAggregate)) continue;
                        inPlace.add(conjunction);
                        iterator.remove();
                    }
                    if (conjunctions.size() > 0) {
                        child = unary.replaceChild(filter.with(unary.child(), Predicates.combineAnd(conjunctions)));
                        plan = filter.with(child, Predicates.combineAnd(inPlace));
                    }
                } else {
                    plan = unary.replaceChild(filter.with(unary.child(), condition));
                }
            }
            return plan;
        }
    }

    public static class CombineDisjunctionsToIn
    extends OptimizerExpressionRule<Or> {
        public CombineDisjunctionsToIn() {
            super(TransformDirection.UP);
        }

        @Override
        protected Expression rule(Or or) {
            Expression e = or;
            List<Expression> exps = Predicates.splitOr(e);
            LinkedHashMap<Expression, Set> found = new LinkedHashMap<Expression, Set>();
            LinkedHashMap<Expression, List> originalOrs = new LinkedHashMap<Expression, List>();
            ZoneId zoneId = null;
            LinkedList<Expression> ors = new LinkedList<Expression>();
            for (Expression exp : exps) {
                if (exp instanceof Equals) {
                    Equals eq = (Equals)exp;
                    if (eq.right().foldable()) {
                        found.computeIfAbsent(eq.left(), k -> new LinkedHashSet()).add(eq.right());
                        if (this.shouldValidateIn()) {
                            originalOrs.computeIfAbsent(eq.left(), k -> new ArrayList()).add(eq);
                        }
                    } else {
                        ors.add(exp);
                    }
                    if (zoneId != null) continue;
                    zoneId = eq.zoneId();
                    continue;
                }
                if (exp instanceof In) {
                    In in = (In)exp;
                    found.computeIfAbsent(in.value(), k -> new LinkedHashSet()).addAll(in.list());
                    if (this.shouldValidateIn()) {
                        originalOrs.computeIfAbsent(in.value(), k -> new ArrayList()).add(in);
                    }
                    if (zoneId != null) continue;
                    zoneId = in.zoneId();
                    continue;
                }
                ors.add(exp);
            }
            if (!found.isEmpty()) {
                ZoneId finalZoneId = zoneId;
                found.forEach((k, v) -> {
                    if (v.size() == 1) {
                        ors.add(this.createEquals((Expression)k, (Expression)v.iterator().next(), finalZoneId));
                    } else {
                        In in = this.createIn((Expression)k, (List<Expression>)new ArrayList<Expression>((Collection<Expression>)v), finalZoneId);
                        if (this.shouldValidateIn()) {
                            Expression.TypeResolution resolution = in.validateInTypes();
                            if (resolution.unresolved()) {
                                assert (originalOrs.containsKey(k));
                                assert (!((List)originalOrs.get(k)).isEmpty());
                                ors.add(Predicates.combineOr((List)originalOrs.get(k)));
                            } else {
                                ors.add(in);
                            }
                        } else {
                            ors.add(in);
                        }
                    }
                });
                Expression combineOr = Predicates.combineOr(ors);
                if (!e.semanticEquals(combineOr)) {
                    e = combineOr;
                }
            }
            return e;
        }

        protected In createIn(Expression key, List<Expression> values, ZoneId zoneId) {
            return new In(key.source(), key, values, zoneId);
        }

        protected boolean shouldValidateIn() {
            return false;
        }

        private Equals createEquals(Expression key, Expression value, ZoneId finalZoneId) {
            return new Equals(key.source(), key, value, finalZoneId);
        }
    }

    public static final class CombineBinaryComparisons
    extends OptimizerExpressionRule<BinaryLogic> {
        public CombineBinaryComparisons() {
            super(TransformDirection.DOWN);
        }

        @Override
        public Expression rule(BinaryLogic e) {
            if (e instanceof And) {
                return CombineBinaryComparisons.combine((And)e);
            }
            if (e instanceof Or) {
                return CombineBinaryComparisons.combine((Or)e);
            }
            return e;
        }

        private static Expression combine(And and) {
            ArrayList<Range> ranges = new ArrayList<Range>();
            ArrayList<BinaryComparison> bcs = new ArrayList<BinaryComparison>();
            ArrayList<Expression> exps = new ArrayList<Expression>();
            boolean changed = false;
            List<Expression> andExps = Predicates.splitAnd(and);
            andExps.sort((o1, o2) -> {
                if (o1 instanceof Range && o2 instanceof Range) {
                    return 0;
                }
                if (o1 instanceof Range || o2 instanceof Range) {
                    return o2 instanceof Range ? 1 : -1;
                }
                if (o1 instanceof NotEquals && o2 instanceof NotEquals) {
                    return 0;
                }
                if (o1 instanceof NotEquals || o2 instanceof NotEquals) {
                    return o1 instanceof NotEquals ? 1 : -1;
                }
                return 0;
            });
            for (Expression ex : andExps) {
                if (ex instanceof Range) {
                    Range r = (Range)ex;
                    if (CombineBinaryComparisons.findExistingRange(r, ranges, true)) {
                        changed = true;
                        continue;
                    }
                    ranges.add(r);
                    continue;
                }
                if (ex instanceof BinaryComparison) {
                    BinaryComparison bc = (BinaryComparison)ex;
                    if (!(ex instanceof Equals || ex instanceof NotEquals)) {
                        if (bc.right().foldable() && (CombineBinaryComparisons.findConjunctiveComparisonInRange(bc, ranges) || CombineBinaryComparisons.findExistingComparison(bc, bcs, true))) {
                            changed = true;
                            continue;
                        }
                        bcs.add(bc);
                        continue;
                    }
                }
                if (ex instanceof NotEquals) {
                    NotEquals neq = (NotEquals)ex;
                    if (neq.right().foldable() && CombineBinaryComparisons.notEqualsIsRemovableFromConjunction(neq, ranges, bcs)) {
                        changed = true;
                        continue;
                    }
                    exps.add(ex);
                    continue;
                }
                exps.add(ex);
            }
            int step = 1;
            for (int i = 0; i < bcs.size() - 1; i += step) {
                BinaryComparison main = (BinaryComparison)bcs.get(i);
                for (int j = i + 1; j < bcs.size(); ++j) {
                    BinaryComparison other = (BinaryComparison)bcs.get(j);
                    if (!main.left().semanticEquals(other.left())) continue;
                    if ((main instanceof GreaterThan || main instanceof GreaterThanOrEqual) && (other instanceof LessThan || other instanceof LessThanOrEqual)) {
                        bcs.remove(j);
                        bcs.remove(i);
                        ranges.add(new Range(and.source(), main.left(), main.right(), main instanceof GreaterThanOrEqual, other.right(), other instanceof LessThanOrEqual, main.zoneId()));
                        changed = true;
                        step = 0;
                        break;
                    }
                    if (!(other instanceof GreaterThan) && !(other instanceof GreaterThanOrEqual) || !(main instanceof LessThan) && !(main instanceof LessThanOrEqual)) continue;
                    bcs.remove(j);
                    bcs.remove(i);
                    ranges.add(new Range(and.source(), main.left(), other.right(), other instanceof GreaterThanOrEqual, main.right(), main instanceof LessThanOrEqual, main.zoneId()));
                    changed = true;
                    step = 0;
                    break;
                }
                step = 1;
            }
            return changed ? Predicates.combineAnd(CollectionUtils.combine(new Collection[]{exps, bcs, ranges})) : and;
        }

        private static Expression combine(Or or) {
            ArrayList<BinaryComparison> bcs = new ArrayList<BinaryComparison>();
            ArrayList<Range> ranges = new ArrayList<Range>();
            ArrayList<Expression> exps = new ArrayList<Expression>();
            boolean changed = false;
            for (Expression ex : Predicates.splitOr(or)) {
                if (ex instanceof Range) {
                    Range r = (Range)ex;
                    if (CombineBinaryComparisons.findExistingRange(r, ranges, false)) {
                        changed = true;
                        continue;
                    }
                    ranges.add(r);
                    continue;
                }
                if (ex instanceof BinaryComparison) {
                    BinaryComparison bc = (BinaryComparison)ex;
                    if (bc.right().foldable() && CombineBinaryComparisons.findExistingComparison(bc, bcs, false)) {
                        changed = true;
                        continue;
                    }
                    bcs.add(bc);
                    continue;
                }
                exps.add(ex);
            }
            return changed ? Predicates.combineOr(CollectionUtils.combine(new Collection[]{exps, bcs, ranges})) : or;
        }

        private static boolean findExistingRange(Range main, List<Range> ranges, boolean conjunctive) {
            if (!main.lower().foldable() && !main.upper().foldable()) {
                return false;
            }
            for (int i = 0; i < ranges.size(); ++i) {
                Integer comp;
                Range other = ranges.get(i);
                if (!main.value().semanticEquals(other.value())) continue;
                boolean compared = false;
                boolean lower = false;
                boolean upper = false;
                boolean lowerEq = false;
                boolean upperEq = false;
                if (main.lower().foldable() && other.lower().foldable()) {
                    compared = true;
                    comp = BinaryComparison.compare(main.lower().fold(), other.lower().fold());
                    if (comp != null) {
                        boolean bl = lowerEq = comp == 0 && main.includeLower() == other.includeLower();
                        if (conjunctive) {
                            lower = comp > 0 || comp == 0 && !main.includeLower() && other.includeLower();
                        } else {
                            boolean bl2 = lower = comp < 0 || comp == 0 && main.includeLower() && !other.includeLower() || lowerEq;
                        }
                    }
                }
                if (main.upper().foldable() && other.upper().foldable()) {
                    compared = true;
                    comp = BinaryComparison.compare(main.upper().fold(), other.upper().fold());
                    if (comp != null) {
                        boolean bl = upperEq = comp == 0 && main.includeUpper() == other.includeUpper();
                        if (conjunctive) {
                            upper = comp < 0 || comp == 0 && !main.includeUpper() && other.includeUpper();
                        } else {
                            boolean bl3 = upper = comp > 0 || comp == 0 && main.includeUpper() && !other.includeUpper() || upperEq;
                        }
                    }
                }
                if (conjunctive) {
                    if (lower || upper) {
                        ranges.set(i, new Range(main.source(), main.value(), lower ? main.lower() : other.lower(), lower ? main.includeLower() : other.includeLower(), upper ? main.upper() : other.upper(), upper ? main.includeUpper() : other.includeUpper(), main.zoneId()));
                    }
                    return compared;
                }
                if (lower && upper) {
                    ranges.set(i, new Range(main.source(), main.value(), main.lower(), main.includeLower(), main.upper(), main.includeUpper(), main.zoneId()));
                    return true;
                }
                return compared && !(lower && !lowerEq || upper && !upperEq);
            }
            return false;
        }

        private static boolean findConjunctiveComparisonInRange(BinaryComparison main, List<Range> ranges) {
            Object value = main.right().fold();
            for (int i = 0; i < ranges.size(); ++i) {
                Integer comp;
                Range other = ranges.get(i);
                if (!main.left().semanticEquals(other.value())) continue;
                if (main instanceof GreaterThan || main instanceof GreaterThanOrEqual) {
                    Integer comp2;
                    if (other.lower().foldable() && (comp2 = BinaryComparison.compare(value, other.lower().fold())) != null) {
                        boolean lower;
                        boolean lowerEq = comp2 == 0 && other.includeLower() && main instanceof GreaterThan;
                        boolean bl = lower = comp2 > 0 || lowerEq;
                        if (lower) {
                            ranges.set(i, new Range(other.source(), other.value(), main.right(), lowerEq ? false : main instanceof GreaterThanOrEqual, other.upper(), other.includeUpper(), other.zoneId()));
                        }
                        return true;
                    }
                } else if ((main instanceof LessThan || main instanceof LessThanOrEqual) && other.upper().foldable() && (comp = BinaryComparison.compare(value, other.upper().fold())) != null) {
                    boolean upper;
                    boolean upperEq = comp == 0 && other.includeUpper() && main instanceof LessThan;
                    boolean bl = upper = comp < 0 || upperEq;
                    if (upper) {
                        ranges.set(i, new Range(other.source(), other.value(), other.lower(), other.includeLower(), main.right(), upperEq ? false : main instanceof LessThanOrEqual, other.zoneId()));
                    }
                    return true;
                }
                return false;
            }
            return false;
        }

        private static boolean findExistingComparison(BinaryComparison main, List<BinaryComparison> bcs, boolean conjunctive) {
            Object value = main.right().fold();
            for (int i = 0; i < bcs.size(); ++i) {
                BinaryComparison other = bcs.get(i);
                if (!other.right().foldable()) continue;
                if ((other instanceof GreaterThan || other instanceof GreaterThanOrEqual) && (main instanceof GreaterThan || main instanceof GreaterThanOrEqual)) {
                    if (!main.left().semanticEquals(other.left())) continue;
                    Integer compare = BinaryComparison.compare(value, other.right().fold());
                    if (compare != null) {
                        if (conjunctive && (compare > 0 || compare == 0 && main instanceof GreaterThan && other instanceof GreaterThanOrEqual) || !conjunctive && (compare < 0 || compare == 0 && main instanceof GreaterThanOrEqual && other instanceof GreaterThan)) {
                            bcs.remove(i);
                            bcs.add(i, main);
                        }
                        return true;
                    }
                    return false;
                }
                if (!(other instanceof LessThan) && !(other instanceof LessThanOrEqual) || !(main instanceof LessThan) && !(main instanceof LessThanOrEqual) || !main.left().semanticEquals(other.left())) continue;
                Integer compare = BinaryComparison.compare(value, other.right().fold());
                if (compare != null) {
                    if (conjunctive && (compare < 0 || compare == 0 && main instanceof LessThan && other instanceof LessThanOrEqual) || !conjunctive && (compare > 0 || compare == 0 && main instanceof LessThanOrEqual && other instanceof LessThan)) {
                        bcs.remove(i);
                        bcs.add(i, main);
                    }
                    return true;
                }
                return false;
            }
            return false;
        }

        private static boolean notEqualsIsRemovableFromConjunction(NotEquals notEquals, List<Range> ranges, List<BinaryComparison> bcs) {
            Integer comp;
            int i;
            Object neqVal = notEquals.right().fold();
            for (i = 0; i < ranges.size(); ++i) {
                Range range = ranges.get(i);
                if (!notEquals.left().semanticEquals(range.value())) continue;
                Integer n = comp = range.lower().foldable() ? BinaryComparison.compare(neqVal, range.lower().fold()) : null;
                if (comp != null) {
                    if (comp <= 0) {
                        if (comp == 0 && range.includeLower()) {
                            ranges.set(i, new Range(range.source(), range.value(), range.lower(), false, range.upper(), range.includeUpper(), range.zoneId()));
                        }
                        return true;
                    }
                    Integer n2 = comp = range.upper().foldable() ? BinaryComparison.compare(neqVal, range.upper().fold()) : null;
                    if (comp != null && comp >= 0) {
                        if (comp == 0 && range.includeUpper()) {
                            ranges.set(i, new Range(range.source(), range.value(), range.lower(), range.includeLower(), range.upper(), false, range.zoneId()));
                        }
                        return true;
                    }
                }
                Integer n3 = comp = range.upper().foldable() ? BinaryComparison.compare(neqVal, range.upper().fold()) : null;
                if (comp == null || comp < 0) continue;
                if (comp == 0 && range.includeUpper()) {
                    ranges.set(i, new Range(range.source(), range.value(), range.lower(), range.includeLower(), range.upper(), false, range.zoneId()));
                }
                return true;
            }
            for (i = 0; i < bcs.size(); ++i) {
                BinaryComparison bc = bcs.get(i);
                if (!notEquals.left().semanticEquals(bc.left())) continue;
                if (bc instanceof LessThan || bc instanceof LessThanOrEqual) {
                    Integer n = comp = bc.right().foldable() ? BinaryComparison.compare(neqVal, bc.right().fold()) : null;
                    if (comp == null || comp < 0) continue;
                    if (comp == 0 && bc instanceof LessThanOrEqual) {
                        bcs.set(i, new LessThan(bc.source(), bc.left(), bc.right(), bc.zoneId()));
                    }
                    return true;
                }
                if (!(bc instanceof GreaterThan) && !(bc instanceof GreaterThanOrEqual)) continue;
                Integer n = comp = bc.right().foldable() ? BinaryComparison.compare(neqVal, bc.right().fold()) : null;
                if (comp == null || comp > 0) continue;
                if (comp == 0 && bc instanceof GreaterThanOrEqual) {
                    bcs.set(i, new GreaterThan(bc.source(), bc.left(), bc.right(), bc.zoneId()));
                }
                return true;
            }
            return false;
        }
    }

    public static final class PropagateEquals
    extends OptimizerExpressionRule<BinaryLogic> {
        public PropagateEquals() {
            super(TransformDirection.DOWN);
        }

        @Override
        public Expression rule(BinaryLogic e) {
            if (e instanceof And) {
                return PropagateEquals.propagate((And)e);
            }
            if (e instanceof Or) {
                return PropagateEquals.propagate((Or)e);
            }
            return e;
        }

        private static Expression propagate(And and) {
            ArrayList<Range> ranges = new ArrayList<Range>();
            ArrayList<BinaryComparison> equals = new ArrayList<BinaryComparison>();
            ArrayList<NotEquals> notEquals = new ArrayList<NotEquals>();
            ArrayList<BinaryComparison> inequalities = new ArrayList<BinaryComparison>();
            ArrayList<Expression> exps = new ArrayList<Expression>();
            boolean changed = false;
            for (Expression ex : Predicates.splitAnd(and)) {
                if (ex instanceof Range) {
                    ranges.add((Range)ex);
                    continue;
                }
                if (ex instanceof Equals || ex instanceof NullEquals) {
                    BinaryComparison otherEq = (BinaryComparison)ex;
                    if (otherEq.right().foldable() && !DataTypes.isDateTime(otherEq.left().dataType())) {
                        for (BinaryComparison eq : equals) {
                            Integer comp;
                            if (!otherEq.left().semanticEquals(eq.left()) || (comp = BinaryComparison.compare(eq.right().fold(), otherEq.right().fold())) == null || comp == 0) continue;
                            return new Literal(and.source(), Boolean.FALSE, DataTypes.BOOLEAN);
                        }
                        equals.add(otherEq);
                        continue;
                    }
                    exps.add(otherEq);
                    continue;
                }
                if (ex instanceof GreaterThan || ex instanceof GreaterThanOrEqual || ex instanceof LessThan || ex instanceof LessThanOrEqual) {
                    BinaryComparison bc = (BinaryComparison)ex;
                    if (bc.right().foldable()) {
                        inequalities.add(bc);
                        continue;
                    }
                    exps.add(ex);
                    continue;
                }
                if (ex instanceof NotEquals) {
                    NotEquals otherNotEq = (NotEquals)ex;
                    if (otherNotEq.right().foldable()) {
                        notEquals.add(otherNotEq);
                        continue;
                    }
                    exps.add(ex);
                    continue;
                }
                exps.add(ex);
            }
            for (BinaryComparison eq : equals) {
                Integer compare;
                Object eqValue = eq.right().fold();
                Iterator iterator = ranges.iterator();
                while (iterator.hasNext()) {
                    Range range = (Range)iterator.next();
                    if (!range.value().semanticEquals(eq.left())) continue;
                    if (range.lower().foldable() && (compare = BinaryComparison.compare(range.lower().fold(), eqValue)) != null && (compare > 0 || compare == 0 && !range.includeLower())) {
                        return new Literal(and.source(), Boolean.FALSE, DataTypes.BOOLEAN);
                    }
                    if (range.upper().foldable() && (compare = BinaryComparison.compare(range.upper().fold(), eqValue)) != null && (compare < 0 || compare == 0 && !range.includeUpper())) {
                        return new Literal(and.source(), Boolean.FALSE, DataTypes.BOOLEAN);
                    }
                    iterator.remove();
                    changed = true;
                }
                Iterator iter = notEquals.iterator();
                while (iter.hasNext()) {
                    Integer comp;
                    NotEquals neq = (NotEquals)iter.next();
                    if (!eq.left().semanticEquals(neq.left()) || (comp = BinaryComparison.compare(eqValue, neq.right().fold())) == null) continue;
                    if (comp == 0) {
                        return new Literal(and.source(), Boolean.FALSE, DataTypes.BOOLEAN);
                    }
                    iter.remove();
                    changed = true;
                }
                iter = inequalities.iterator();
                while (iter.hasNext()) {
                    BinaryComparison bc = (BinaryComparison)iter.next();
                    if (!eq.left().semanticEquals(bc.left()) || (compare = BinaryComparison.compare(eqValue, bc.right().fold())) == null) continue;
                    if (bc instanceof LessThan || bc instanceof LessThanOrEqual ? compare == 0 && bc instanceof LessThan || 0 < compare : (bc instanceof GreaterThan || bc instanceof GreaterThanOrEqual) && (compare == 0 && bc instanceof GreaterThan || compare < 0)) {
                        return new Literal(and.source(), Boolean.FALSE, DataTypes.BOOLEAN);
                    }
                    iter.remove();
                    changed = true;
                }
            }
            return changed ? Predicates.combineAnd(CollectionUtils.combine(new Collection[]{exps, equals, notEquals, inequalities, ranges})) : and;
        }

        private static Expression propagate(Or or) {
            Equals eq;
            ArrayList<Expression> exps = new ArrayList<Expression>();
            ArrayList<Equals> equals = new ArrayList<Equals>();
            ArrayList<NotEquals> notEquals = new ArrayList<NotEquals>();
            ArrayList<Range> ranges = new ArrayList<Range>();
            ArrayList<BinaryComparison> inequalities = new ArrayList<BinaryComparison>();
            for (Expression ex : Predicates.splitOr(or)) {
                if (ex instanceof Equals) {
                    eq = (Equals)ex;
                    if (eq.right().foldable()) {
                        equals.add(eq);
                        continue;
                    }
                    exps.add(ex);
                    continue;
                }
                if (ex instanceof NotEquals) {
                    NotEquals neq = (NotEquals)ex;
                    if (neq.right().foldable()) {
                        notEquals.add(neq);
                        continue;
                    }
                    exps.add(ex);
                    continue;
                }
                if (ex instanceof Range) {
                    ranges.add((Range)ex);
                    continue;
                }
                if (ex instanceof BinaryComparison) {
                    BinaryComparison bc = (BinaryComparison)ex;
                    if (bc.right().foldable()) {
                        inequalities.add(bc);
                        continue;
                    }
                    exps.add(ex);
                    continue;
                }
                exps.add(ex);
            }
            boolean updated = false;
            Iterator iterEq = equals.iterator();
            while (iterEq.hasNext()) {
                int i;
                Integer comp;
                eq = (Equals)iterEq.next();
                Object eqValue = eq.right().fold();
                boolean removeEquals = false;
                for (NotEquals neq : notEquals) {
                    if (!eq.left().semanticEquals(neq.left()) || (comp = BinaryComparison.compare(eqValue, neq.right().fold())) == null) continue;
                    if (comp == 0) {
                        return Literal.TRUE;
                    }
                    removeEquals = true;
                    break;
                }
                if (removeEquals) {
                    iterEq.remove();
                    updated = true;
                    continue;
                }
                for (i = 0; i < ranges.size(); ++i) {
                    Integer upperComp;
                    Range range = (Range)ranges.get(i);
                    if (!eq.left().semanticEquals(range.value())) continue;
                    Integer lowerComp = range.lower().foldable() ? BinaryComparison.compare(eqValue, range.lower().fold()) : null;
                    Integer n = upperComp = range.upper().foldable() ? BinaryComparison.compare(eqValue, range.upper().fold()) : null;
                    if (lowerComp != null && lowerComp == 0) {
                        if (!range.includeLower()) {
                            ranges.set(i, new Range(range.source(), range.value(), range.lower(), true, range.upper(), range.includeUpper(), range.zoneId()));
                        }
                        removeEquals = true;
                        break;
                    }
                    if (upperComp != null && upperComp == 0) {
                        if (!range.includeUpper()) {
                            ranges.set(i, new Range(range.source(), range.value(), range.lower(), range.includeLower(), range.upper(), true, range.zoneId()));
                        }
                        removeEquals = true;
                        break;
                    }
                    if (lowerComp == null || upperComp == null || 0 >= lowerComp || upperComp >= 0) continue;
                    removeEquals = true;
                    break;
                }
                if (removeEquals) {
                    iterEq.remove();
                    updated = true;
                    continue;
                }
                for (i = 0; i < inequalities.size(); ++i) {
                    BinaryComparison bc = (BinaryComparison)inequalities.get(i);
                    if (!eq.left().semanticEquals(bc.left()) || (comp = BinaryComparison.compare(eqValue, bc.right().fold())) == null) continue;
                    if (bc instanceof GreaterThan || bc instanceof GreaterThanOrEqual) {
                        if (comp < 0) continue;
                        if (comp == 0 && bc instanceof GreaterThan) {
                            inequalities.set(i, new GreaterThanOrEqual(bc.source(), bc.left(), bc.right(), bc.zoneId()));
                        }
                        removeEquals = true;
                        break;
                    }
                    if (!(bc instanceof LessThan) && !(bc instanceof LessThanOrEqual) || comp > 0) continue;
                    if (comp == 0 && bc instanceof LessThan) {
                        inequalities.set(i, new LessThanOrEqual(bc.source(), bc.left(), bc.right(), bc.zoneId()));
                    }
                    removeEquals = true;
                    break;
                }
                if (!removeEquals) continue;
                iterEq.remove();
                updated = true;
            }
            return updated ? Predicates.combineOr(CollectionUtils.combine(new Collection[]{exps, equals, notEquals, inequalities, ranges})) : or;
        }
    }

    public static final class LiteralsOnTheRight
    extends OptimizerExpressionRule<BinaryOperator<?, ?, ?, ?>> {
        public LiteralsOnTheRight() {
            super(TransformDirection.UP);
        }

        public BinaryOperator<?, ?, ?, ?> rule(BinaryOperator<?, ?, ?, ?> be) {
            return be.left() instanceof Literal && !(be.right() instanceof Literal) ? be.swapLeftAndRight() : be;
        }
    }

    public static class BinaryComparisonSimplification
    extends OptimizerExpressionRule<BinaryComparison> {
        public BinaryComparisonSimplification() {
            super(TransformDirection.DOWN);
        }

        @Override
        protected Expression rule(BinaryComparison bc) {
            Expression l = bc.left();
            Expression r = bc.right();
            if ((bc instanceof Equals || bc instanceof GreaterThanOrEqual || bc instanceof LessThanOrEqual) && l.nullable() == Nullability.FALSE && r.nullable() == Nullability.FALSE && l.semanticEquals(r)) {
                return new Literal(bc.source(), Boolean.TRUE, DataTypes.BOOLEAN);
            }
            if (bc instanceof NullEquals) {
                if (l.semanticEquals(r)) {
                    return new Literal(bc.source(), Boolean.TRUE, DataTypes.BOOLEAN);
                }
                if (Expressions.isNull(r)) {
                    return new IsNull(bc.source(), l);
                }
            }
            if ((bc instanceof NotEquals || bc instanceof GreaterThan || bc instanceof LessThan) && l.nullable() == Nullability.FALSE && r.nullable() == Nullability.FALSE && l.semanticEquals(r)) {
                return new Literal(bc.source(), Boolean.FALSE, DataTypes.BOOLEAN);
            }
            return bc;
        }
    }

    public static class BooleanSimplification
    extends OptimizerExpressionRule<ScalarFunction> {
        public BooleanSimplification() {
            super(TransformDirection.UP);
        }

        @Override
        public Expression rule(ScalarFunction e) {
            if (e instanceof And || e instanceof Or) {
                return BooleanSimplification.simplifyAndOr((BinaryPredicate)e);
            }
            if (e instanceof Not) {
                return this.simplifyNot((Not)e);
            }
            return e;
        }

        private static Expression simplifyAndOr(BinaryPredicate<?, ?, ?, ?> bc) {
            Expression l = bc.left();
            Expression r = bc.right();
            if (bc instanceof And) {
                List<Expression> rightSplit;
                if (Literal.TRUE.equals(l)) {
                    return r;
                }
                if (Literal.TRUE.equals(r)) {
                    return l;
                }
                if (Literal.FALSE.equals(l) || Literal.FALSE.equals(r)) {
                    return new Literal(bc.source(), Boolean.FALSE, DataTypes.BOOLEAN);
                }
                if (l.semanticEquals(r)) {
                    return l;
                }
                List<Expression> leftSplit = Predicates.splitOr(l);
                List<Expression> common = Predicates.inCommon(leftSplit, rightSplit = Predicates.splitOr(r));
                if (common.isEmpty()) {
                    return bc;
                }
                List<Expression> lDiff = Predicates.subtract(leftSplit, common);
                List<Expression> rDiff = Predicates.subtract(rightSplit, common);
                if (lDiff.isEmpty() || rDiff.isEmpty()) {
                    return Predicates.combineOr(common);
                }
                Expression combineLeft = Predicates.combineOr(lDiff);
                Expression combineRight = Predicates.combineOr(rDiff);
                return Predicates.combineOr(CollectionUtils.combine(common, new And(combineLeft.source(), combineLeft, combineRight)));
            }
            if (bc instanceof Or) {
                List<Expression> rightSplit;
                if (Literal.TRUE.equals(l) || Literal.TRUE.equals(r)) {
                    return new Literal(bc.source(), Boolean.TRUE, DataTypes.BOOLEAN);
                }
                if (Literal.FALSE.equals(l)) {
                    return r;
                }
                if (Literal.FALSE.equals(r)) {
                    return l;
                }
                if (l.semanticEquals(r)) {
                    return l;
                }
                List<Expression> leftSplit = Predicates.splitAnd(l);
                List<Expression> common = Predicates.inCommon(leftSplit, rightSplit = Predicates.splitAnd(r));
                if (common.isEmpty()) {
                    return bc;
                }
                List<Expression> lDiff = Predicates.subtract(leftSplit, common);
                List<Expression> rDiff = Predicates.subtract(rightSplit, common);
                if (lDiff.isEmpty() || rDiff.isEmpty()) {
                    return Predicates.combineAnd(common);
                }
                Expression combineLeft = Predicates.combineAnd(lDiff);
                Expression combineRight = Predicates.combineAnd(rDiff);
                return Predicates.combineAnd(CollectionUtils.combine(common, new Or(combineLeft.source(), combineLeft, combineRight)));
            }
            return bc;
        }

        private Expression simplifyNot(Not n) {
            Expression c = n.field();
            if (Literal.TRUE.semanticEquals(c)) {
                return new Literal(n.source(), Boolean.FALSE, DataTypes.BOOLEAN);
            }
            if (Literal.FALSE.semanticEquals(c)) {
                return new Literal(n.source(), Boolean.TRUE, DataTypes.BOOLEAN);
            }
            Expression negated = this.maybeSimplifyNegatable(c);
            if (negated != null) {
                return negated;
            }
            if (c instanceof Not) {
                return ((Not)c).field();
            }
            return n;
        }

        protected Expression maybeSimplifyNegatable(Expression e) {
            if (e instanceof Negatable) {
                return ((Negatable)((Object)e)).negate();
            }
            return null;
        }
    }

    public static final class BooleanFunctionEqualsElimination
    extends OptimizerExpressionRule<BinaryComparison> {
        public BooleanFunctionEqualsElimination() {
            super(TransformDirection.UP);
        }

        @Override
        protected Expression rule(BinaryComparison bc) {
            if ((bc instanceof Equals || bc instanceof NotEquals) && bc.left() instanceof Function) {
                if (Literal.TRUE.equals(bc.right())) {
                    return bc instanceof Equals ? bc.left() : new Not(bc.left().source(), bc.left());
                }
                if (Literal.FALSE.equals(bc.right())) {
                    return bc instanceof Equals ? new Not(bc.left().source(), bc.left()) : bc.left();
                }
            }
            return bc;
        }
    }

    public static final class ConstantFolding
    extends OptimizerExpressionRule<Expression> {
        public ConstantFolding() {
            super(TransformDirection.DOWN);
        }

        @Override
        public Expression rule(Expression e) {
            return e.foldable() ? Literal.of(e) : e;
        }
    }
}

