/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.streams.logs;

import java.util.List;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.rest.streams.logs.LogsStreamsActivationToggleAction;

@ServerlessScope(value=Scope.PUBLIC)
public class RestSetLogStreamsEnabledAction
extends BaseRestHandler {
    public static final Set<String> SUPPORTED_PARAMS = Set.of("master_timeout", "timeout");

    public String getName() {
        return "streams_logs_set_enabled_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_streams/logs/_enable"), new RestHandler.Route(RestRequest.Method.POST, "/_streams/logs/_disable"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        boolean enabled = request.path().endsWith("_enable");
        assert (enabled || request.path().endsWith("_disable"));
        LogsStreamsActivationToggleAction.Request activationRequest = new LogsStreamsActivationToggleAction.Request(RestUtils.getMasterNodeTimeout((RestRequest)request), RestUtils.getAckTimeout((RestRequest)request), enabled);
        return restChannel -> new RestCancellableNodeClient(client, request.getHttpChannel()).execute(LogsStreamsActivationToggleAction.INSTANCE, (ActionRequest)activationRequest, (ActionListener)new RestToXContentListener(restChannel));
    }

    public Set<String> supportedQueryParameters() {
        return SUPPORTED_PARAMS;
    }
}

