/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.dfs;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.dfs.DfsKnnResults;
import org.elasticsearch.search.internal.ShardSearchContextId;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.profile.SearchProfileDfsPhaseResult;

public final class DfsSearchResult
extends SearchPhaseResult {
    private static final Term[] EMPTY_TERMS = new Term[0];
    private static final TermStatistics[] EMPTY_TERM_STATS = new TermStatistics[0];
    private Term[] terms;
    private TermStatistics[] termStatistics;
    private Map<String, CollectionStatistics> fieldStatistics = new HashMap<String, CollectionStatistics>();
    private List<DfsKnnResults> knnResults;
    private int maxDoc;
    private SearchProfileDfsPhaseResult searchProfileDfsPhaseResult;

    public DfsSearchResult(StreamInput in) throws IOException {
        this.contextId = new ShardSearchContextId(in);
        int termsSize = in.readVInt();
        if (termsSize == 0) {
            this.terms = EMPTY_TERMS;
        } else {
            this.terms = new Term[termsSize];
            for (int i = 0; i < this.terms.length; ++i) {
                this.terms[i] = new Term(in.readString(), in.readSlicedBytesReference().toBytesRef());
            }
        }
        this.termStatistics = DfsSearchResult.readTermStats(in, this.terms);
        this.fieldStatistics = DfsSearchResult.readFieldStats(in);
        this.maxDoc = in.readVInt();
        this.setShardSearchRequest(in.readOptionalWriteable(ShardSearchRequest::new));
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_4_0)) {
            if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_7_0)) {
                this.knnResults = in.readOptionalCollectionAsList(DfsKnnResults::new);
            } else {
                DfsKnnResults results = in.readOptionalWriteable(DfsKnnResults::new);
                List<Object> list = this.knnResults = results != null ? List.of(results) : List.of();
            }
        }
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_6_0)) {
            this.searchProfileDfsPhaseResult = in.readOptionalWriteable(SearchProfileDfsPhaseResult::new);
        }
    }

    public DfsSearchResult(ShardSearchContextId contextId, SearchShardTarget shardTarget, ShardSearchRequest shardSearchRequest) {
        this.setSearchShardTarget(shardTarget);
        this.contextId = contextId;
        this.setShardSearchRequest(shardSearchRequest);
    }

    public DfsSearchResult maxDoc(int maxDoc) {
        this.maxDoc = maxDoc;
        return this;
    }

    public int maxDoc() {
        return this.maxDoc;
    }

    public DfsSearchResult termsStatistics(Term[] terms, TermStatistics[] termStatistics) {
        this.terms = terms;
        this.termStatistics = termStatistics;
        return this;
    }

    public DfsSearchResult fieldStatistics(Map<String, CollectionStatistics> fieldStatistics) {
        this.fieldStatistics = fieldStatistics;
        return this;
    }

    public DfsSearchResult knnResults(List<DfsKnnResults> knnResults) {
        this.knnResults = knnResults;
        return this;
    }

    public DfsSearchResult profileResult(SearchProfileDfsPhaseResult searchProfileDfsPhaseResult) {
        this.searchProfileDfsPhaseResult = searchProfileDfsPhaseResult;
        return this;
    }

    public Term[] terms() {
        return this.terms;
    }

    public TermStatistics[] termStatistics() {
        return this.termStatistics;
    }

    public Map<String, CollectionStatistics> fieldStatistics() {
        return this.fieldStatistics;
    }

    public List<DfsKnnResults> knnResults() {
        return this.knnResults;
    }

    public SearchProfileDfsPhaseResult searchProfileDfsPhaseResult() {
        return this.searchProfileDfsPhaseResult;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.contextId.writeTo(out);
        out.writeArray((o, term) -> {
            o.writeString(term.field());
            o.writeBytesRef(term.bytes());
        }, this.terms);
        DfsSearchResult.writeTermStats(out, this.termStatistics);
        DfsSearchResult.writeFieldStats(out, this.fieldStatistics);
        out.writeVInt(this.maxDoc);
        out.writeOptionalWriteable(this.getShardSearchRequest());
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_4_0)) {
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_7_0)) {
                out.writeOptionalCollection(this.knnResults);
            } else {
                if (this.knnResults != null && this.knnResults.size() > 1) {
                    throw new IllegalArgumentException("Cannot serialize multiple KNN results to nodes using previous transport version [" + out.getTransportVersion().toReleaseVersion() + "], minimum required transport version is [" + TransportVersions.V_8_7_0.toReleaseVersion() + "]");
                }
                out.writeOptionalWriteable(this.knnResults == null || this.knnResults.isEmpty() ? null : (Writeable)this.knnResults.get(0));
            }
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_6_0)) {
            out.writeOptionalWriteable(this.searchProfileDfsPhaseResult);
        }
    }

    public static void writeFieldStats(StreamOutput out, Map<String, CollectionStatistics> fieldStatistics) throws IOException {
        out.writeMap(fieldStatistics, (o, statistics) -> {
            assert (statistics.maxDoc() >= 0L);
            o.writeVLong(statistics.maxDoc());
            o.writeVLong(statistics.docCount());
            o.writeVLong(statistics.sumTotalTermFreq());
            o.writeVLong(statistics.sumDocFreq());
        });
    }

    public static void writeTermStats(StreamOutput out, TermStatistics[] termStatistics) throws IOException {
        out.writeArray(DfsSearchResult::writeSingleTermStats, termStatistics);
    }

    public static void writeSingleTermStats(StreamOutput out, TermStatistics termStatistic) throws IOException {
        if (termStatistic != null) {
            assert (termStatistic.docFreq() > 0L);
            out.writeVLong(termStatistic.docFreq());
            out.writeVLong(DfsSearchResult.addOne(termStatistic.totalTermFreq()));
        } else {
            out.writeVLong(0L);
            out.writeVLong(0L);
        }
    }

    static Map<String, CollectionStatistics> readFieldStats(StreamInput in) throws IOException {
        int numFieldStatistics = in.readVInt();
        HashMap<String, CollectionStatistics> fieldStatistics = new HashMap<String, CollectionStatistics>(numFieldStatistics);
        for (int i = 0; i < numFieldStatistics; ++i) {
            String field = in.readString();
            assert (field != null);
            long maxDoc = in.readVLong();
            long docCount = in.readVLong();
            long sumTotalTermFreq = in.readVLong();
            long sumDocFreq = in.readVLong();
            CollectionStatistics stats = new CollectionStatistics(field, maxDoc, docCount, sumTotalTermFreq, sumDocFreq);
            fieldStatistics.put(field, stats);
        }
        return fieldStatistics;
    }

    static TermStatistics[] readTermStats(StreamInput in, Term[] terms) throws IOException {
        TermStatistics[] termStatistics;
        int termsStatsSize = in.readVInt();
        if (termsStatsSize == 0) {
            termStatistics = EMPTY_TERM_STATS;
        } else {
            termStatistics = new TermStatistics[termsStatsSize];
            assert (terms.length == termsStatsSize);
            for (int i = 0; i < termStatistics.length; ++i) {
                BytesRef term = terms[i].bytes();
                long docFreq = in.readVLong();
                assert (docFreq >= 0L);
                long totalTermFreq = DfsSearchResult.subOne(in.readVLong());
                if (docFreq == 0L) continue;
                termStatistics[i] = new TermStatistics(term, docFreq, totalTermFreq);
            }
        }
        return termStatistics;
    }

    public static long addOne(long value) {
        assert (value + 1L >= 0L);
        return value + 1L;
    }

    public static long subOne(long value) {
        assert (value >= 0L);
        return value - 1L;
    }
}

