/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import com.carrotsearch.hppc.BitMixer;
import org.elasticsearch.common.util.AbstractHash;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.core.Releasables;

public final class IntNHash
extends AbstractHash {
    private IntArray keyArray;
    private final int keySize;
    private final int[] scratch;

    public IntNHash(long capacity, int keySize, BigArrays bigArrays) {
        this(capacity, keySize, 0.6f, bigArrays);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntNHash(long capacity, int keySize, float maxLoadFactor, BigArrays bigArrays) {
        super(capacity, maxLoadFactor, bigArrays);
        this.keySize = keySize;
        this.scratch = new int[keySize];
        try {
            this.keyArray = bigArrays.newIntArray((long)keySize * capacity, false);
        }
        finally {
            if (this.keyArray == null) {
                this.close();
            }
        }
    }

    public int[] getKeys(long id) {
        this.getKeys(id, this.scratch);
        return this.scratch;
    }

    public void getKeys(long id, int[] dst) {
        assert (dst.length == this.keySize);
        for (int i = 0; i < this.keySize; ++i) {
            dst[i] = this.keyArray.get((long)this.keySize * id + (long)i);
        }
    }

    private boolean keyEquals(long id, int[] keys) {
        long keyOffset = (long)this.keySize * id;
        for (int i = 0; i < keys.length; ++i) {
            if (this.keyArray.get(keyOffset + (long)i) == keys[i]) continue;
            return false;
        }
        return true;
    }

    public long find(int[] keys) {
        long slot;
        long index = slot = IntNHash.slot(IntNHash.hash(keys), this.mask);
        long id;
        while ((id = this.id(index)) != -1L) {
            if (this.keyEquals(id, keys)) {
                return id;
            }
            index = IntNHash.nextSlot(index, this.mask);
        }
        return id;
    }

    private long set(long id, int[] keys) {
        long slot;
        assert (this.size < this.maxSize);
        long index = slot = IntNHash.slot(IntNHash.hash(keys), this.mask);
        while (true) {
            long curId;
            if ((curId = this.id(index)) == -1L) {
                this.setId(index, id);
                this.append(id, keys);
                ++this.size;
                return id;
            }
            if (this.keyEquals(curId, keys)) {
                return -1L - curId;
            }
            index = IntNHash.nextSlot(index, this.mask);
        }
    }

    private void append(long id, int[] keys) {
        long keyOffset = (long)this.keySize * id;
        this.keyArray = this.bigArrays.grow(this.keyArray, keyOffset + (long)this.keySize);
        for (int i = 0; i < keys.length; ++i) {
            this.keyArray.set(keyOffset + (long)i, keys[i]);
        }
    }

    private void reset(long id) {
        long slot;
        long index = slot = IntNHash.slot(this.hashFromKeyArray(id), this.mask);
        while (true) {
            long curId;
            if ((curId = this.id(index)) == -1L) break;
            index = IntNHash.nextSlot(index, this.mask);
        }
        this.setId(index, id);
    }

    public long add(int[] keys) {
        if (this.size >= this.maxSize) {
            assert (this.size == this.maxSize);
            this.grow();
        }
        assert (this.size < this.maxSize);
        return this.set(this.size, keys);
    }

    @Override
    protected void removeAndAdd(long index) {
        long id = this.getAndSetId(index, -1L);
        assert (id >= 0L);
        this.reset(id);
    }

    @Override
    public void close() {
        Releasables.close(this.keyArray, () -> super.close());
    }

    static long hash(int[] keys) {
        long hash = BitMixer.mix((int)keys[0]);
        for (int i = 1; i < keys.length; ++i) {
            hash = 31L * hash + (long)BitMixer.mix((int)keys[i]);
        }
        return hash;
    }

    long hashFromKeyArray(long id) {
        long keyOffset = id * (long)this.keySize;
        long hash = BitMixer.mix((int)this.keyArray.get(keyOffset));
        for (int i = 1; i < this.keySize; ++i) {
            hash = 31L * hash + (long)BitMixer.mix((int)this.keyArray.get(keyOffset + (long)i));
        }
        return hash;
    }
}

