/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.unit;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class Processors
implements Writeable,
Comparable<Processors>,
ToXContentFragment {
    public static final Processors ZERO = new Processors(0.0);
    public static final Processors MAX_PROCESSORS = new Processors(Double.MAX_VALUE);
    public static final TransportVersion FLOAT_PROCESSORS_SUPPORT_TRANSPORT_VERSION = TransportVersions.V_8_3_0;
    public static final TransportVersion DOUBLE_PROCESSORS_SUPPORT_TRANSPORT_VERSION = TransportVersions.V_8_5_0;
    static final int NUMBER_OF_DECIMAL_PLACES = 5;
    private static final double MIN_REPRESENTABLE_PROCESSORS = 1.0E-5;
    private final double count;

    private Processors(double count) {
        this.count = count == 0.0 ? count : Math.max(1.0E-5, new BigDecimal(count).setScale(5, RoundingMode.HALF_UP).doubleValue());
    }

    @Nullable
    public static Processors of(Double count) {
        if (count == null) {
            return null;
        }
        if (!Processors.validNumberOfProcessors(count)) {
            throw new IllegalArgumentException("processors must be a positive number; provided [" + count + "]");
        }
        return new Processors(count);
    }

    public static Processors readFrom(StreamInput in) throws IOException {
        double processorCount = in.getTransportVersion().before(FLOAT_PROCESSORS_SUPPORT_TRANSPORT_VERSION) ? (double)in.readInt() : (in.getTransportVersion().before(DOUBLE_PROCESSORS_SUPPORT_TRANSPORT_VERSION) ? (double)in.readFloat() : in.readDouble());
        return new Processors(processorCount);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().before(FLOAT_PROCESSORS_SUPPORT_TRANSPORT_VERSION)) {
            assert (!this.hasDecimals());
            out.writeInt((int)this.count);
        } else if (out.getTransportVersion().before(DOUBLE_PROCESSORS_SUPPORT_TRANSPORT_VERSION)) {
            out.writeFloat((float)this.count);
        } else {
            out.writeDouble(this.count);
        }
    }

    @Nullable
    public static Processors fromXContent(XContentParser parser) throws IOException {
        double count = parser.doubleValue();
        if (!Processors.validNumberOfProcessors(count)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Only a positive number of [%s] are allowed and [%f] was provided", parser.currentName(), count));
        }
        return new Processors(count);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.value(this.count);
    }

    public Processors plus(Processors other) {
        double newProcessorCount = this.count + other.count;
        if (!Double.isFinite(newProcessorCount)) {
            throw new ArithmeticException("Unable to add [" + String.valueOf(this) + "] and [" + String.valueOf(other) + "] the resulting value overflows");
        }
        return new Processors(newProcessorCount);
    }

    public Processors multiply(int value) {
        if (value <= 0) {
            throw new IllegalArgumentException("Processors cannot be multiplied by a negative number");
        }
        double newProcessorCount = this.count * (double)value;
        if (!Double.isFinite(newProcessorCount)) {
            throw new ArithmeticException("Unable to multiply [" + String.valueOf(this) + "] by [" + value + "] the resulting value overflows");
        }
        return new Processors(newProcessorCount);
    }

    public double count() {
        return this.count;
    }

    public int roundUp() {
        return (int)Math.ceil(this.count);
    }

    public int roundDown() {
        return Math.max(1, (int)Math.floor(this.count));
    }

    private static boolean validNumberOfProcessors(double processors) {
        return Double.isFinite(processors) && processors > 0.0;
    }

    public boolean hasDecimals() {
        return (double)((int)this.count) != Math.ceil(this.count);
    }

    @Override
    public int compareTo(Processors o) {
        return Double.compare(this.count, o.count);
    }

    public static boolean equalsOrCloseTo(Processors a, Processors b) {
        return a == b || a != null && (a.equals(b) || a.closeToAsFloat(b));
    }

    private boolean closeToAsFloat(Processors b) {
        if (b == null) {
            return false;
        }
        float floatCount = (float)this.count;
        float otherFloatCount = (float)b.count;
        float maxError = Math.max(Math.ulp(floatCount), Math.ulp(otherFloatCount)) + 1.0E-5f;
        return Float.isFinite(floatCount) && Float.isFinite(otherFloatCount) && Math.abs(floatCount - otherFloatCount) < maxError;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Processors that = (Processors)o;
        return Double.compare(that.count, this.count) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.count);
    }

    public String toString() {
        return Double.toString(this.count);
    }
}

