/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopFieldDocs;
import org.elasticsearch.core.Types;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.SearchSortValuesAndFormats;

class BottomSortValuesCollector {
    private final int topNSize;
    private final SortField[] sortFields;
    private final FieldComparator<?>[] comparators;
    private final int[] reverseMuls;
    private volatile long totalHits;
    private volatile SearchSortValuesAndFormats bottomSortValues;

    BottomSortValuesCollector(int topNSize, SortField[] sortFields) {
        this.topNSize = topNSize;
        this.comparators = new FieldComparator[sortFields.length];
        this.reverseMuls = new int[sortFields.length];
        this.sortFields = sortFields;
        for (int i = 0; i < sortFields.length; ++i) {
            this.comparators[i] = sortFields[i].getComparator(1, Pruning.NONE);
            this.reverseMuls[i] = sortFields[i].getReverse() ? -1 : 1;
        }
    }

    long getTotalHits() {
        return this.totalHits;
    }

    SearchSortValuesAndFormats getBottomSortValues() {
        return this.bottomSortValues;
    }

    synchronized void consumeTopDocs(TopFieldDocs topDocs, DocValueFormat[] sortValuesFormat) {
        this.totalHits += topDocs.totalHits.value();
        if (!this.validateShardSortFields(topDocs.fields)) {
            return;
        }
        FieldDoc shardBottomDoc = this.extractBottom(topDocs);
        if (shardBottomDoc == null) {
            return;
        }
        if (this.bottomSortValues == null || this.compareValues(shardBottomDoc.fields, this.bottomSortValues.getRawSortValues()) < 0) {
            this.bottomSortValues = new SearchSortValuesAndFormats(shardBottomDoc.fields, sortValuesFormat);
        }
    }

    private boolean validateShardSortFields(SortField[] shardSortFields) {
        for (int i = 0; i < shardSortFields.length; ++i) {
            if (shardSortFields[i].equals(this.sortFields[i])) continue;
            return false;
        }
        return true;
    }

    private FieldDoc extractBottom(TopFieldDocs topDocs) {
        return this.topNSize > 0 && topDocs.scoreDocs.length == this.topNSize ? (FieldDoc)topDocs.scoreDocs[this.topNSize - 1] : null;
    }

    private int compareValues(Object[] v1, Object[] v2) {
        for (int i = 0; i < v1.length; ++i) {
            int cmp = this.reverseMuls[i] * this.comparators[i].compareValues(Types.forciblyCast(v1[i]), Types.forciblyCast(v2[i]));
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }
}

