/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.PassphraseEncryptedOutputStreamProperties;
import com.unboundid.util.PassphraseEncryptedStreamHeader;
import com.unboundid.util.PassphraseEncryptionCipherType;
import com.unboundid.util.ThreadLocalSecureRandom;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class PassphraseEncryptedOutputStream
extends OutputStream {
    @NotNull
    private final CipherOutputStream cipherOutputStream;
    @NotNull
    private final PassphraseEncryptedStreamHeader encryptionHeader;

    public PassphraseEncryptedOutputStream(@NotNull String passphrase, @NotNull OutputStream wrappedOutputStream) throws GeneralSecurityException, IOException {
        this(passphrase.toCharArray(), wrappedOutputStream);
    }

    public PassphraseEncryptedOutputStream(@NotNull char[] passphrase, @NotNull OutputStream wrappedOutputStream) throws GeneralSecurityException, IOException {
        this(passphrase, wrappedOutputStream, null, false, true);
    }

    public PassphraseEncryptedOutputStream(@NotNull String passphrase, @NotNull OutputStream wrappedOutputStream, @Nullable String keyIdentifier, boolean useStrongEncryption, boolean writeHeaderToStream) throws GeneralSecurityException, IOException {
        this(passphrase.toCharArray(), wrappedOutputStream, keyIdentifier, useStrongEncryption, writeHeaderToStream);
    }

    public PassphraseEncryptedOutputStream(@NotNull char[] passphrase, @NotNull OutputStream wrappedOutputStream, @Nullable String keyIdentifier, boolean useStrongEncryption, boolean writeHeaderToStream) throws GeneralSecurityException, IOException {
        this(passphrase, wrappedOutputStream, PassphraseEncryptedOutputStream.generateProperties(keyIdentifier, useStrongEncryption, null, writeHeaderToStream));
    }

    public PassphraseEncryptedOutputStream(@NotNull String passphrase, @NotNull OutputStream wrappedOutputStream, @Nullable String keyIdentifier, boolean useStrongEncryption, int keyFactoryIterationCount, boolean writeHeaderToStream) throws GeneralSecurityException, IOException {
        this(passphrase.toCharArray(), wrappedOutputStream, keyIdentifier, useStrongEncryption, keyFactoryIterationCount, writeHeaderToStream);
    }

    public PassphraseEncryptedOutputStream(@NotNull char[] passphrase, @NotNull OutputStream wrappedOutputStream, @Nullable String keyIdentifier, boolean useStrongEncryption, int keyFactoryIterationCount, boolean writeHeaderToStream) throws GeneralSecurityException, IOException {
        this(passphrase, wrappedOutputStream, PassphraseEncryptedOutputStream.generateProperties(keyIdentifier, useStrongEncryption, keyFactoryIterationCount, writeHeaderToStream));
    }

    @NotNull
    private static PassphraseEncryptedOutputStreamProperties generateProperties(@Nullable String keyIdentifier, boolean useStrongEncryption, @Nullable Integer keyFactoryIterationCount, boolean writeHeaderToStream) {
        PassphraseEncryptedOutputStreamProperties properties = useStrongEncryption ? new PassphraseEncryptedOutputStreamProperties(PassphraseEncryptionCipherType.getStrongestAvailableCipherType()) : new PassphraseEncryptedOutputStreamProperties(PassphraseEncryptionCipherType.AES_128);
        properties.setKeyIdentifier(keyIdentifier);
        properties.setWriteHeaderToStream(writeHeaderToStream);
        if (keyFactoryIterationCount != null) {
            properties.setKeyFactoryIterationCount(keyFactoryIterationCount);
        }
        return properties;
    }

    public PassphraseEncryptedOutputStream(@NotNull String passphrase, @NotNull OutputStream wrappedOutputStream, @NotNull PassphraseEncryptedOutputStreamProperties properties) throws GeneralSecurityException, IOException {
        this(passphrase.toCharArray(), wrappedOutputStream, properties);
    }

    public PassphraseEncryptedOutputStream(@NotNull char[] passphrase, @NotNull OutputStream wrappedOutputStream, @NotNull PassphraseEncryptedOutputStreamProperties properties) throws GeneralSecurityException, IOException {
        SecureRandom random = ThreadLocalSecureRandom.get();
        PassphraseEncryptionCipherType cipherType = properties.getCipherType();
        byte[] keyFactorySalt = new byte[cipherType.getKeyFactorySaltLengthBytes()];
        random.nextBytes(keyFactorySalt);
        byte[] cipherInitializationVector = new byte[cipherType.getInitializationVectorLengthBytes()];
        random.nextBytes(cipherInitializationVector);
        this.encryptionHeader = new PassphraseEncryptedStreamHeader(passphrase, cipherType.getKeyFactoryAlgorithm(), properties.getKeyFactoryIterationCount(), keyFactorySalt, cipherType.getKeyLengthBits(), cipherType.getCipherTransformation(), cipherInitializationVector, properties.getKeyIdentifier(), cipherType.getMacAlgorithm());
        Cipher cipher = this.encryptionHeader.createCipher(1);
        if (properties.writeHeaderToStream()) {
            this.encryptionHeader.writeTo(wrappedOutputStream);
        }
        this.cipherOutputStream = new CipherOutputStream(wrappedOutputStream, cipher);
    }

    @Override
    public void write(int b) throws IOException {
        this.cipherOutputStream.write(b);
    }

    @Override
    public void write(@NotNull byte[] b) throws IOException {
        this.cipherOutputStream.write(b);
    }

    @Override
    public void write(@NotNull byte[] b, int offset, int length) throws IOException {
        this.cipherOutputStream.write(b, offset, length);
    }

    @Override
    public void flush() throws IOException {
        this.cipherOutputStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.cipherOutputStream.close();
    }

    @NotNull
    public PassphraseEncryptedStreamHeader getEncryptionHeader() {
        return this.encryptionHeader;
    }
}

