/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.text_structure;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.text_structure.EcsCompatibilityType;
import co.elastic.clients.elasticsearch.text_structure.FindMessageStructureResponse;
import co.elastic.clients.elasticsearch.text_structure.FormatType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class FindMessageStructureRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String columnNames;
    @Nullable
    private final String delimiter;
    @Nullable
    private final EcsCompatibilityType ecsCompatibility;
    @Nullable
    private final Boolean explain;
    @Nullable
    private final FormatType format;
    @Nullable
    private final String grokPattern;
    private final List<String> messages;
    @Nullable
    private final String quote;
    @Nullable
    private final Boolean shouldTrimFields;
    @Nullable
    private final Time timeout;
    @Nullable
    private final String timestampField;
    @Nullable
    private final String timestampFormat;
    public static final JsonpDeserializer<FindMessageStructureRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FindMessageStructureRequest::setupFindMessageStructureRequestDeserializer);
    public static final Endpoint<FindMessageStructureRequest, FindMessageStructureResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<FindMessageStructureRequest, FindMessageStructureResponse>("es/text_structure.find_message_structure", request -> "POST", request -> "/_text_structure/find_message_structure", request -> Collections.emptyMap(), request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.explain != null) {
            params.put("explain", String.valueOf(request.explain));
        }
        if (request.timestampFormat != null) {
            params.put("timestamp_format", request.timestampFormat);
        }
        if (request.quote != null) {
            params.put("quote", request.quote);
        }
        if (request.shouldTrimFields != null) {
            params.put("should_trim_fields", String.valueOf(request.shouldTrimFields));
        }
        if (request.grokPattern != null) {
            params.put("grok_pattern", request.grokPattern);
        }
        if (request.delimiter != null) {
            params.put("delimiter", request.delimiter);
        }
        if (request.format != null) {
            params.put("format", request.format.jsonValue());
        }
        if (request.columnNames != null) {
            params.put("column_names", request.columnNames);
        }
        if (request.timestampField != null) {
            params.put("timestamp_field", request.timestampField);
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        if (request.ecsCompatibility != null) {
            params.put("ecs_compatibility", request.ecsCompatibility.jsonValue());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, FindMessageStructureResponse._DESERIALIZER);

    private FindMessageStructureRequest(Builder builder) {
        this.columnNames = builder.columnNames;
        this.delimiter = builder.delimiter;
        this.ecsCompatibility = builder.ecsCompatibility;
        this.explain = builder.explain;
        this.format = builder.format;
        this.grokPattern = builder.grokPattern;
        this.messages = ApiTypeHelper.unmodifiableRequired(builder.messages, (Object)this, "messages");
        this.quote = builder.quote;
        this.shouldTrimFields = builder.shouldTrimFields;
        this.timeout = builder.timeout;
        this.timestampField = builder.timestampField;
        this.timestampFormat = builder.timestampFormat;
    }

    public static FindMessageStructureRequest of(Function<Builder, ObjectBuilder<FindMessageStructureRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String columnNames() {
        return this.columnNames;
    }

    @Nullable
    public final String delimiter() {
        return this.delimiter;
    }

    @Nullable
    public final EcsCompatibilityType ecsCompatibility() {
        return this.ecsCompatibility;
    }

    @Nullable
    public final Boolean explain() {
        return this.explain;
    }

    @Nullable
    public final FormatType format() {
        return this.format;
    }

    @Nullable
    public final String grokPattern() {
        return this.grokPattern;
    }

    public final List<String> messages() {
        return this.messages;
    }

    @Nullable
    public final String quote() {
        return this.quote;
    }

    @Nullable
    public final Boolean shouldTrimFields() {
        return this.shouldTrimFields;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Nullable
    public final String timestampField() {
        return this.timestampField;
    }

    @Nullable
    public final String timestampFormat() {
        return this.timestampFormat;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.messages)) {
            generator.writeKey("messages");
            generator.writeStartArray();
            for (String item0 : this.messages) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    protected static void setupFindMessageStructureRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::messages, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "messages");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<FindMessageStructureRequest> {
        @Nullable
        private String columnNames;
        @Nullable
        private String delimiter;
        @Nullable
        private EcsCompatibilityType ecsCompatibility;
        @Nullable
        private Boolean explain;
        @Nullable
        private FormatType format;
        @Nullable
        private String grokPattern;
        private List<String> messages;
        @Nullable
        private String quote;
        @Nullable
        private Boolean shouldTrimFields;
        @Nullable
        private Time timeout;
        @Nullable
        private String timestampField;
        @Nullable
        private String timestampFormat;

        public final Builder columnNames(@Nullable String value) {
            this.columnNames = value;
            return this;
        }

        public final Builder delimiter(@Nullable String value) {
            this.delimiter = value;
            return this;
        }

        public final Builder ecsCompatibility(@Nullable EcsCompatibilityType value) {
            this.ecsCompatibility = value;
            return this;
        }

        public final Builder explain(@Nullable Boolean value) {
            this.explain = value;
            return this;
        }

        public final Builder format(@Nullable FormatType value) {
            this.format = value;
            return this;
        }

        public final Builder grokPattern(@Nullable String value) {
            this.grokPattern = value;
            return this;
        }

        public final Builder messages(List<String> list) {
            this.messages = Builder._listAddAll(this.messages, list);
            return this;
        }

        public final Builder messages(String value, String ... values) {
            this.messages = Builder._listAdd(this.messages, value, values);
            return this;
        }

        public final Builder quote(@Nullable String value) {
            this.quote = value;
            return this;
        }

        public final Builder shouldTrimFields(@Nullable Boolean value) {
            this.shouldTrimFields = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder timestampField(@Nullable String value) {
            this.timestampField = value;
            return this;
        }

        public final Builder timestampFormat(@Nullable String value) {
            this.timestampFormat = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FindMessageStructureRequest build() {
            this._checkSingleUse();
            return new FindMessageStructureRequest(this);
        }
    }
}

