/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.elasticsearch.cluster.stats.FieldTypes;
import co.elastic.clients.elasticsearch.cluster.stats.RuntimeFieldTypes;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class FieldTypesMappings
implements JsonpSerializable {
    private final List<FieldTypes> fieldTypes;
    private final List<RuntimeFieldTypes> runtimeFieldTypes;
    @Nullable
    private final Long totalFieldCount;
    @Nullable
    private final Long totalDeduplicatedFieldCount;
    @Nullable
    private final String totalDeduplicatedMappingSize;
    @Nullable
    private final Long totalDeduplicatedMappingSizeInBytes;
    private final Map<String, Integer> sourceModes;
    public static final JsonpDeserializer<FieldTypesMappings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FieldTypesMappings::setupFieldTypesMappingsDeserializer);

    private FieldTypesMappings(Builder builder) {
        this.fieldTypes = ApiTypeHelper.unmodifiableRequired(builder.fieldTypes, (Object)this, "fieldTypes");
        this.runtimeFieldTypes = ApiTypeHelper.unmodifiableRequired(builder.runtimeFieldTypes, (Object)this, "runtimeFieldTypes");
        this.totalFieldCount = builder.totalFieldCount;
        this.totalDeduplicatedFieldCount = builder.totalDeduplicatedFieldCount;
        this.totalDeduplicatedMappingSize = builder.totalDeduplicatedMappingSize;
        this.totalDeduplicatedMappingSizeInBytes = builder.totalDeduplicatedMappingSizeInBytes;
        this.sourceModes = ApiTypeHelper.unmodifiableRequired(builder.sourceModes, (Object)this, "sourceModes");
    }

    public static FieldTypesMappings of(Function<Builder, ObjectBuilder<FieldTypesMappings>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<FieldTypes> fieldTypes() {
        return this.fieldTypes;
    }

    public final List<RuntimeFieldTypes> runtimeFieldTypes() {
        return this.runtimeFieldTypes;
    }

    @Nullable
    public final Long totalFieldCount() {
        return this.totalFieldCount;
    }

    @Nullable
    public final Long totalDeduplicatedFieldCount() {
        return this.totalDeduplicatedFieldCount;
    }

    @Nullable
    public final String totalDeduplicatedMappingSize() {
        return this.totalDeduplicatedMappingSize;
    }

    @Nullable
    public final Long totalDeduplicatedMappingSizeInBytes() {
        return this.totalDeduplicatedMappingSizeInBytes;
    }

    public final Map<String, Integer> sourceModes() {
        return this.sourceModes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.fieldTypes)) {
            generator.writeKey("field_types");
            generator.writeStartArray();
            for (FieldTypes fieldTypes : this.fieldTypes) {
                fieldTypes.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.runtimeFieldTypes)) {
            generator.writeKey("runtime_field_types");
            generator.writeStartArray();
            for (RuntimeFieldTypes runtimeFieldTypes : this.runtimeFieldTypes) {
                runtimeFieldTypes.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.totalFieldCount != null) {
            generator.writeKey("total_field_count");
            generator.write(this.totalFieldCount);
        }
        if (this.totalDeduplicatedFieldCount != null) {
            generator.writeKey("total_deduplicated_field_count");
            generator.write(this.totalDeduplicatedFieldCount);
        }
        if (this.totalDeduplicatedMappingSize != null) {
            generator.writeKey("total_deduplicated_mapping_size");
            generator.write(this.totalDeduplicatedMappingSize);
        }
        if (this.totalDeduplicatedMappingSizeInBytes != null) {
            generator.writeKey("total_deduplicated_mapping_size_in_bytes");
            generator.write(this.totalDeduplicatedMappingSizeInBytes);
        }
        if (ApiTypeHelper.isDefined(this.sourceModes)) {
            generator.writeKey("source_modes");
            generator.writeStartObject();
            for (Map.Entry entry : this.sourceModes.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.write((Integer)entry.getValue());
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupFieldTypesMappingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::fieldTypes, JsonpDeserializer.arrayDeserializer(FieldTypes._DESERIALIZER), "field_types");
        op.add(Builder::runtimeFieldTypes, JsonpDeserializer.arrayDeserializer(RuntimeFieldTypes._DESERIALIZER), "runtime_field_types");
        op.add(Builder::totalFieldCount, JsonpDeserializer.longDeserializer(), "total_field_count");
        op.add(Builder::totalDeduplicatedFieldCount, JsonpDeserializer.longDeserializer(), "total_deduplicated_field_count");
        op.add(Builder::totalDeduplicatedMappingSize, JsonpDeserializer.stringDeserializer(), "total_deduplicated_mapping_size");
        op.add(Builder::totalDeduplicatedMappingSizeInBytes, JsonpDeserializer.longDeserializer(), "total_deduplicated_mapping_size_in_bytes");
        op.add(Builder::sourceModes, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.integerDeserializer()), "source_modes");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<FieldTypesMappings> {
        private List<FieldTypes> fieldTypes;
        private List<RuntimeFieldTypes> runtimeFieldTypes;
        @Nullable
        private Long totalFieldCount;
        @Nullable
        private Long totalDeduplicatedFieldCount;
        @Nullable
        private String totalDeduplicatedMappingSize;
        @Nullable
        private Long totalDeduplicatedMappingSizeInBytes;
        private Map<String, Integer> sourceModes;

        public final Builder fieldTypes(List<FieldTypes> list) {
            this.fieldTypes = Builder._listAddAll(this.fieldTypes, list);
            return this;
        }

        public final Builder fieldTypes(FieldTypes value, FieldTypes ... values) {
            this.fieldTypes = Builder._listAdd(this.fieldTypes, value, values);
            return this;
        }

        public final Builder fieldTypes(Function<FieldTypes.Builder, ObjectBuilder<FieldTypes>> fn) {
            return this.fieldTypes(fn.apply(new FieldTypes.Builder()).build(), new FieldTypes[0]);
        }

        public final Builder runtimeFieldTypes(List<RuntimeFieldTypes> list) {
            this.runtimeFieldTypes = Builder._listAddAll(this.runtimeFieldTypes, list);
            return this;
        }

        public final Builder runtimeFieldTypes(RuntimeFieldTypes value, RuntimeFieldTypes ... values) {
            this.runtimeFieldTypes = Builder._listAdd(this.runtimeFieldTypes, value, values);
            return this;
        }

        public final Builder runtimeFieldTypes(Function<RuntimeFieldTypes.Builder, ObjectBuilder<RuntimeFieldTypes>> fn) {
            return this.runtimeFieldTypes(fn.apply(new RuntimeFieldTypes.Builder()).build(), new RuntimeFieldTypes[0]);
        }

        public final Builder totalFieldCount(@Nullable Long value) {
            this.totalFieldCount = value;
            return this;
        }

        public final Builder totalDeduplicatedFieldCount(@Nullable Long value) {
            this.totalDeduplicatedFieldCount = value;
            return this;
        }

        public final Builder totalDeduplicatedMappingSize(@Nullable String value) {
            this.totalDeduplicatedMappingSize = value;
            return this;
        }

        public final Builder totalDeduplicatedMappingSizeInBytes(@Nullable Long value) {
            this.totalDeduplicatedMappingSizeInBytes = value;
            return this;
        }

        public final Builder sourceModes(Map<String, Integer> map) {
            this.sourceModes = Builder._mapPutAll(this.sourceModes, map);
            return this;
        }

        public final Builder sourceModes(String key, Integer value) {
            this.sourceModes = Builder._mapPut(this.sourceModes, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FieldTypesMappings build() {
            this._checkSingleUse();
            return new FieldTypesMappings(this);
        }
    }
}

