/*
 * Decompiled with CFR 0.152.
 */
package json.ext;

import java.io.IOException;
import json.ext.AbstractByteListDirectOutputStream;
import org.jcodings.Encoding;
import org.jruby.util.ByteList;

public class SegmentedByteListDirectOutputStream
extends AbstractByteListDirectOutputStream {
    private static final int DEFAULT_CAPACITY = 1024;
    private int totalLength;
    private byte[][] segments = new byte[21][];
    private int currentSegmentIndex;
    private int currentSegmentLength;
    private byte[] currentSegment;

    SegmentedByteListDirectOutputStream(int n) {
        this.currentSegment = new byte[Math.max(n, 1024)];
        this.segments[0] = this.currentSegment;
    }

    @Override
    public ByteList toByteListDirect(Encoding encoding) {
        byte[] byArray = new byte[this.totalLength];
        int n = 0;
        for (int i = 0; i < this.currentSegmentIndex; ++i) {
            byte[] byArray2 = this.segments[i];
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
            n += byArray2.length;
        }
        System.arraycopy(this.currentSegment, 0, byArray, n, this.currentSegmentLength);
        return new ByteList(byArray, 0, this.totalLength, encoding, false);
    }

    @Override
    public void write(int n) throws IOException {
        if (this.currentSegmentLength == this.currentSegment.length) {
            if (this.totalLength + 1 < 0) {
                throw new IOException("Total length exceeds maximum length of an array.");
            }
            ++this.currentSegmentIndex;
            int n2 = this.currentSegment.length * 2;
            n2 = n2 < 0 ? 1024 : n2;
            this.currentSegment = new byte[n2];
            this.currentSegmentLength = 0;
            this.segments[this.currentSegmentIndex] = this.currentSegment;
        }
        this.currentSegment[this.currentSegmentLength++] = (byte)n;
        ++this.totalLength;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        for (int i = n2; i > 0; i -= n3) {
            if (this.currentSegmentLength == this.currentSegment.length) {
                if (this.totalLength + i < 0) {
                    throw new IOException("Total length exceeds maximum length of an array.");
                }
                ++this.currentSegmentIndex;
                n3 = this.currentSegment.length << 1;
                n3 = n3 < 0 ? 1024 : n3;
                n3 = n3 < i ? i : n3;
                this.currentSegment = new byte[n3];
                this.currentSegmentLength = 0;
                this.segments[this.currentSegmentIndex] = this.currentSegment;
            }
            n3 = Math.min(i, this.currentSegment.length - this.currentSegmentLength);
            System.arraycopy(byArray, n, this.currentSegment, this.currentSegmentLength, n3);
            this.currentSegmentLength += n3;
            n += n3;
        }
        this.totalLength += n2;
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }
}

