/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.stats;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class GetSecurityStatsNodeResponse
extends BaseNodeResponse
implements ToXContentObject {
    private static final TransportVersion ROLES_SECURITY_STATS = TransportVersion.fromName("roles_security_stats");
    @Nullable
    private final Map<String, Object> rolesStoreStats;

    public GetSecurityStatsNodeResponse(StreamInput in) throws IOException {
        super(in);
        this.rolesStoreStats = in.getTransportVersion().supports(ROLES_SECURITY_STATS) ? in.readGenericMap() : null;
    }

    public GetSecurityStatsNodeResponse(DiscoveryNode node, @Nullable Map<String, Object> rolesStoreStats) {
        super(node);
        this.rolesStoreStats = rolesStoreStats;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getTransportVersion().supports(ROLES_SECURITY_STATS)) {
            out.writeGenericMap(this.rolesStoreStats);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.rolesStoreStats != null) {
            builder.field("roles", this.rolesStoreStats);
        }
        return builder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof GetSecurityStatsNodeResponse)) return false;
        GetSecurityStatsNodeResponse that = (GetSecurityStatsNodeResponse)o;
        if (!Objects.equals(this.getNode(), that.getNode())) return false;
        if (!Objects.equals(this.rolesStoreStats, that.rolesStoreStats)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.getNode(), this.rolesStoreStats);
    }

    @Nullable
    Map<String, Object> getRolesStoreStats() {
        return this.rolesStoreStats == null ? null : Collections.unmodifiableMap(this.rolesStoreStats);
    }

    DiscoveryNode getDiscoveryNode() {
        return this.getNode();
    }
}

