/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ilm.InitializePolicyContextStep;
import org.elasticsearch.xpack.core.ilm.LifecycleAction;
import org.elasticsearch.xpack.core.ilm.LifecycleType;
import org.elasticsearch.xpack.core.ilm.Phase;
import org.elasticsearch.xpack.core.ilm.PhaseCompleteStep;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.TimeseriesLifecycleType;

public class LifecyclePolicy
implements SimpleDiffable<LifecyclePolicy>,
ToXContentObject {
    private static final int MAX_INDEX_NAME_BYTES = 255;
    public static final ParseField PHASES_FIELD = new ParseField("phases", new String[0]);
    private static final ParseField METADATA = new ParseField("_meta", new String[0]);
    private static final ParseField DEPRECATED = new ParseField("deprecated", new String[0]);
    private static final Step.StepKey NEW_STEP_KEY = new Step.StepKey("new", "complete", "complete");
    public static final ConstructingObjectParser<LifecyclePolicy, String> PARSER = new ConstructingObjectParser<LifecyclePolicy, String>("lifecycle_policy", false, (a, name) -> {
        List phases = (List)a[0];
        Map<String, Phase> phaseMap = phases.stream().collect(Collectors.toMap(Phase::getName, Function.identity()));
        return new LifecyclePolicy(TimeseriesLifecycleType.INSTANCE, (String)name, phaseMap, (Map)a[1], (Boolean)a[2]);
    });
    private final String name;
    private final LifecycleType type;
    private final Map<String, Phase> phases;
    @Nullable
    private final Map<String, Object> metadata;
    @Nullable
    private final Boolean deprecated;

    public LifecyclePolicy(String name, Map<String, Phase> phases) {
        this(TimeseriesLifecycleType.INSTANCE, name, phases, null, null);
    }

    public LifecyclePolicy(LifecycleType type, String name, Map<String, Phase> phases, @Nullable Map<String, Object> metadata) {
        this(type, name, phases, metadata, null);
    }

    public LifecyclePolicy(StreamInput in) throws IOException {
        this.type = in.readNamedWriteable(LifecycleType.class);
        this.name = in.readString();
        this.phases = in.readImmutableMap(Phase::new);
        this.metadata = in.readGenericMap();
        this.deprecated = in.getTransportVersion().onOrAfter(TransportVersions.V_8_12_0) ? in.readOptionalBoolean() : null;
    }

    public LifecyclePolicy(LifecycleType type, String name, Map<String, Phase> phases, @Nullable Map<String, Object> metadata, @Nullable Boolean deprecated) {
        this.name = name;
        this.phases = phases;
        this.type = type;
        this.metadata = metadata;
        this.deprecated = deprecated;
    }

    public void validate() {
        this.type.validate(this.phases.values());
    }

    public static LifecyclePolicy parse(XContentParser parser, String name) {
        return PARSER.apply(parser, name);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.type);
        out.writeString(this.name);
        out.writeMap(this.phases, StreamOutput::writeWriteable);
        out.writeGenericMap(this.metadata);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_12_0)) {
            out.writeOptionalBoolean(this.deprecated);
        }
    }

    public String getName() {
        return this.name;
    }

    public LifecycleType getType() {
        return this.type;
    }

    public Map<String, Phase> getPhases() {
        return this.phases;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public boolean isDeprecated() {
        return Boolean.TRUE.equals(this.deprecated);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(PHASES_FIELD.getPreferredName());
        for (Phase phase : this.phases.values()) {
            builder.field(phase.getName(), phase);
        }
        builder.endObject();
        if (this.metadata != null) {
            builder.field(METADATA.getPreferredName(), this.metadata);
        }
        if (this.deprecated != null) {
            builder.field(DEPRECATED.getPreferredName(), this.deprecated);
        }
        builder.endObject();
        return builder;
    }

    public List<Step> toSteps(Client client, XPackLicenseState licenseState) {
        ArrayList<Step> steps = new ArrayList<Step>();
        List<Phase> orderedPhases = this.type.getOrderedPhases(this.phases);
        ListIterator<Phase> phaseIterator = orderedPhases.listIterator(orderedPhases.size());
        Step.StepKey lastStepKey = null;
        Phase phase = null;
        while (phaseIterator.hasPrevious()) {
            Phase previousPhase = phaseIterator.previous();
            if (previousPhase != null) {
                Step.StepKey afterStepKey = new Step.StepKey(previousPhase.getName(), "complete", "complete");
                PhaseCompleteStep phaseAfterStep = new PhaseCompleteStep(afterStepKey, lastStepKey);
                steps.add(phaseAfterStep);
                lastStepKey = phaseAfterStep.getKey();
            }
            phase = previousPhase;
            List<LifecycleAction> orderedActions = this.type.getOrderedActions(phase);
            ListIterator<LifecycleAction> actionIterator = orderedActions.listIterator(orderedActions.size());
            while (actionIterator.hasPrevious()) {
                LifecycleAction action = actionIterator.previous();
                List<Step> actionSteps = action.toSteps(client, phase.getName(), lastStepKey, licenseState);
                ListIterator<Step> actionStepsIterator = actionSteps.listIterator(actionSteps.size());
                while (actionStepsIterator.hasPrevious()) {
                    Step step = actionStepsIterator.previous();
                    steps.add(step);
                    lastStepKey = step.getKey();
                }
            }
        }
        PhaseCompleteStep phaseAfterStep = new PhaseCompleteStep(NEW_STEP_KEY, lastStepKey);
        steps.add(phaseAfterStep);
        lastStepKey = phaseAfterStep.getKey();
        steps.add(new InitializePolicyContextStep(InitializePolicyContextStep.KEY, lastStepKey));
        Collections.reverse(steps);
        return steps;
    }

    public boolean isActionSafe(Step.StepKey stepKey) {
        if ("new".equals(stepKey.phase())) {
            return true;
        }
        Phase phase = this.phases.get(stepKey.phase());
        if (phase != null) {
            LifecycleAction action = phase.getActions().get(stepKey.action());
            if (action != null) {
                return action.isSafeAction();
            }
            throw new IllegalArgumentException("Action [" + stepKey.action() + "] in phase [" + stepKey.phase() + "]  does not exist in policy [" + this.name + "]");
        }
        throw new IllegalArgumentException("Phase [" + stepKey.phase() + "]  does not exist in policy [" + this.name + "]");
    }

    public static void validatePolicyName(String policy) {
        if (Strings.isNullOrEmpty(policy)) {
            throw new IllegalArgumentException("invalid policy name [" + policy + "]: must not be null or empty");
        }
        if (policy.contains(",")) {
            throw new IllegalArgumentException("invalid policy name [" + policy + "]: must not contain ','");
        }
        if (policy.contains(" ")) {
            throw new IllegalArgumentException("invalid policy name [" + policy + "]: must not contain spaces");
        }
        if (policy.charAt(0) == '_') {
            throw new IllegalArgumentException("invalid policy name [" + policy + "]: must not start with '_'");
        }
        int byteCount = 0;
        byteCount = policy.getBytes(StandardCharsets.UTF_8).length;
        if (byteCount > 255) {
            throw new IllegalArgumentException("invalid policy name [" + policy + "]: name is too long, (" + byteCount + " > 255)");
        }
    }

    public int hashCode() {
        return Objects.hash(this.name, this.phases, this.metadata, this.deprecated);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        LifecyclePolicy other = (LifecyclePolicy)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.phases, other.phases) && Objects.equals(this.metadata, other.metadata) && Objects.equals(this.deprecated, other.deprecated);
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }

    public boolean maybeAddDeprecationWarningForFreezeAction(String policyName) {
        Phase coldPhase = this.phases.get("cold");
        if (coldPhase != null) {
            return coldPhase.maybeAddDeprecationWarningForFreezeAction(policyName);
        }
        return false;
    }

    static {
        PARSER.declareNamedObjects(ConstructingObjectParser.constructorArg(), (p, c, n) -> Phase.parse(p, n), v -> {
            throw new IllegalArgumentException("ordered " + PHASES_FIELD.getPreferredName() + " are not supported");
        }, PHASES_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), METADATA);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), DEPRECATED);
    }
}

