/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.field.vectors;

import java.io.IOException;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.KnnVectorValues;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.vectors.DenormalizedCosineFloatVectorValues;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.index.mapper.vectors.DenseVectorScriptDocValues;
import org.elasticsearch.script.field.vectors.DenseVector;
import org.elasticsearch.script.field.vectors.DenseVectorDocValuesField;
import org.elasticsearch.script.field.vectors.KnnDenseVector;

public class KnnDenseVectorDocValuesField
extends DenseVectorDocValuesField {
    protected final FloatVectorValues input;
    protected final KnnVectorValues.DocIndexIterator iterator;
    protected float[] vector;
    protected final int dims;

    public KnnDenseVectorDocValuesField(@Nullable FloatVectorValues input, String name, int dims) {
        super(name, DenseVectorFieldMapper.ElementType.FLOAT);
        this.dims = dims;
        this.input = input;
        this.iterator = input == null ? null : input.iterator();
    }

    @Override
    public void setNextDocId(int docId) throws IOException {
        if (this.input == null) {
            return;
        }
        int currentDoc = this.iterator.docID();
        this.vector = (float[])(currentDoc == Integer.MAX_VALUE || docId < currentDoc ? null : (docId == currentDoc ? this.input.vectorValue(this.iterator.index()) : (float[])((currentDoc = this.iterator.advance(docId)) == docId ? this.input.vectorValue(this.iterator.index()) : null)));
    }

    @Override
    public DenseVectorScriptDocValues toScriptDocValues() {
        return new DenseVectorScriptDocValues(this, this.dims);
    }

    @Override
    public boolean isEmpty() {
        return this.vector == null;
    }

    @Override
    public DenseVector get() {
        if (this.isEmpty()) {
            return DenseVector.EMPTY;
        }
        FloatVectorValues floatVectorValues = this.input;
        if (floatVectorValues instanceof DenormalizedCosineFloatVectorValues) {
            DenormalizedCosineFloatVectorValues normalized = (DenormalizedCosineFloatVectorValues)floatVectorValues;
            return new KnnDenseVector(this.vector, normalized.magnitude());
        }
        return new KnnDenseVector(this.vector);
    }

    @Override
    public DenseVector get(DenseVector defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        FloatVectorValues floatVectorValues = this.input;
        if (floatVectorValues instanceof DenormalizedCosineFloatVectorValues) {
            DenormalizedCosineFloatVectorValues normalized = (DenormalizedCosineFloatVectorValues)floatVectorValues;
            return new KnnDenseVector(this.vector, normalized.magnitude());
        }
        return new KnnDenseVector(this.vector);
    }

    @Override
    public DenseVector getInternal() {
        return this.get(null);
    }
}

