/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.util.Objects;
import java.util.function.DoubleConsumer;
import org.elasticsearch.common.Strings;

public class StatsSummary
implements DoubleConsumer {
    private long count = 0L;
    private double sum = 0.0;
    private Double min;
    private Double max;

    public StatsSummary() {
    }

    StatsSummary(long count, double sum, double min, double max) {
        this.count = count;
        this.sum = sum;
        this.min = min;
        this.max = max;
    }

    @Override
    public void accept(double value) {
        ++this.count;
        this.sum += value;
        this.min = this.min == null ? value : (value < this.min ? value : this.min);
        this.max = this.max == null ? value : (value > this.max ? value : this.max);
    }

    public double getMin() {
        return this.min == null ? 0.0 : this.min;
    }

    public double getMax() {
        return this.max == null ? 0.0 : this.max;
    }

    public double getAverage() {
        return (double)this.count == 0.0 ? 0.0 : this.sum / (double)this.count;
    }

    public double getSum() {
        return this.sum;
    }

    public long getCount() {
        return this.count;
    }

    public void reset() {
        this.count = 0L;
        this.sum = 0.0;
        this.min = null;
        this.max = null;
    }

    public int hashCode() {
        return Objects.hash(this.count, this.sum, this.min, this.max);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StatsSummary other = (StatsSummary)obj;
        return Objects.equals(this.count, other.count) && Objects.equals(this.sum, other.sum) && Objects.equals(this.min, other.min) && Objects.equals(this.max, other.max);
    }

    public String toString() {
        return Strings.format("%s{count=%d, sum=%f, min=%f, average=%f, max=%f}", this.getClass().getSimpleName(), this.getCount(), this.getSum(), this.getMin(), this.getAverage(), this.getMax());
    }
}

