/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ListenableFuture;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshots;
import org.elasticsearch.index.snapshots.blobstore.SnapshotFiles;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.IndexMetaDataGenerations;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.RepositoryMissingException;
import org.elasticsearch.repositories.ShardGeneration;
import org.elasticsearch.repositories.ShardSnapshotInfo;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotState;
import org.elasticsearch.threadpool.ThreadPool;

public class IndexSnapshotsService {
    private static final Logger logger = LogManager.getLogger(IndexSnapshotsService.class);
    private static final Comparator<Tuple<SnapshotId, RepositoryData.SnapshotDetails>> START_TIME_COMPARATOR = Comparator.comparingLong(pair -> ((RepositoryData.SnapshotDetails)pair.v2()).getStartTimeMillis()).thenComparing(Tuple::v1);
    private final RepositoriesService repositoriesService;

    public IndexSnapshotsService(RepositoriesService repositoriesService) {
        this.repositoriesService = repositoriesService;
    }

    public void getLatestSuccessfulSnapshotForShard(String repositoryName, ShardId shardId, ActionListener<Optional<ShardSnapshotInfo>> originalListener) {
        assert (repositoryName != null);
        ActionListener<Optional<ShardSnapshotInfo>> listener = originalListener.delegateResponse((delegate, err) -> delegate.onFailure(new RepositoryException(repositoryName, "Unable to find the latest snapshot for shard [" + String.valueOf(shardId) + "]", (Throwable)err, new Object[0])));
        Repository repository = this.getRepository(repositoryName);
        if (repository == null) {
            listener.onFailure(new RepositoryMissingException(repositoryName));
            return;
        }
        String indexName = shardId.getIndexName();
        ListenableFuture<RepositoryData> repositoryDataStepListener = new ListenableFuture<RepositoryData>();
        ListenableFuture<FetchShardSnapshotContext> snapshotInfoStepListener = new ListenableFuture<FetchShardSnapshotContext>();
        repositoryDataStepListener.addListener(listener.delegateFailureAndWrap((delegate, repositoryData) -> {
            if (!repositoryData.hasIndex(indexName)) {
                logger.debug("{} repository [{}] has no snapshots of this index", (Object)shardId, (Object)repositoryName);
                delegate.onResponse(Optional.empty());
                return;
            }
            IndexId indexId = repositoryData.resolveIndexId(indexName);
            List<SnapshotId> indexSnapshots = repositoryData.getSnapshots(indexId);
            Optional<SnapshotId> latestSnapshotId = indexSnapshots.stream().map(snapshotId -> Tuple.tuple(snapshotId, repositoryData.getSnapshotDetails((SnapshotId)snapshotId))).filter(s -> ((RepositoryData.SnapshotDetails)s.v2()).getSnapshotState() != null && ((RepositoryData.SnapshotDetails)s.v2()).getSnapshotState() == SnapshotState.SUCCESS).filter(s -> ((RepositoryData.SnapshotDetails)s.v2()).getStartTimeMillis() != -1L && ((RepositoryData.SnapshotDetails)s.v2()).getEndTimeMillis() != -1L).max(START_TIME_COMPARATOR).map(Tuple::v1);
            if (latestSnapshotId.isEmpty()) {
                logger.debug("{} could not determine latest snapshot of this shard in repository [{}]", (Object)shardId, (Object)repositoryName);
                delegate.onResponse(Optional.empty());
                return;
            }
            SnapshotId snapshotId2 = latestSnapshotId.get();
            logger.debug("{} fetching details of [{}][{}]", (Object)shardId, (Object)repositoryName, (Object)snapshotId2);
            repository.getSnapshotInfo(snapshotId2, snapshotInfoStepListener.map(snapshotInfo -> new FetchShardSnapshotContext(repository, (RepositoryData)repositoryData, indexId, shardId, (SnapshotInfo)snapshotInfo)));
        }));
        snapshotInfoStepListener.addListener(listener.delegateFailureAndWrap((delegate, fetchSnapshotContext) -> {
            assert (ThreadPool.assertCurrentThreadPool("snapshot_meta"));
            SnapshotInfo snapshotInfo = fetchSnapshotContext.getSnapshotInfo();
            if (snapshotInfo == null || snapshotInfo.state() != SnapshotState.SUCCESS) {
                logger.debug("{} failed to retrieve snapshot details from [{}]", (Object)shardId, (Object)repositoryName);
                delegate.onResponse(Optional.empty());
                return;
            }
            BlobStoreIndexShardSnapshots blobStoreIndexShardSnapshots = fetchSnapshotContext.getBlobStoreIndexShardSnapshots();
            String indexMetadataId = fetchSnapshotContext.getIndexMetadataId();
            Optional<ShardSnapshotInfo> indexShardSnapshotInfo = blobStoreIndexShardSnapshots.snapshots().stream().filter(snapshotFiles -> snapshotFiles.snapshot().equals(snapshotInfo.snapshotId().getName())).findFirst().map(snapshotFiles -> fetchSnapshotContext.createIndexShardSnapshotInfo(indexMetadataId, (SnapshotFiles)snapshotFiles));
            delegate.onResponse(indexShardSnapshotInfo);
        }));
        repository.getRepositoryData(EsExecutors.DIRECT_EXECUTOR_SERVICE, repositoryDataStepListener);
    }

    private Repository getRepository(String repositoryName) {
        ProjectId projectId = ProjectId.DEFAULT;
        return this.repositoriesService.repositoryOrNull(projectId, repositoryName);
    }

    private static class FetchShardSnapshotContext {
        private final Repository repository;
        private final RepositoryData repositoryData;
        private final IndexId indexId;
        private final ShardId shardId;
        private final SnapshotInfo snapshotInfo;

        FetchShardSnapshotContext(Repository repository, RepositoryData repositoryData, IndexId indexId, ShardId shardId, SnapshotInfo snapshotInfo) {
            this.repository = repository;
            this.repositoryData = repositoryData;
            this.indexId = indexId;
            this.shardId = shardId;
            this.snapshotInfo = snapshotInfo;
        }

        private String getIndexMetadataId() throws IOException {
            IndexMetaDataGenerations indexMetaDataGenerations = this.repositoryData.indexMetaDataGenerations();
            String indexMetadataIdentifier = indexMetaDataGenerations.snapshotIndexMetadataIdentifier(this.snapshotInfo.snapshotId(), this.indexId);
            if (indexMetadataIdentifier != null) {
                return indexMetadataIdentifier;
            }
            IndexMetadata indexMetadata = this.repository.getSnapshotIndexMetaData(this.repositoryData, this.snapshotInfo.snapshotId(), this.indexId);
            return IndexMetaDataGenerations.buildUniqueIdentifier(indexMetadata);
        }

        private BlobStoreIndexShardSnapshots getBlobStoreIndexShardSnapshots() throws IOException {
            BlobStoreRepository blobStoreRepository = (BlobStoreRepository)this.repository;
            ShardGeneration shardGen = this.repositoryData.shardGenerations().getShardGen(this.indexId, this.shardId.getId());
            return blobStoreRepository.getBlobStoreIndexShardSnapshots(this.indexId, this.shardId.getId(), shardGen);
        }

        private ShardSnapshotInfo createIndexShardSnapshotInfo(String indexMetadataId, SnapshotFiles snapshotFiles) {
            return new ShardSnapshotInfo(this.indexId, this.shardId, this.snapshotInfo.snapshot(), indexMetadataId, snapshotFiles.shardStateIdentifier(), this.snapshotInfo.startTime());
        }

        SnapshotInfo getSnapshotInfo() {
            return this.snapshotInfo;
        }
    }
}

